/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.jmx.internal;

import java.net.InetAddress;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.ReflectionException;
import mx4j.AbstractDynamicMBean;
import org.apache.geode.admin.AdminDistributedSystem;
import org.apache.geode.admin.AdminException;
import org.apache.geode.admin.CacheVm;
import org.apache.geode.admin.ConfigurationParameter;
import org.apache.geode.admin.GemFireMemberStatus;
import org.apache.geode.admin.RegionSubRegionSnapshot;
import org.apache.geode.admin.StatisticResource;
import org.apache.geode.admin.SystemMember;
import org.apache.geode.admin.SystemMemberCacheServer;
import org.apache.geode.admin.jmx.Agent;
import org.apache.geode.admin.jmx.internal.AdminDistributedSystemJmxImpl;
import org.apache.geode.admin.jmx.internal.CacheServerJmxImpl;
import org.apache.geode.admin.jmx.internal.MBeanUtil;
import org.apache.geode.admin.jmx.internal.NotificationForwarder;
import org.apache.geode.admin.jmx.internal.SystemMemberCacheJmxImpl;
import org.apache.geode.admin.jmx.internal.SystemMemberJmx;
import org.apache.geode.cache.InterestPolicy;
import org.apache.geode.cache.SubscriptionAttributes;
import org.apache.geode.internal.GemFireVersion;
import org.apache.geode.internal.admin.remote.ClientHealthStats;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;

public class MemberInfoWithStatsMBean
extends AbstractDynamicMBean
implements NotificationEmitter {
    private static final Logger logger = LogService.getLogger();
    private static final int MAX_ATTRIBUTES_COUNT = 3;
    private static final int MAX_OPERATIONS_COUNT = 3;
    private static final int MAX_NOTIFICATIONS_COUNT = 9;
    private static final String NOT_AVAILABLE_STR = "N/A";
    private static final String NOT_AVAILABLE = null;
    private static final Number NOT_AVAILABLE_NUMBER = null;
    private static final String PLACE_HOLDER_ROOT_REGION = "/Root/";
    private static final String REGION_QUERY_EXPRESSION = "*GemFire.Cache*:*,owner={0},type=Region";
    private static final String STATS_QUERY_EXPRESSION = "*GemFire.Statistic*:*,source={0},name={1}";
    static final String MBEAN_NAME = "GemFire:type=MemberInfoWithStatsMBean";
    private ObjectName objectName;
    private String version;
    private int refreshInterval;
    private String id;
    private Agent agent;
    private AdminDistributedSystemJmxImpl adminDSJmx;
    private NotificationForwarder forwarder;
    private boolean isInitialized;
    private static final String TYPE_NAME_CACHESERVER = "Cache Server";
    private static final String TYPE_NAME_APPLICATION = "Application Peer";
    private static final String MEMBER_ID = "gemfire.member.id.string";
    private static final String MEMBER_NAME = "gemfire.member.name.string";
    private static final String MEMBER_HOST = "gemfire.member.host.string";
    private static final String MEMBER_PORT = "gemfire.member.port.int";
    private static final String MEMBER_UPTIME = "gemfire.member.uptime.long";
    private static final String MEMBER_CLIENTS = "gemfire.member.clients.map";
    private static final String MEMBER_REGIONS = "gemfire.member.regions.map";
    private static final String MEMBER_TYPE = "gemfire.member.type.string";
    private static final String IS_SERVER = "gemfire.member.isserver.boolean";
    private static final String IS_GATEWAY = "gemfire.member.isgateway.boolean";
    private static final String MEMBER_STATSAMPLING_ENABLED = "gemfire.member.config.statsamplingenabled.boolean";
    private static final String MEMBER_TIME_STATS_ENABLED = "gemfire.member.config.timestatsenabled.boolean";
    private static final String STATS_PROCESSCPUTIME = "gemfire.member.stat.processcputime.long";
    private static final String STATS_CPUS = "gemfire.member.stat.cpus.int";
    private static final String STATS_USEDMEMORY = "gemfire.member.stat.usedmemory.long";
    private static final String STATS_MAXMEMORY = "gemfire.member.stat.maxmemory.long";
    private static final String STATS_GETS = "gemfire.member.stat.gets.int";
    private static final String STATS_GETTIME = "gemfire.member.stat.gettime.long";
    private static final String STATS_PUTS = "gemfire.member.stat.puts.int";
    private static final String STATS_PUTTIME = "gemfire.member.stat.puttime.long";
    private static final String REGION_NAME = "gemfire.region.name.string";
    private static final String REGION_PATH = "gemfire.region.path.string";
    private static final String REGION_SCOPE = "gemfire.region.scope.string";
    private static final String REGION_DATAPOLICY = "gemfire.region.datapolicy.string";
    private static final String REGION_INTERESTPOLICY = "gemfire.region.interestpolicy.string";
    private static final String REGION_ENTRYCOUNT = "gemfire.region.entrycount.int";
    private static final String REGION_DISKATTRS = "gemfire.region.diskattrs.string";
    private static final String CLIENT_ID = "gemfire.client.id.string";
    private static final String CLIENT_NAME = "gemfire.client.name.string";
    private static final String CLIENT_HOST = "gemfire.client.host.string";
    private static final String CLIENT_QUEUESIZE = "gemfire.client.queuesize.int";
    private static final String CLIENT_STATS_GETS = "gemfire.client.stats.gets.int";
    private static final String CLIENT_STATS_PUTS = "gemfire.client.stats.puts.int";
    private static final String CLIENT_STATS_CACHEMISSES = "gemfire.client.stats.cachemisses.int";
    private static final String CLIENT_STATS_CPUUSAGE = "gemfire.client.stats.cpuusage.long";
    private static final String CLIENT_STATS_CPUS = "gemfire.client.stats.cpus.int";
    private static final String CLIENT_STATS_UPDATETIME = "gemfire.client.stats.updatetime.long";
    private static final String CLIENT_STATS_THREADS = "gemfire.client.stats.threads.int";

    MemberInfoWithStatsMBean(Agent agent) throws OperationsException, MBeanRegistrationException, AdminException {
        this.agent = agent;
        this.objectName = ObjectName.getInstance(MBEAN_NAME);
        this.version = GemFireVersion.getGemFireVersion();
        this.refreshInterval = -1;
        this.id = NOT_AVAILABLE_STR;
        this.forwarder = new NotificationForwarder(agent.getMBeanServer());
    }

    protected MBeanAttributeInfo[] createMBeanAttributeInfo() {
        MBeanAttributeInfo[] attributesInfo = new MBeanAttributeInfo[]{new MBeanAttributeInfo("Version", String.class.getName(), "GemFire Enterprise Version", true, false, false), new MBeanAttributeInfo("RefreshInterval", String.class.getName(), "The interval (in seconds) between auto-polling for updating member & statistics resources. If this is '-1', it means the this MBean has not yet been initialized. First call to getMembers operation will initialize this MBean.", true, false, false), new MBeanAttributeInfo("Id", String.class.getName(), "Identifier of the GemFire Enterprise. If this is 'N/A', it means the this MBean has not yet been initialized. First call to getMembers operation will initialize this MBean.", true, false, false)};
        return attributesInfo;
    }

    protected MBeanOperationInfo[] createMBeanOperationInfo() {
        MBeanOperationInfo[] operationsInfo = new MBeanOperationInfo[3];
        operationsInfo[0] = new MBeanOperationInfo("getMembers", "Returns ids as strings for all the members - Application Peers & Cache Servers.", new MBeanParameterInfo[0], String[].class.getName(), 2);
        MBeanParameterInfo[] getMemberDetailsArgs = new MBeanParameterInfo[]{new MBeanParameterInfo("memberId", String.class.getName(), "Id of the member for all the details are to be retrieved.")};
        operationsInfo[1] = new MBeanOperationInfo("getMemberDetails", "Returns details for a given member", getMemberDetailsArgs, Map.class.getName(), 2);
        MBeanParameterInfo[] getRegionSnapArgs = new MBeanParameterInfo[]{new MBeanParameterInfo("memberId", String.class.getName(), "Id of the member on which we want to discover all the region MBean.")};
        operationsInfo[2] = new MBeanOperationInfo("getRegions", "Returns a java.util.Map of details of regions on a member", getRegionSnapArgs, Map.class.getName(), 2);
        return operationsInfo;
    }

    protected MBeanNotificationInfo[] createMBeanNotificationInfo() {
        MBeanNotificationInfo[] notificationsInfo = new MBeanNotificationInfo[9];
        String[] notificationTypes = new String[]{"gemfire.distributedsystem.member.joined"};
        notificationsInfo[0] = new MBeanNotificationInfo(notificationTypes, Notification.class.getName(), "A GemFire manager, cache, or other member has joined this distributed system.");
        notificationTypes = new String[]{"gemfire.distributedsystem.member.left"};
        notificationsInfo[1] = new MBeanNotificationInfo(notificationTypes, Notification.class.getName(), "A GemFire manager, cache, or other member has left the distributed system.");
        notificationTypes = new String[]{"gemfire.distributedsystem.member.crashed"};
        notificationsInfo[2] = new MBeanNotificationInfo(notificationTypes, Notification.class.getName(), "A member of this distributed system has crashed instead of leaving cleanly.");
        notificationTypes = new String[]{"gemfire.distributedsystem.alert"};
        notificationsInfo[3] = new MBeanNotificationInfo(notificationTypes, Notification.class.getName(), "A member of this distributed system has generated an alert.");
        notificationTypes = new String[]{"gemfire.distributedsystem.disconnect"};
        notificationsInfo[4] = new MBeanNotificationInfo(notificationTypes, Notification.class.getName(), "A GemFire manager, cache, or other member has joined this distributed system.");
        notificationTypes = new String[]{"gemfire.distributedsystem.cache.created"};
        notificationsInfo[5] = new MBeanNotificationInfo(notificationTypes, Notification.class.getName(), "A cache got created on a member of this distributed system.");
        notificationTypes = new String[]{"gemfire.distributedsystem.cache.closed"};
        notificationsInfo[6] = new MBeanNotificationInfo(notificationTypes, Notification.class.getName(), "A cache is closed on a member of this distributed system.");
        notificationTypes = new String[]{"gemfire.distributedsystem.cache.region.created"};
        notificationsInfo[7] = new MBeanNotificationInfo(notificationTypes, Notification.class.getName(), "A region is created in a cache on a member of this distributed system.");
        notificationTypes = new String[]{"gemfire.distributedsystem.cache.region.lost"};
        notificationsInfo[8] = new MBeanNotificationInfo(notificationTypes, Notification.class.getName(), "A region was removed from a cache on a member of this distributed system.");
        return notificationsInfo;
    }

    ObjectName getObjectName() {
        return this.objectName;
    }

    public String getVersion() {
        return this.version;
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public String getId() {
        return this.id;
    }

    private ObjectName connectToSystem() throws OperationsException, AdminException {
        ObjectName adminDsObjName = this.agent.connectToSystem();
        AdminDistributedSystem adminDS = this.agent.getDistributedSystem();
        if (this.adminDSJmx == null && adminDS instanceof AdminDistributedSystemJmxImpl) {
            this.adminDSJmx = (AdminDistributedSystemJmxImpl)adminDS;
            this.refreshInterval = this.adminDSJmx.getRefreshInterval();
            this.id = this.adminDSJmx.getId();
            this.forwarder.registerNotificationListener(this.adminDSJmx.getObjectName());
        }
        return adminDsObjName;
    }

    private SystemMemberJmx findMember(String memberId) throws AdminException {
        SystemMemberJmx foundMember = null;
        if (this.agent.isConnected()) {
            SystemMember[] members;
            for (SystemMember app : members = this.adminDSJmx.getSystemMemberApplications()) {
                if (!app.getId().equals(memberId)) continue;
                foundMember = (SystemMemberJmx)app;
                break;
            }
            if (foundMember == null) {
                for (SystemMember cacheVm : members = this.adminDSJmx.getCacheVms()) {
                    if (!cacheVm.getId().equals(memberId)) continue;
                    foundMember = (SystemMemberJmx)cacheVm;
                    break;
                }
            }
        }
        return foundMember;
    }

    public String[] getMembers() throws OperationsException {
        String[] members = new String[]{};
        try {
            if (!this.isInitialized) {
                this.initializeAll();
            }
            if (this.adminDSJmx != null) {
                CacheVm[] cacheVms = this.adminDSJmx.getCacheVms();
                SystemMember[] appVms = this.adminDSJmx.getSystemMemberApplications();
                ArrayList<String> membersList = new ArrayList<String>();
                if (cacheVms != null && cacheVms.length != 0) {
                    for (SystemMember systemMember : cacheVms) {
                        membersList.add(systemMember.getId());
                    }
                }
                if (appVms != null && appVms.length != 0) {
                    for (SystemMember systemMember : appVms) {
                        membersList.add(systemMember.getId());
                    }
                }
                members = new String[membersList.size()];
                members = membersList.toArray(members);
            }
        }
        catch (AdminException e) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.MemberInfoWithStatsMBean_EXCEPTION_FOR_OPERATION_0, "getMembers"), (Throwable)e);
            throw new OperationsException(e.getMessage());
        }
        catch (Exception e) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.MemberInfoWithStatsMBean_EXCEPTION_FOR_OPERATION_0, "getMembers"), (Throwable)e);
            throw new OperationsException(e.getMessage());
        }
        return members;
    }

    public Map<String, Map<String, ?>> getRegions(String memberId) throws OperationsException {
        Map<String, Map<String, ?>> regionsInfo = new LinkedHashMap();
        if (memberId != null) {
            try {
                SystemMemberCacheJmxImpl cache;
                SystemMemberJmx foundMember = this.findMember(memberId);
                if (foundMember != null && (cache = (SystemMemberCacheJmxImpl)foundMember.getCache()) != null) {
                    Map<String, ObjectName> existingRegionMbeans = this.getExistingRegionMbeansFullPaths(memberId);
                    regionsInfo = this.getAllRegionsDetails(cache, existingRegionMbeans);
                    existingRegionMbeans.clear();
                }
            }
            catch (AdminException e) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.MemberInfoWithStatsMBean_EXCEPTION_FOR_OPERATION_0_FOR_MEMBER_1, new Object[]{"getRegions", memberId}), (Throwable)e);
                throw new OperationsException(e.getMessage());
            }
            catch (Exception e) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.MemberInfoWithStatsMBean_EXCEPTION_FOR_OPERATION_0_FOR_MEMBER_1, new Object[]{"getRegions", memberId}), (Throwable)e);
                throw new OperationsException(e.getMessage());
            }
        }
        return regionsInfo;
    }

    private void initializeAll() throws OperationsException {
        try {
            this.connectToSystem();
            if (this.adminDSJmx != null) {
                CacheVm[] cacheVms = this.adminDSJmx.getCacheVms();
                for (int i = 0; i < cacheVms.length; ++i) {
                    try {
                        this.initializeCacheRegionsAndStats((SystemMemberJmx)((Object)cacheVms[i]));
                        continue;
                    }
                    catch (AdminException e) {
                        logger.info(LocalizedMessage.create(LocalizedStrings.MemberInfoWithStatsMBean_EXCEPTION_WHILE_INTIALIZING_0_CONTINUING, cacheVms[i].getId()), (Throwable)e);
                    }
                }
                SystemMember[] appVms = this.adminDSJmx.getSystemMemberApplications();
                for (int i = 0; i < appVms.length; ++i) {
                    try {
                        this.initializeCacheRegionsAndStats((SystemMemberJmx)appVms[i]);
                        continue;
                    }
                    catch (AdminException e) {
                        logger.info(LocalizedMessage.create(LocalizedStrings.MemberInfoWithStatsMBean_EXCEPTION_WHILE_INTIALIZING_0_CONTINUING, appVms[i].getId()), (Throwable)e);
                    }
                }
            }
        }
        catch (AdminException e) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.MemberInfoWithStatsMBean_EXCEPTION_WHILE_INTIALIZING), (Throwable)e);
            throw new OperationsException(e.getMessage());
        }
        catch (Exception e) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.MemberInfoWithStatsMBean_EXCEPTION_WHILE_INTIALIZING), (Throwable)e);
            throw new OperationsException(e.getMessage());
        }
        this.isInitialized = true;
    }

    private void initializeCacheRegionsAndStats(SystemMemberJmx memberJmx) throws OperationsException, AdminException {
        if (memberJmx != null) {
            SystemMemberCacheJmxImpl cache = (SystemMemberCacheJmxImpl)memberJmx.getCache();
            if (cache != null) {
                RegionSubRegionSnapshot regionSnapshot = cache.getRegionSnapshot();
                this.initializeRegionSubRegions(cache, regionSnapshot);
            }
            this.initStats(memberJmx);
        }
    }

    private void initStats(SystemMemberJmx memberJmx) throws AdminException {
        StatisticResource[] statResources;
        for (StatisticResource statResource : statResources = memberJmx.getStats()) {
            statResource.getStatistics();
        }
    }

    private void initializeRegionSubRegions(SystemMemberCacheJmxImpl cache, RegionSubRegionSnapshot regionSnapshot) throws MalformedObjectNameException, AdminException {
        String fullPath = regionSnapshot.getFullPath();
        if (!fullPath.equals(PLACE_HOLDER_ROOT_REGION)) {
            fullPath = fullPath.substring(PLACE_HOLDER_ROOT_REGION.length() - 1);
            cache.manageRegion(fullPath);
        }
        Set subRegionSnapshots = regionSnapshot.getSubRegionSnapshots();
        for (RegionSubRegionSnapshot subRegion : subRegionSnapshots) {
            try {
                this.initializeRegionSubRegions(cache, subRegion);
            }
            catch (AdminException e) {
                logger.info(LocalizedMessage.create(LocalizedStrings.MemberInfoWithStatsMBean_EXCEPTION_WHILE_INTIALIZING_0_CONTINUING, subRegion.getFullPath()), (Throwable)e);
            }
        }
    }

    public Map<String, Object> getMemberDetails(String memberId) throws OperationsException {
        TreeMap<String, Object> allDetails = new TreeMap<String, Object>();
        if (memberId != null) {
            try {
                SystemMemberJmx member = this.findMember(memberId);
                if (member != null) {
                    ConfigurationParameter[] configParams;
                    SystemMemberCacheJmxImpl cache = (SystemMemberCacheJmxImpl)member.getCache();
                    GemFireMemberStatus snapshot = cache.getSnapshot();
                    boolean isServer = snapshot.getIsServer();
                    boolean isGatewayHub = snapshot.getIsGatewayHub();
                    allDetails.put(MEMBER_ID, member.getId());
                    allDetails.put(MEMBER_NAME, member.getName());
                    String host = member.getHost();
                    InetAddress hostAddr = member.getHostAddress();
                    if (hostAddr != null) {
                        host = hostAddr.getHostName();
                    }
                    allDetails.put(MEMBER_HOST, host);
                    allDetails.put(MEMBER_UPTIME, snapshot.getUpTime());
                    allDetails.put(IS_SERVER, isServer);
                    allDetails.put(IS_GATEWAY, isGatewayHub);
                    String memberType = "";
                    memberType = member instanceof CacheServerJmxImpl ? TYPE_NAME_CACHESERVER : TYPE_NAME_APPLICATION;
                    allDetails.put(MEMBER_TYPE, memberType);
                    Map<String, ObjectName> existingRegionMbeans = this.getExistingRegionMbeansFullPaths(memberId);
                    allDetails.put(MEMBER_REGIONS, this.getAllRegionsDetails(cache, existingRegionMbeans));
                    existingRegionMbeans.clear();
                    allDetails.put(MEMBER_CLIENTS, this.getClientDetails(snapshot));
                    boolean statSamplingEnabled = true;
                    for (ConfigurationParameter configParam : configParams = member.getConfiguration()) {
                        if ("statistic-sampling-enabled".equals(configParam.getName())) {
                            allDetails.put(MEMBER_STATSAMPLING_ENABLED, configParam.getValue());
                            statSamplingEnabled = Boolean.parseBoolean("" + configParam.getValue());
                            continue;
                        }
                        if (!"enable-time-statistics".equals(configParam.getName())) continue;
                        allDetails.put(MEMBER_TIME_STATS_ENABLED, configParam.getValue());
                    }
                    allDetails.putAll(this.getRequiredStats(member, statSamplingEnabled));
                    SystemMemberCacheServer[] cacheServers = cache.getCacheServers();
                    if (cacheServers.length == 0) {
                        cache.refresh();
                        cacheServers = cache.getCacheServers();
                    }
                    Integer memberCacheServerPort = 0;
                    if (cacheServers.length != 0) {
                        memberCacheServerPort = cacheServers[0].getPort();
                    }
                    allDetails.put(MEMBER_PORT, memberCacheServerPort);
                }
            }
            catch (AdminException e) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.MemberInfoWithStatsMBean_EXCEPTION_FOR_OPERATION_0_FOR_MEMBER_1, new Object[]{"getMemberDetails", memberId}), (Throwable)e);
                throw new OperationsException(e.getMessage());
            }
            catch (Exception e) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.MemberInfoWithStatsMBean_EXCEPTION_FOR_OPERATION_0_FOR_MEMBER_1, new Object[]{"getMemberDetails", memberId}), (Throwable)e);
                throw new OperationsException(e.getMessage());
            }
        }
        return allDetails;
    }

    private Map<String, Map<String, ?>> getClientDetails(GemFireMemberStatus snapshot) {
        LinkedHashMap clientsInfo = new LinkedHashMap();
        Set connectedClients = snapshot.getConnectedClients();
        if (!connectedClients.isEmpty()) {
            Map clientHealthStatsMap = snapshot.getClientHealthStats();
            Iterator iterator = connectedClients.iterator();
            while (iterator.hasNext()) {
                HashMap<String, Object> clientData = new HashMap<String, Object>();
                String clientId = (String)iterator.next();
                String host = snapshot.getClientHostName(clientId);
                clientData.put(CLIENT_ID, clientId);
                clientData.put(CLIENT_NAME, MemberInfoWithStatsMBean.extractClientName(clientId, host));
                clientData.put(CLIENT_HOST, host);
                clientData.put(CLIENT_QUEUESIZE, snapshot.getClientQueueSize(clientId));
                ClientHealthStats clientHealthStats = (ClientHealthStats)clientHealthStatsMap.get(clientId);
                if (clientHealthStats != null) {
                    clientData.put(CLIENT_STATS_GETS, clientHealthStats.getNumOfGets());
                    clientData.put(CLIENT_STATS_PUTS, clientHealthStats.getNumOfPuts());
                    clientData.put(CLIENT_STATS_CACHEMISSES, clientHealthStats.getNumOfMisses());
                    clientData.put(CLIENT_STATS_CPUUSAGE, clientHealthStats.getProcessCpuTime());
                    clientData.put(CLIENT_STATS_CPUS, clientHealthStats.getCpus());
                    clientData.put(CLIENT_STATS_UPDATETIME, clientHealthStats.getUpdateTime().getTime());
                    clientData.put(CLIENT_STATS_THREADS, clientHealthStats.getNumOfThreads());
                } else {
                    clientData.put(CLIENT_STATS_GETS, 0);
                    clientData.put(CLIENT_STATS_PUTS, 0);
                    clientData.put(CLIENT_STATS_CACHEMISSES, 0);
                    clientData.put(CLIENT_STATS_CPUUSAGE, 0L);
                    clientData.put(CLIENT_STATS_CPUS, 0);
                    clientData.put(CLIENT_STATS_UPDATETIME, 0L);
                    clientData.put(CLIENT_STATS_THREADS, 0);
                }
                clientsInfo.put(clientId, clientData);
            }
        }
        return clientsInfo;
    }

    private Map<String, Map<String, ?>> getAllRegionsDetails(SystemMemberCacheJmxImpl cache, Map<String, ObjectName> existingRegionMbeans) throws OperationsException {
        TreeMap regionsInfo = new TreeMap();
        if (cache != null) {
            try {
                RegionSubRegionSnapshot regionSnapshot = cache.getRegionSnapshot();
                this.collectAllRegionsDetails(cache, regionSnapshot, regionsInfo, existingRegionMbeans);
            }
            catch (AdminException e) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.ONE_ARG, "Exception occurred while getting region details."), (Throwable)e);
                throw new OperationsException(e.getMessage());
            }
            catch (Exception e) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.ONE_ARG, "Exception occurred while getting region details."), (Throwable)e);
                throw new OperationsException(e.getMessage());
            }
        }
        return regionsInfo;
    }

    private void collectAllRegionsDetails(SystemMemberCacheJmxImpl cache, RegionSubRegionSnapshot regionSnapshot, Map<String, Map<String, ?>> regionsInfo, Map<String, ObjectName> existingRegionMbeans) throws AdminException, OperationsException, MBeanException, ReflectionException {
        String fullPath = regionSnapshot.getFullPath();
        if (!fullPath.equals(PLACE_HOLDER_ROOT_REGION)) {
            InterestPolicy interestPolicy;
            Object attribute;
            fullPath = fullPath.substring(PLACE_HOLDER_ROOT_REGION.length() - 1);
            String name = regionSnapshot.getName();
            Integer entryCount = regionSnapshot.getEntryCount();
            TreeMap<String, Object> details = new TreeMap<String, Object>();
            details.put(REGION_NAME, name);
            details.put(REGION_PATH, fullPath);
            details.put(REGION_ENTRYCOUNT, entryCount);
            ObjectName regionObjectName = existingRegionMbeans.get(fullPath);
            if (regionObjectName == null) {
                regionObjectName = cache.manageRegion(fullPath);
            }
            attribute = (attribute = this.getAttribute(regionObjectName, "scope", NOT_AVAILABLE)) != null ? attribute.toString() : attribute;
            details.put(REGION_SCOPE, attribute);
            attribute = this.getAttribute(regionObjectName, "dataPolicy", NOT_AVAILABLE);
            attribute = attribute != null ? attribute.toString() : attribute;
            details.put(REGION_DATAPOLICY, attribute);
            SubscriptionAttributes interestPolicyAttr = (SubscriptionAttributes)this.getAttribute(regionObjectName, "subscriptionAttributes", null);
            String interestPolicyStr = NOT_AVAILABLE;
            if (interestPolicyAttr != null && (interestPolicy = interestPolicyAttr.getInterestPolicy()) != null) {
                interestPolicyStr = interestPolicy.toString();
            }
            details.put(REGION_INTERESTPOLICY, interestPolicyStr);
            attribute = this.getAttribute(regionObjectName, "diskWriteAttributes", NOT_AVAILABLE);
            attribute = attribute != null ? attribute.toString() : attribute;
            details.put(REGION_DISKATTRS, attribute);
            regionsInfo.put(fullPath, details);
        }
        Set subRegionSnapshots = regionSnapshot.getSubRegionSnapshots();
        for (RegionSubRegionSnapshot subRegion : subRegionSnapshots) {
            this.collectAllRegionsDetails(cache, subRegion, regionsInfo, existingRegionMbeans);
        }
    }

    private static boolean isIPv6(String host) {
        return host.contains(":");
    }

    private static boolean isIPv4(String host) {
        String regex = "\\d{1,3}.\\d{1,3}.\\d{1,3}.\\d{1,3}";
        return host.matches(regex);
    }

    private static String extractClientName(String clientId, String host) {
        String hostExcludedId = "";
        if ((MemberInfoWithStatsMBean.isIPv6(host) || MemberInfoWithStatsMBean.isIPv4(host)) && clientId.startsWith(host)) {
            hostExcludedId = clientId.substring(host.length());
        } else {
            int firstDotIndex = host.indexOf(".");
            if (firstDotIndex != -1) {
                String hostShortName = host.substring(0, firstDotIndex);
                hostExcludedId = clientId.substring(hostShortName.length());
            }
        }
        String vmPIDAndKindRegex = "\\(\\w+:\\w+\\)";
        String regex = "(\\<ec\\>)?:[0-9]+(:\\w+){2}+";
        String name = NOT_AVAILABLE;
        String temp = hostExcludedId;
        int openIndex = temp.indexOf("(");
        if (openIndex != -1) {
            regex = vmPIDAndKindRegex + regex;
        }
        if (temp.matches(regex)) {
            String[] splitted = temp.split(":");
            name = splitted[splitted.length - 1];
        }
        return name;
    }

    private Map<String, Object> getRequiredStats(SystemMemberJmx member, boolean statSamplingEnabled) throws OperationsException {
        TreeMap<String, Object> statDetails = new TreeMap<String, Object>();
        try {
            if (!statSamplingEnabled) {
                statDetails.put(STATS_PROCESSCPUTIME, NOT_AVAILABLE_NUMBER);
                statDetails.put(STATS_CPUS, NOT_AVAILABLE_NUMBER);
                statDetails.put(STATS_MAXMEMORY, NOT_AVAILABLE_NUMBER);
                statDetails.put(STATS_USEDMEMORY, NOT_AVAILABLE_NUMBER);
                statDetails.put(STATS_GETS, NOT_AVAILABLE_NUMBER);
                statDetails.put(STATS_GETTIME, NOT_AVAILABLE_NUMBER);
                statDetails.put(STATS_PUTS, NOT_AVAILABLE_NUMBER);
                statDetails.put(STATS_PUTTIME, NOT_AVAILABLE_NUMBER);
            } else {
                String type;
                int i;
                Number defaultVal;
                MBeanServer mBeanServer = this.agent.getMBeanServer();
                Number processCpuTime = defaultVal = NOT_AVAILABLE_NUMBER;
                Number cpus = defaultVal;
                Number maxMemory = defaultVal;
                Number usedMemory = defaultVal;
                Number gets = defaultVal;
                Number getTime = defaultVal;
                Number puts = defaultVal;
                Number putTime = defaultVal;
                ObjectName[] vmMemoryUsageStats = this.getExistingStats(member.getId(), "vmHeapMemoryStats");
                ObjectName[] vmStats = this.getExistingStats(member.getId(), "vmStats");
                ObjectName[] cachePerfStats = this.getExistingStats(member.getId(), "cachePerfStats");
                boolean needToReinit = false;
                if (vmMemoryUsageStats.length == 0 || vmStats.length == 0 || cachePerfStats.length == 0) {
                    needToReinit = true;
                }
                if (!needToReinit) {
                    for (i = 0; i < vmMemoryUsageStats.length; ++i) {
                        type = (String)mBeanServer.getAttribute(vmMemoryUsageStats[i], "type");
                        if (!"VMMemoryUsageStats".equals(type)) continue;
                        maxMemory = (Number)this.getAttribute(vmMemoryUsageStats[i], "maxMemory", defaultVal);
                        break;
                    }
                    boolean bl = needToReinit = 0L == maxMemory.longValue();
                }
                if (needToReinit) {
                    logger.info(LocalizedMessage.create(LocalizedStrings.MemberInfoWithStatsMBean_REINITIALIZING_STATS_FOR_0, member.getId()));
                    this.initStats(member);
                    vmMemoryUsageStats = this.getExistingStats(member.getId(), "vmHeapMemoryStats");
                    vmStats = this.getExistingStats(member.getId(), "vmStats");
                    cachePerfStats = this.getExistingStats(member.getId(), "cachePerfStats");
                }
                for (i = 0; i < vmMemoryUsageStats.length; ++i) {
                    type = (String)mBeanServer.getAttribute(vmMemoryUsageStats[i], "type");
                    if (!"VMMemoryUsageStats".equals(type)) continue;
                    maxMemory = (Number)this.getAttribute(vmMemoryUsageStats[i], "maxMemory", defaultVal);
                    usedMemory = (Number)this.getAttribute(vmMemoryUsageStats[i], "usedMemory", defaultVal);
                    break;
                }
                for (i = 0; i < vmStats.length; ++i) {
                    type = (String)mBeanServer.getAttribute(vmStats[i], "type");
                    if (!"VMStats".equals(type)) continue;
                    processCpuTime = (Number)this.getAttribute(vmStats[i], "processCpuTime", defaultVal);
                    cpus = (Number)this.getAttribute(vmStats[i], "cpus", defaultVal);
                    break;
                }
                for (i = 0; i < cachePerfStats.length; ++i) {
                    type = (String)mBeanServer.getAttribute(cachePerfStats[i], "type");
                    if (!"CachePerfStats".equals(type)) continue;
                    gets = (Number)this.getAttribute(cachePerfStats[i], "gets", defaultVal);
                    getTime = (Number)this.getAttribute(cachePerfStats[i], "getTime", defaultVal);
                    puts = (Number)this.getAttribute(cachePerfStats[i], "puts", defaultVal);
                    putTime = (Number)this.getAttribute(cachePerfStats[i], "putTime", defaultVal);
                    break;
                }
                statDetails.put(STATS_PROCESSCPUTIME, processCpuTime == NOT_AVAILABLE_NUMBER ? (Number)NOT_AVAILABLE_NUMBER : (Number)processCpuTime.longValue());
                statDetails.put(STATS_CPUS, cpus == NOT_AVAILABLE_NUMBER ? (Number)NOT_AVAILABLE_NUMBER : (Number)cpus.intValue());
                statDetails.put(STATS_MAXMEMORY, maxMemory == NOT_AVAILABLE_NUMBER ? (Number)NOT_AVAILABLE_NUMBER : (Number)maxMemory.longValue());
                statDetails.put(STATS_USEDMEMORY, usedMemory == NOT_AVAILABLE_NUMBER ? (Number)NOT_AVAILABLE_NUMBER : (Number)usedMemory.longValue());
                statDetails.put(STATS_GETS, gets == NOT_AVAILABLE_NUMBER ? (Number)NOT_AVAILABLE_NUMBER : (Number)gets.intValue());
                statDetails.put(STATS_GETTIME, getTime == NOT_AVAILABLE_NUMBER ? (Number)NOT_AVAILABLE_NUMBER : (Number)getTime.intValue());
                statDetails.put(STATS_PUTS, puts == NOT_AVAILABLE_NUMBER ? (Number)NOT_AVAILABLE_NUMBER : (Number)puts.intValue());
                statDetails.put(STATS_PUTTIME, putTime == NOT_AVAILABLE_NUMBER ? (Number)NOT_AVAILABLE_NUMBER : (Number)putTime.longValue());
            }
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw new OperationsException(e.getMessage());
        }
        return statDetails;
    }

    private Object getAttribute(ObjectName objectName, String attribute, Object unavailableValue) throws OperationsException, MBeanException, ReflectionException {
        Object value = null;
        MBeanServer mBeanServer = this.agent.getMBeanServer();
        value = mBeanServer.getAttribute(objectName, attribute);
        value = value != null ? value : unavailableValue;
        return value;
    }

    private Map<String, ObjectName> getExistingRegionMbeansFullPaths(String memberId) throws MalformedObjectNameException {
        HashMap<String, ObjectName> pathsToObjName = new HashMap<String, ObjectName>();
        if (memberId != null && memberId.trim().length() != 0) {
            Object[] params = new Object[]{MBeanUtil.makeCompliantMBeanNameProperty(memberId)};
            Set<ObjectName> queryNames = this.queryObjectNames(REGION_QUERY_EXPRESSION, params);
            for (ObjectName objectName : queryNames) {
                pathsToObjName.put(objectName.getKeyProperty("path"), objectName);
            }
        }
        return pathsToObjName;
    }

    private ObjectName[] getExistingStats(String memberId, String name) throws MalformedObjectNameException {
        ObjectName[] statObjectNames = new ObjectName[]{};
        if (memberId != null && memberId.trim().length() != 0) {
            Object[] params = new Object[]{MBeanUtil.makeCompliantMBeanNameProperty(memberId), name};
            Set<ObjectName> queryNames = this.queryObjectNames(STATS_QUERY_EXPRESSION, params);
            statObjectNames = new ObjectName[queryNames.size()];
            statObjectNames = queryNames.toArray(statObjectNames);
        }
        return statObjectNames;
    }

    private Set<ObjectName> queryObjectNames(String queryStr, Object ... params) throws MalformedObjectNameException {
        Set<ObjectName> queried = Collections.emptySet();
        queryStr = MessageFormat.format(queryStr, params);
        ObjectName queryExp = ObjectName.getInstance(queryStr);
        queried = this.agent.getMBeanServer().queryNames(null, queryExp);
        return queried;
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.forwarder.addNotificationListener(listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.forwarder.removeNotificationListener(listener);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.getMBeanInfo().getNotifications();
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.forwarder.removeNotificationListener(listener, filter, handback);
    }
}

