/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.jmx.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.geode.SystemFailure;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;

public class MailManager {
    private static final Logger logger = LogService.getLogger();
    private HashSet mailToSet = new HashSet();
    private String[] mailToAddresses = new String[0];
    protected String mailHost;
    protected String mailFrom;
    public static final String PROPERTY_MAIL_HOST = "mail.host";
    public static final String PROPERTY_MAIL_FROM = "mail.from";
    public static final String PROPERTY_MAIL_TO_LIST = "mail.toList";

    public MailManager() {
    }

    public MailManager(Properties mailProperties) {
        this.setMailProperties(mailProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MailManager(File mailPropertiesFile) throws IOException {
        Properties prop = new Properties();
        try (FileInputStream fio = new FileInputStream(mailPropertiesFile);){
            prop.load(fio);
        }
        this.setMailProperties(prop);
    }

    public MailManager(String mailHost, String mailFrom) {
        this.mailHost = mailHost;
        this.mailFrom = mailFrom;
    }

    public void sendEmail(String subject, String message) {
        this.processEmail(new EmailData(subject, message));
    }

    private void processEmail(EmailData emailData) {
        if (logger.isTraceEnabled()) {
            logger.trace("Entered MailManager:processEmail");
        }
        if (this.mailHost == null || this.mailHost.length() == 0 || emailData == null || this.mailToAddresses.length == 0) {
            logger.error(LocalizedMessage.create(LocalizedStrings.MailManager_REQUIRED_MAILSERVER_CONFIGURATION_NOT_SPECIFIED));
            if (logger.isDebugEnabled()) {
                logger.debug("Exited MailManager:processEmail: Not sending email as conditions not met");
            }
            return;
        }
        Session session = Session.getDefaultInstance((Properties)this.getMailHostConfiguration());
        MimeMessage mimeMessage = new MimeMessage(session);
        String subject = emailData.subject;
        String message = emailData.message;
        String mailToList = this.getMailToAddressesAsString();
        try {
            for (int i = 0; i < this.mailToAddresses.length; ++i) {
                mimeMessage.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(this.mailToAddresses[i]));
            }
            if (subject == null) {
                subject = LocalizedStrings.MailManager_ALERT_MAIL_SUBJECT.toLocalizedString();
            }
            mimeMessage.setSubject(subject);
            if (message == null) {
                message = "";
            }
            mimeMessage.setText(message);
            Transport.send((Message)mimeMessage);
            logger.info(LocalizedMessage.create(LocalizedStrings.MailManager_EMAIL_ALERT_HAS_BEEN_SENT_0_1_2, new Object[]{mailToList, subject, message}));
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable ex) {
            SystemFailure.checkFailure();
            StringBuilder buf = new StringBuilder();
            buf.append(LocalizedStrings.MailManager_AN_EXCEPTION_OCCURRED_WHILE_SENDING_EMAIL.toLocalizedString());
            buf.append(LocalizedStrings.MailManager_UNABLE_TO_SEND_EMAIL_PLEASE_CHECK_YOUR_EMAIL_SETTINGS_AND_LOG_FILE.toLocalizedString());
            buf.append("\n\n").append(LocalizedStrings.MailManager_EXCEPTION_MESSAGE_0.toLocalizedString(ex.getMessage()));
            buf.append("\n\n").append(LocalizedStrings.MailManager_FOLLOWING_EMAIL_WAS_NOT_DELIVERED.toLocalizedString());
            buf.append("\n\t").append(LocalizedStrings.MailManager_MAIL_HOST_0.toLocalizedString(this.mailHost));
            buf.append("\n\t").append(LocalizedStrings.MailManager_FROM_0.toLocalizedString(this.mailFrom));
            buf.append("\n\t").append(LocalizedStrings.MailManager_TO_0.toLocalizedString(mailToList));
            buf.append("\n\t").append(LocalizedStrings.MailManager_SUBJECT_0.toLocalizedString(subject));
            buf.append("\n\t").append(LocalizedStrings.MailManager_CONTENT_0.toLocalizedString(message));
            logger.error(buf.toString(), ex);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Exited MailManager:processEmail");
        }
    }

    public void close() {
    }

    private String getMailToAddressesAsString() {
        StringBuffer mailToList = new StringBuffer();
        for (int i = 0; i < this.mailToAddresses.length; ++i) {
            mailToList.append(this.mailToAddresses[i]);
            mailToList.append(", ");
        }
        return mailToList.toString();
    }

    private Properties getMailHostConfiguration() {
        Properties result = new Properties();
        if (this.mailHost == null) {
            this.mailHost = "";
        }
        if (this.mailFrom == null) {
            this.mailFrom = "";
        }
        result.setProperty(PROPERTY_MAIL_HOST, this.mailHost);
        result.put(PROPERTY_MAIL_FROM, this.mailFrom);
        return result;
    }

    public void setMailHost(String host) {
        this.mailHost = host;
    }

    public String getMailHost() {
        return this.mailHost;
    }

    public void setMailFromAddress(String fromAddress) {
        this.mailFrom = fromAddress;
    }

    public String getMailFromAddress() {
        return this.mailFrom;
    }

    public void addMailToAddress(String toAddress) {
        this.mailToSet.add(toAddress);
        this.mailToAddresses = this.getAllToAddresses();
    }

    public void removeMailToAddress(String toAddress) {
        this.mailToSet.remove(toAddress);
        this.mailToAddresses = this.getAllToAddresses();
    }

    public String[] getAllToAddresses() {
        return this.mailToSet.toArray(new String[0]);
    }

    public void removeAllMailToAddresses() {
        this.mailToSet.clear();
        this.mailToAddresses = new String[0];
    }

    public void setMailProperties(Properties mailProperties) {
        this.mailHost = mailProperties.getProperty(PROPERTY_MAIL_HOST);
        this.mailFrom = mailProperties.getProperty(PROPERTY_MAIL_FROM);
        String mailList = mailProperties.getProperty(PROPERTY_MAIL_TO_LIST, "");
        String[] split = mailList.split(",");
        this.removeAllMailToAddresses();
        for (int i = 0; i < split.length; ++i) {
            this.addMailToAddress(split[i].trim());
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(200);
        buffer.append("[Mail Host: ");
        buffer.append(this.getMailHost());
        buffer.append("]");
        buffer.append(" [Mail From: ");
        buffer.append(this.getMailFromAddress());
        buffer.append("]");
        buffer.append(" [Mail To: ");
        if (this.mailToAddresses.length > 0) {
            for (int i = 0; i < this.mailToAddresses.length; ++i) {
                buffer.append(this.mailToAddresses[i]);
                buffer.append(", ");
            }
            buffer.replace(buffer.length() - 2, buffer.length(), "");
        } else {
            buffer.append(" Undefined");
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static void main(String[] args) {
        MailManager mailManager = new MailManager("mailsrv1.gemstone.com", "hkhanna@gemstone.com");
        mailManager.sendEmail("Alert!", "Test");
    }

    private static class EmailData {
        String subject;
        String message;

        EmailData(String subject, String message) {
            this.subject = subject;
            this.message = message;
        }
    }
}

