/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.internal;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.geode.admin.AdminDistributedSystem;
import org.apache.geode.admin.DistributionLocator;
import org.apache.geode.admin.DistributionLocatorConfig;
import org.apache.geode.admin.ManagedEntityConfig;
import org.apache.geode.admin.internal.AdminDistributedSystemImpl;
import org.apache.geode.admin.internal.DistributionLocatorConfigImpl;
import org.apache.geode.admin.internal.InternalManagedEntity;
import org.apache.geode.admin.internal.ManagedEntityController;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.DistributionLocatorId;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;

public class DistributionLocatorImpl
implements DistributionLocator,
InternalManagedEntity {
    private static final Logger logger = LogService.getLogger();
    private static int newLocators = 0;
    private final DistributionLocatorConfigImpl config;
    private final String id;
    private ManagedEntityController controller;
    private AdminDistributedSystemImpl system;

    public DistributionLocatorImpl(DistributionLocatorConfig config, AdminDistributedSystemImpl system) {
        this.config = (DistributionLocatorConfigImpl)config;
        this.config.validate();
        this.config.setManagedEntity(this);
        this.id = this.getNewId();
        this.controller = system.getEntityController();
        this.system = system;
    }

    @Override
    public String getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNewId() {
        Class<DistributionLocatorImpl> clazz = DistributionLocatorImpl.class;
        synchronized (DistributionLocatorImpl.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return "Locator" + ++newLocators;
        }
    }

    @Override
    public DistributionLocatorConfig getConfig() {
        return this.config;
    }

    @Override
    public AdminDistributedSystem getDistributedSystem() {
        return this.system;
    }

    @Override
    public int setState(int state) {
        throw new UnsupportedOperationException(LocalizedStrings.DistributionLocatorImpl_CAN_NOT_SET_THE_STATE_OF_A_LOCATOR.toLocalizedString());
    }

    @Override
    public boolean waitToStart(long timeout) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < timeout) {
            if (this.isRunning()) {
                return true;
            }
            Thread.sleep(100L);
        }
        logger.info(LocalizedMessage.create(LocalizedStrings.DistributionLocatorImpl_DONE_WAITING_FOR_LOCATOR));
        return this.isRunning();
    }

    @Override
    public boolean waitToStop(long timeout) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < timeout) {
            if (!this.isRunning()) {
                return true;
            }
            Thread.sleep(100L);
        }
        return !this.isRunning();
    }

    @Override
    public boolean isRunning() {
        DM dm = ((AdminDistributedSystemImpl)this.getDistributedSystem()).getDistributionManager();
        if (dm == null) {
            try {
                return this.controller.isRunning(this);
            }
            catch (IllegalStateException e) {
                return false;
            }
        }
        String host = this.getConfig().getHost();
        int port = this.getConfig().getPort();
        String bindAddress = this.getConfig().getBindAddress();
        boolean found = false;
        Map<InternalDistributedMember, Collection<String>> hostedLocators = dm.getAllHostedLocators();
        Iterator<InternalDistributedMember> memberIter = hostedLocators.keySet().iterator();
        while (memberIter.hasNext()) {
            Iterator<String> locatorIter = hostedLocators.get(memberIter.next()).iterator();
            while (locatorIter.hasNext()) {
                DistributionLocatorId locator = new DistributionLocatorId(locatorIter.next());
                found = found || locator.getHost().getHostAddress().equals(host);
                boolean bl = found = found || locator.getHost().getHostName().equals(host);
                if (!found && !host.contains(".")) {
                    try {
                        InetAddress inetAddr = InetAddress.getByName(host);
                        found = locator.getHost().getHostName().equals(inetAddr.getHostName());
                        if (!found) {
                            found = locator.getHost().getHostAddress().equals(inetAddr.getHostAddress());
                        }
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                }
                if (locator.getBindAddress() != null && !locator.getBindAddress().isEmpty() && bindAddress != null && !bindAddress.isEmpty()) {
                    found = found && locator.getBindAddress().equals(bindAddress);
                }
                if (!(found = found && locator.getPort() == port)) continue;
                return true;
            }
        }
        return found;
    }

    @Override
    public void start() {
        this.config.validate();
        this.controller.start(this);
        this.config.setLocator(this);
        this.system.updateLocatorsString();
    }

    @Override
    public void stop() {
        this.controller.stop(this);
        this.config.setLocator(null);
    }

    @Override
    public String getLog() {
        return this.controller.getLog(this);
    }

    public String toString() {
        return "DistributionLocator " + this.getId();
    }

    @Override
    public ManagedEntityConfig getEntityConfig() {
        return this.getConfig();
    }

    @Override
    public String getEntityType() {
        return "Locator";
    }

    @Override
    public String getStartCommand() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.controller.getProductExecutable(this, "gemfire"));
        sb.append(" start-locator -q -dir=");
        sb.append(this.getConfig().getWorkingDirectory());
        sb.append(" -port=");
        sb.append(this.getConfig().getPort());
        Properties props = this.config.getDistributedSystemProperties();
        Enumeration<?> en = props.propertyNames();
        while (en.hasMoreElements()) {
            String pn = (String)en.nextElement();
            sb.append(" -Dgemfire." + pn + "=" + props.getProperty(pn));
        }
        String bindAddress = this.getConfig().getBindAddress();
        if (bindAddress != null && bindAddress.length() > 0) {
            sb.append(" -address=");
            sb.append(this.getConfig().getBindAddress());
        }
        sb.append(" ");
        String sslArgs = this.controller.buildSSLArguments(this.system.getConfig());
        if (sslArgs != null) {
            sb.append(sslArgs);
        }
        return sb.toString().trim();
    }

    @Override
    public String getStopCommand() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.controller.getProductExecutable(this, "gemfire"));
        sb.append(" stop-locator -q -dir=");
        sb.append(this.getConfig().getWorkingDirectory());
        sb.append(" -port=");
        sb.append(this.getConfig().getPort());
        String bindAddress = this.getConfig().getBindAddress();
        if (bindAddress != null && bindAddress.length() > 0) {
            sb.append(" -address=");
            sb.append(this.getConfig().getBindAddress());
        }
        sb.append(" ");
        String sslArgs = this.controller.buildSSLArguments(this.system.getConfig());
        if (sslArgs != null) {
            sb.append(sslArgs);
        }
        return sb.toString().trim();
    }

    @Override
    public String getIsRunningCommand() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.controller.getProductExecutable(this, "gemfire"));
        sb.append(" status-locator -dir=");
        sb.append(this.getConfig().getWorkingDirectory());
        return sb.toString().trim();
    }

    public String getLogCommand() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.controller.getProductExecutable(this, "gemfire"));
        sb.append(" tail-locator-log -dir=");
        sb.append(this.getConfig().getWorkingDirectory());
        return sb.toString().trim();
    }
}

