/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.internal;

import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.SystemFailure;
import org.apache.geode.admin.AdminException;
import org.apache.geode.admin.GemFireHealth;
import org.apache.geode.admin.GemFireHealthConfig;
import org.apache.geode.admin.GemFireMemberStatus;
import org.apache.geode.admin.RegionSubRegionSnapshot;
import org.apache.geode.admin.internal.AbstractHealthEvaluator;
import org.apache.geode.admin.internal.DistributedSystemHealthEvaluator;
import org.apache.geode.admin.internal.GemFireHealthImpl;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.Config;
import org.apache.geode.internal.admin.AdminBridgeServer;
import org.apache.geode.internal.admin.CacheInfo;
import org.apache.geode.internal.admin.DLockInfo;
import org.apache.geode.internal.admin.GemFireVM;
import org.apache.geode.internal.admin.GfManagerAgent;
import org.apache.geode.internal.admin.HealthListener;
import org.apache.geode.internal.admin.Stat;
import org.apache.geode.internal.admin.StatAlertDefinition;
import org.apache.geode.internal.admin.StatListener;
import org.apache.geode.internal.admin.StatResource;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.LoggingThreadGroup;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.logging.log4j.Logger;

class DistributedSystemHealthMonitor
implements Runnable,
GemFireVM {
    private static final Logger logger = LogService.getLogger();
    private DistributedSystemHealthEvaluator eval;
    private GemFireHealthImpl healthImpl;
    private int interval;
    private Thread thread;
    private volatile boolean stopRequested = false;
    private GemFireHealth.Health prevHealth = GemFireHealth.GOOD_HEALTH;
    private List okayDiagnoses;
    private List poorDiagnoses;

    DistributedSystemHealthMonitor(DistributedSystemHealthEvaluator eval, GemFireHealthImpl healthImpl, int interval) {
        this.eval = eval;
        this.healthImpl = healthImpl;
        this.interval = interval;
        this.okayDiagnoses = new ArrayList();
        this.poorDiagnoses = new ArrayList();
        LoggingThreadGroup group = LoggingThreadGroup.createThreadGroup(LocalizedStrings.DistributedSystemHealthMonitor_HEALTH_MONITORS.toLocalizedString(), logger);
        String name = LocalizedStrings.DistributedSystemHealthMonitor_HEALTH_MONITOR_FOR_0.toLocalizedString(eval.getDescription());
        this.thread = new Thread(group, this, name);
        this.thread.setDaemon(true);
    }

    @Override
    public void run() {
        if (logger.isDebugEnabled()) {
            logger.debug("Monitoring health of {} every {} seconds", (Object)this.eval.getDescription(), (Object)this.interval);
        }
        while (!this.stopRequested) {
            SystemFailure.checkFailure();
            try {
                Thread.sleep(this.interval * 1000);
                ArrayList status = new ArrayList();
                this.eval.evaluate(status);
                GemFireHealth.Health overallHealth = GemFireHealth.GOOD_HEALTH;
                this.okayDiagnoses.clear();
                this.poorDiagnoses.clear();
                for (AbstractHealthEvaluator.HealthStatus health : status) {
                    GemFireHealth.Health healthCode;
                    if (overallHealth == GemFireHealth.GOOD_HEALTH) {
                        if (health.getHealthCode() != GemFireHealth.GOOD_HEALTH) {
                            overallHealth = health.getHealthCode();
                        }
                    } else if (overallHealth == GemFireHealth.OKAY_HEALTH && health.getHealthCode() == GemFireHealth.POOR_HEALTH) {
                        overallHealth = GemFireHealth.POOR_HEALTH;
                    }
                    if ((healthCode = health.getHealthCode()) == GemFireHealth.OKAY_HEALTH) {
                        this.okayDiagnoses.add(health.getDiagnosis());
                        continue;
                    }
                    if (healthCode != GemFireHealth.POOR_HEALTH) continue;
                    this.poorDiagnoses.add(health.getDiagnosis());
                    break;
                }
                if (overallHealth == this.prevHealth) continue;
                this.healthImpl.healthChanged(this, overallHealth);
                this.prevHealth = overallHealth;
            }
            catch (InterruptedException ex) {
                // empty catch block
                break;
            }
        }
        this.eval.close();
        if (logger.isDebugEnabled()) {
            logger.debug("Stopped checking for distributed system health");
        }
    }

    void start() {
        this.thread.start();
    }

    void stop() {
        if (this.thread.isAlive()) {
            this.stopRequested = true;
            this.thread.interrupt();
            this.healthImpl.nodeLeft(null, this);
            try {
                this.thread.join();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                logger.warn(LocalizedMessage.create(LocalizedStrings.DistributedSystemHealthMonitor_INTERRUPTED_WHILE_STOPPING_HEALTH_MONITOR_THREAD), (Throwable)ex);
            }
        }
    }

    @Override
    public InetAddress getHost() {
        try {
            return SocketCreator.getLocalHost();
        }
        catch (Exception ex) {
            throw new InternalGemFireException(LocalizedStrings.DistributedSystemHealthMonitor_COULD_NOT_GET_LOCALHOST.toLocalizedString());
        }
    }

    @Override
    public String getName() {
        throw new UnsupportedOperationException("Not a real GemFireVM");
    }

    @Override
    public File getWorkingDirectory() {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public File getGeodeHomeDir() {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public Date getBirthDate() {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    public Properties getLicenseInfo() {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public GemFireMemberStatus getSnapshot() {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public RegionSubRegionSnapshot getRegionSnapshot() {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public StatResource[] getStats(String statisticsTypeName) {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public StatResource[] getAllStats() {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public DLockInfo[] getDistributedLockInfo() {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public void addStatListener(StatListener observer, StatResource observedResource, Stat observedStat) {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public void removeStatListener(StatListener observer) {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public void addHealthListener(HealthListener observer, GemFireHealthConfig cfg) {
    }

    @Override
    public void removeHealthListener() {
    }

    @Override
    public void resetHealthStatus() {
        this.prevHealth = GemFireHealth.GOOD_HEALTH;
    }

    @Override
    public String[] getHealthDiagnosis(GemFireHealth.Health healthCode) {
        if (healthCode == GemFireHealth.GOOD_HEALTH) {
            return new String[0];
        }
        if (healthCode == GemFireHealth.OKAY_HEALTH) {
            String[] array = new String[this.okayDiagnoses.size()];
            this.okayDiagnoses.toArray(array);
            return array;
        }
        Assert.assertTrue(healthCode == GemFireHealth.POOR_HEALTH);
        String[] array = new String[this.poorDiagnoses.size()];
        this.poorDiagnoses.toArray(array);
        return array;
    }

    @Override
    public Config getConfig() {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public void setConfig(Config cfg) {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public GfManagerAgent getManagerAgent() {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public String[] getSystemLogs() {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public void setInspectionClasspath(String classpath) {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public String getInspectionClasspath() {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public Region[] getRootRegions() {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public Region getRegion(CacheInfo c, String path) {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public Region createVMRootRegion(CacheInfo c, String name, RegionAttributes attrs) {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public Region createSubregion(CacheInfo c, String parentPath, String name, RegionAttributes attrs) {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public void setCacheInspectionMode(int mode) {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public int getCacheInspectionMode() {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public void takeRegionSnapshot(String regionName, int snapshotId) {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public InternalDistributedMember getId() {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public CacheInfo getCacheInfo() {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public String getVersionInfo() {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public CacheInfo setCacheLockTimeout(CacheInfo c, int v) {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public CacheInfo setCacheLockLease(CacheInfo c, int v) {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public CacheInfo setCacheSearchTimeout(CacheInfo c, int v) {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public AdminBridgeServer addCacheServer(CacheInfo cache) throws AdminException {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public AdminBridgeServer getBridgeInfo(CacheInfo cache, int id) throws AdminException {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public AdminBridgeServer startBridgeServer(CacheInfo cache, AdminBridgeServer bridge) throws AdminException {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public AdminBridgeServer stopBridgeServer(CacheInfo cache, AdminBridgeServer bridge) throws AdminException {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public void setAlertsManager(StatAlertDefinition[] alertDefs, long refreshInterval, boolean setRemotely) {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public void setRefreshInterval(long refreshInterval) {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public void updateAlertDefinitions(StatAlertDefinition[] alertDefs, int actionCode) {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }
}

