/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.session.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import io.atomix.cluster.MemberId;
import io.atomix.primitive.PrimitiveException;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.event.EventType;
import io.atomix.primitive.event.Events;
import io.atomix.primitive.event.PrimitiveEvent;
import io.atomix.primitive.session.Session;
import io.atomix.primitive.session.SessionId;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.function.Consumer;

public class ClientSession<C>
implements Session<C> {
    private final Session session;
    private final SessionProxy proxy;

    public ClientSession(Class<C> clientType, Session session) {
        this.session = (Session)Preconditions.checkNotNull((Object)session);
        this.proxy = new SessionProxy(clientType);
    }

    @Override
    public SessionId sessionId() {
        return this.session.sessionId();
    }

    @Override
    public String primitiveName() {
        return this.session.primitiveName();
    }

    @Override
    public PrimitiveType primitiveType() {
        return this.session.primitiveType();
    }

    @Override
    public MemberId memberId() {
        return this.session.memberId();
    }

    @Override
    public Session.State getState() {
        return this.session.getState();
    }

    @Override
    public void publish(PrimitiveEvent event) {
        this.session.publish(event);
    }

    @Override
    public <T> void publish(EventType eventType, T event) {
        this.session.publish(eventType, event);
    }

    @Override
    public void accept(Consumer<C> event) {
        this.proxy.accept(event);
    }

    private final class SessionProxyHandler
    implements InvocationHandler {
        private final Map<Method, EventType> events;

        private SessionProxyHandler(Class<C> clientType) {
            this.events = clientType != null ? Events.getMethodMap(clientType) : Maps.newHashMap();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            EventType eventType = this.events.get(method);
            if (eventType == null) {
                throw new PrimitiveException.ServiceException("Cannot invoke unknown event type: " + method.getName());
            }
            ClientSession.this.session.publish(eventType, args);
            return null;
        }
    }

    private final class SessionProxy {
        private final C proxy;

        SessionProxy(Class<C> clientType) {
            this.proxy = clientType == null ? null : Proxy.newProxyInstance(clientType.getClassLoader(), new Class[]{clientType}, (InvocationHandler)new SessionProxyHandler(clientType));
        }

        void accept(Consumer<C> event) {
            event.accept(this.proxy);
        }
    }
}

