/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.geo;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.mapper.geo.BaseGeoPointFieldMapper;
import org.elasticsearch.index.search.geo.IndexedGeoBoundingBoxQuery;

public class GeoDistanceRangeQuery
extends Query {
    private final double lat;
    private final double lon;
    private final double inclusiveLowerPoint;
    private final double inclusiveUpperPoint;
    private final GeoDistance geoDistance;
    private final GeoDistance.FixedSourceDistance fixedSourceDistance;
    private GeoDistance.DistanceBoundingCheck distanceBoundingCheck;
    private final Query boundingBoxFilter;
    private final IndexGeoPointFieldData indexFieldData;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GeoDistanceRangeQuery(GeoPoint point, Double lowerVal, Double upperVal, boolean includeLower, boolean includeUpper, GeoDistance geoDistance, BaseGeoPointFieldMapper.GeoPointFieldType fieldType, IndexGeoPointFieldData indexFieldData, String optimizeBbox) {
        long i;
        double f;
        this.lat = point.lat();
        this.lon = point.lon();
        this.geoDistance = geoDistance;
        this.indexFieldData = indexFieldData;
        this.fixedSourceDistance = geoDistance.fixedSourceDistance(this.lat, this.lon, DistanceUnit.DEFAULT);
        if (lowerVal != null) {
            f = lowerVal;
            i = NumericUtils.doubleToSortableLong(f);
            this.inclusiveLowerPoint = NumericUtils.sortableLongToDouble(includeLower ? i : i + 1L);
        } else {
            this.inclusiveLowerPoint = Double.NEGATIVE_INFINITY;
        }
        if (upperVal != null) {
            f = upperVal;
            i = NumericUtils.doubleToSortableLong(f);
            this.inclusiveUpperPoint = NumericUtils.sortableLongToDouble(includeUpper ? i : i - 1L);
        } else {
            this.inclusiveUpperPoint = Double.POSITIVE_INFINITY;
            optimizeBbox = null;
        }
        if (optimizeBbox != null && !"none".equals(optimizeBbox)) {
            this.distanceBoundingCheck = GeoDistance.distanceBoundingCheck(this.lat, this.lon, this.inclusiveUpperPoint, DistanceUnit.DEFAULT);
            if ("memory".equals(optimizeBbox)) {
                this.boundingBoxFilter = null;
                return;
            } else {
                if (!"indexed".equals(optimizeBbox)) throw new IllegalArgumentException("type [" + optimizeBbox + "] for bounding box optimization not supported");
                this.boundingBoxFilter = IndexedGeoBoundingBoxQuery.create(this.distanceBoundingCheck.topLeft(), this.distanceBoundingCheck.bottomRight(), fieldType);
                this.distanceBoundingCheck = GeoDistance.ALWAYS_INSTANCE;
            }
            return;
        } else {
            this.distanceBoundingCheck = GeoDistance.ALWAYS_INSTANCE;
            this.boundingBoxFilter = null;
        }
    }

    public double lat() {
        return this.lat;
    }

    public double lon() {
        return this.lon;
    }

    public GeoDistance geoDistance() {
        return this.geoDistance;
    }

    public double minInclusiveDistance() {
        return this.inclusiveLowerPoint;
    }

    public double maxInclusiveDistance() {
        return this.inclusiveUpperPoint;
    }

    public String fieldName() {
        return this.indexFieldData.getFieldNames().indexName();
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        return super.rewrite(reader);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        final Weight boundingBoxWeight = this.boundingBoxFilter != null ? searcher.createNormalizedWeight(this.boundingBoxFilter, false) : null;
        return new ConstantScoreWeight(this){

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                DocIdSetIterator approximation;
                if (boundingBoxWeight != null) {
                    Scorer s = boundingBoxWeight.scorer(context);
                    if (s == null) {
                        return null;
                    }
                    approximation = s.iterator();
                } else {
                    approximation = DocIdSetIterator.all(context.reader().maxDoc());
                }
                final MultiGeoPointValues values = ((AtomicGeoPointFieldData)GeoDistanceRangeQuery.this.indexFieldData.load(context)).getGeoPointValues();
                TwoPhaseIterator twoPhaseIterator = new TwoPhaseIterator(approximation){

                    @Override
                    public boolean matches() throws IOException {
                        int doc = this.approximation.docID();
                        values.setDocument(doc);
                        int length = values.count();
                        for (int i = 0; i < length; ++i) {
                            double d;
                            GeoPoint point = values.valueAt(i);
                            if (!GeoDistanceRangeQuery.this.distanceBoundingCheck.isWithin(point.lat(), point.lon()) || !((d = GeoDistanceRangeQuery.this.fixedSourceDistance.calculate(point.lat(), point.lon())) >= GeoDistanceRangeQuery.this.inclusiveLowerPoint) || !(d <= GeoDistanceRangeQuery.this.inclusiveUpperPoint)) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public float matchCost() {
                        if (GeoDistanceRangeQuery.this.distanceBoundingCheck == GeoDistance.ALWAYS_INSTANCE) {
                            return 0.0f;
                        }
                        return 4.0f;
                    }
                };
                return new ConstantScoreScorer((Weight)this, this.score(), twoPhaseIterator);
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        GeoDistanceRangeQuery filter = (GeoDistanceRangeQuery)o;
        if (Double.compare(filter.inclusiveLowerPoint, this.inclusiveLowerPoint) != 0) {
            return false;
        }
        if (Double.compare(filter.inclusiveUpperPoint, this.inclusiveUpperPoint) != 0) {
            return false;
        }
        if (Double.compare(filter.lat, this.lat) != 0) {
            return false;
        }
        if (Double.compare(filter.lon, this.lon) != 0) {
            return false;
        }
        if (!this.indexFieldData.getFieldNames().indexName().equals(filter.indexFieldData.getFieldNames().indexName())) {
            return false;
        }
        return this.geoDistance == filter.geoDistance;
    }

    @Override
    public String toString(String field) {
        return "GeoDistanceRangeQuery(" + this.indexFieldData.getFieldNames().indexName() + ", " + (Object)((Object)this.geoDistance) + ", [" + this.inclusiveLowerPoint + " - " + this.inclusiveUpperPoint + "], " + this.lat + ", " + this.lon + ")";
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = this.lat != 0.0 ? Double.doubleToLongBits(this.lat) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.lon != 0.0 ? Double.doubleToLongBits(this.lon) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.inclusiveLowerPoint != 0.0 ? Double.doubleToLongBits(this.inclusiveLowerPoint) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.inclusiveUpperPoint != 0.0 ? Double.doubleToLongBits(this.inclusiveUpperPoint) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.geoDistance != null ? this.geoDistance.hashCode() : 0);
        result = 31 * result + this.indexFieldData.getFieldNames().indexName().hashCode();
        return result;
    }
}

