/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import com.carrotsearch.hppc.IntArrayList;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.search.ScoreDoc;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.search.AbstractSearchAsyncAction;
import org.elasticsearch.action.search.ReduceSearchPhaseException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.TransportSearchHelper;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.action.SearchServiceTransportAction;
import org.elasticsearch.search.controller.SearchPhaseController;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.ShardFetchSearchRequest;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.internal.ShardSearchTransportRequest;
import org.elasticsearch.search.query.QuerySearchResultProvider;
import org.elasticsearch.threadpool.ThreadPool;

class SearchQueryThenFetchAsyncAction
extends AbstractSearchAsyncAction<QuerySearchResultProvider> {
    final AtomicArray<FetchSearchResult> fetchResults;
    final AtomicArray<IntArrayList> docIdsToLoad;

    SearchQueryThenFetchAsyncAction(ESLogger logger, SearchServiceTransportAction searchService, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver, SearchPhaseController searchPhaseController, ThreadPool threadPool, SearchRequest request, ActionListener<SearchResponse> listener) {
        super(logger, searchService, clusterService, indexNameExpressionResolver, searchPhaseController, threadPool, request, listener);
        this.fetchResults = new AtomicArray(this.firstResults.length());
        this.docIdsToLoad = new AtomicArray(this.firstResults.length());
    }

    @Override
    protected String firstPhaseName() {
        return "query";
    }

    @Override
    protected void sendExecuteFirstPhase(DiscoveryNode node, ShardSearchTransportRequest request, ActionListener<QuerySearchResultProvider> listener) {
        this.searchService.sendExecuteQuery(node, request, listener);
    }

    @Override
    protected void moveToSecondPhase() throws Exception {
        boolean useScroll = this.request.scroll() != null;
        this.sortedShardList = this.searchPhaseController.sortDocs(useScroll, this.firstResults);
        this.searchPhaseController.fillDocIdsToLoad(this.docIdsToLoad, this.sortedShardList);
        if (this.docIdsToLoad.asList().isEmpty()) {
            this.finishHim();
            return;
        }
        ScoreDoc[] lastEmittedDocPerShard = this.searchPhaseController.getLastEmittedDocPerShard(this.request, this.sortedShardList, this.firstResults.length());
        AtomicInteger counter = new AtomicInteger(this.docIdsToLoad.asList().size());
        for (AtomicArray.Entry<IntArrayList> entry : this.docIdsToLoad.asList()) {
            QuerySearchResultProvider queryResult = (QuerySearchResultProvider)this.firstResults.get(entry.index);
            DiscoveryNode node = this.nodes.get(queryResult.shardTarget().nodeId());
            ShardFetchSearchRequest fetchSearchRequest = this.createFetchRequest(queryResult.queryResult(), entry, lastEmittedDocPerShard);
            this.executeFetch(entry.index, queryResult.shardTarget(), counter, fetchSearchRequest, node);
        }
    }

    void executeFetch(final int shardIndex, final SearchShardTarget shardTarget, final AtomicInteger counter, final ShardFetchSearchRequest fetchSearchRequest, DiscoveryNode node) {
        this.searchService.sendExecuteFetch(node, fetchSearchRequest, new ActionListener<FetchSearchResult>(){

            @Override
            public void onResponse(FetchSearchResult result) {
                result.shardTarget(shardTarget);
                SearchQueryThenFetchAsyncAction.this.fetchResults.set(shardIndex, result);
                if (counter.decrementAndGet() == 0) {
                    SearchQueryThenFetchAsyncAction.this.finishHim();
                }
            }

            @Override
            public void onFailure(Throwable t) {
                SearchQueryThenFetchAsyncAction.this.docIdsToLoad.set(shardIndex, null);
                SearchQueryThenFetchAsyncAction.this.onFetchFailure(t, fetchSearchRequest, shardIndex, shardTarget, counter);
            }
        });
    }

    void onFetchFailure(Throwable t, ShardFetchSearchRequest fetchSearchRequest, int shardIndex, SearchShardTarget shardTarget, AtomicInteger counter) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[{}] Failed to execute fetch phase", t, fetchSearchRequest.id());
        }
        this.addShardFailure(shardIndex, shardTarget, t);
        this.successfulOps.decrementAndGet();
        if (counter.decrementAndGet() == 0) {
            this.finishHim();
        }
    }

    private void finishHim() {
        this.threadPool.executor("search").execute(new ActionRunnable<SearchResponse>(this.listener){

            @Override
            public void doRun() throws IOException {
                InternalSearchResponse internalResponse = SearchQueryThenFetchAsyncAction.this.searchPhaseController.merge(SearchQueryThenFetchAsyncAction.this.sortedShardList, SearchQueryThenFetchAsyncAction.this.firstResults, SearchQueryThenFetchAsyncAction.this.fetchResults, SearchQueryThenFetchAsyncAction.this.request);
                String scrollId = null;
                if (SearchQueryThenFetchAsyncAction.this.request.scroll() != null) {
                    scrollId = TransportSearchHelper.buildScrollId(SearchQueryThenFetchAsyncAction.this.request.searchType(), (AtomicArray<? extends SearchPhaseResult>)SearchQueryThenFetchAsyncAction.this.firstResults, null);
                }
                this.listener.onResponse(new SearchResponse(internalResponse, scrollId, SearchQueryThenFetchAsyncAction.this.expectedSuccessfulOps, SearchQueryThenFetchAsyncAction.this.successfulOps.get(), SearchQueryThenFetchAsyncAction.this.buildTookInMillis(), SearchQueryThenFetchAsyncAction.this.buildShardFailures()));
                SearchQueryThenFetchAsyncAction.this.releaseIrrelevantSearchContexts(SearchQueryThenFetchAsyncAction.this.firstResults, SearchQueryThenFetchAsyncAction.this.docIdsToLoad);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFailure(Throwable t) {
                try {
                    ReduceSearchPhaseException failure = new ReduceSearchPhaseException("fetch", "", t, SearchQueryThenFetchAsyncAction.this.buildShardFailures());
                    if (SearchQueryThenFetchAsyncAction.this.logger.isDebugEnabled()) {
                        SearchQueryThenFetchAsyncAction.this.logger.debug("failed to reduce search", failure, new Object[0]);
                    }
                    super.onFailure(failure);
                }
                finally {
                    SearchQueryThenFetchAsyncAction.this.releaseIrrelevantSearchContexts(SearchQueryThenFetchAsyncAction.this.firstResults, SearchQueryThenFetchAsyncAction.this.docIdsToLoad);
                }
            }
        });
    }
}

