/*
 * Decompiled with CFR 0.152.
 */
package shaded.parquet.org.codehaus.jackson.node;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import shaded.parquet.org.codehaus.jackson.JsonGenerator;
import shaded.parquet.org.codehaus.jackson.JsonNode;
import shaded.parquet.org.codehaus.jackson.JsonProcessingException;
import shaded.parquet.org.codehaus.jackson.JsonToken;
import shaded.parquet.org.codehaus.jackson.map.SerializerProvider;
import shaded.parquet.org.codehaus.jackson.map.TypeSerializer;
import shaded.parquet.org.codehaus.jackson.node.BaseJsonNode;
import shaded.parquet.org.codehaus.jackson.node.ContainerNode;
import shaded.parquet.org.codehaus.jackson.node.JsonNodeFactory;
import shaded.parquet.org.codehaus.jackson.node.MissingNode;
import shaded.parquet.org.codehaus.jackson.node.ObjectNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayNode
extends ContainerNode {
    protected ArrayList<JsonNode> _children;

    public ArrayNode(JsonNodeFactory nc) {
        super(nc);
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.START_ARRAY;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public int size() {
        return this._children == null ? 0 : this._children.size();
    }

    @Override
    public Iterator<JsonNode> getElements() {
        return this._children == null ? ContainerNode.NoNodesIterator.instance() : this._children.iterator();
    }

    @Override
    public JsonNode get(int index2) {
        if (index2 >= 0 && this._children != null && index2 < this._children.size()) {
            return this._children.get(index2);
        }
        return null;
    }

    @Override
    public JsonNode get(String fieldName) {
        return null;
    }

    @Override
    public JsonNode path(String fieldName) {
        return MissingNode.getInstance();
    }

    @Override
    public JsonNode path(int index2) {
        if (index2 >= 0 && this._children != null && index2 < this._children.size()) {
            return this._children.get(index2);
        }
        return MissingNode.getInstance();
    }

    @Override
    public final void serialize(JsonGenerator jg, SerializerProvider provider) throws IOException, JsonProcessingException {
        jg.writeStartArray();
        if (this._children != null) {
            for (JsonNode n : this._children) {
                ((BaseJsonNode)n).serialize(jg, provider);
            }
        }
        jg.writeEndArray();
    }

    @Override
    public void serializeWithType(JsonGenerator jg, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonProcessingException {
        typeSer.writeTypePrefixForArray(this, jg);
        if (this._children != null) {
            for (JsonNode n : this._children) {
                ((BaseJsonNode)n).serialize(jg, provider);
            }
        }
        typeSer.writeTypeSuffixForArray(this, jg);
    }

    @Override
    public JsonNode findValue(String fieldName) {
        if (this._children != null) {
            for (JsonNode node : this._children) {
                JsonNode value2 = node.findValue(fieldName);
                if (value2 == null) continue;
                return value2;
            }
        }
        return null;
    }

    @Override
    public List<JsonNode> findValues(String fieldName, List<JsonNode> foundSoFar) {
        if (this._children != null) {
            for (JsonNode node : this._children) {
                foundSoFar = node.findValues(fieldName, foundSoFar);
            }
        }
        return foundSoFar;
    }

    @Override
    public List<String> findValuesAsText(String fieldName, List<String> foundSoFar) {
        if (this._children != null) {
            for (JsonNode node : this._children) {
                foundSoFar = node.findValuesAsText(fieldName, foundSoFar);
            }
        }
        return foundSoFar;
    }

    @Override
    public ObjectNode findParent(String fieldName) {
        if (this._children != null) {
            for (JsonNode node : this._children) {
                JsonNode parent = node.findParent(fieldName);
                if (parent == null) continue;
                return (ObjectNode)parent;
            }
        }
        return null;
    }

    @Override
    public List<JsonNode> findParents(String fieldName, List<JsonNode> foundSoFar) {
        if (this._children != null) {
            for (JsonNode node : this._children) {
                foundSoFar = node.findParents(fieldName, foundSoFar);
            }
        }
        return foundSoFar;
    }

    public JsonNode set(int index2, JsonNode value2) {
        if (value2 == null) {
            value2 = this.nullNode();
        }
        return this._set(index2, value2);
    }

    public void add(JsonNode value2) {
        if (value2 == null) {
            value2 = this.nullNode();
        }
        this._add(value2);
    }

    public JsonNode addAll(ArrayNode other) {
        int len = other.size();
        if (len > 0) {
            if (this._children == null) {
                this._children = new ArrayList(len + 2);
            }
            other.addContentsTo(this._children);
        }
        return this;
    }

    public JsonNode addAll(Collection<JsonNode> nodes2) {
        int len = nodes2.size();
        if (len > 0) {
            if (this._children == null) {
                this._children = new ArrayList<JsonNode>(nodes2);
            } else {
                this._children.addAll(nodes2);
            }
        }
        return this;
    }

    public void insert(int index2, JsonNode value2) {
        if (value2 == null) {
            value2 = this.nullNode();
        }
        this._insert(index2, value2);
    }

    public JsonNode remove(int index2) {
        if (index2 >= 0 && this._children != null && index2 < this._children.size()) {
            return this._children.remove(index2);
        }
        return null;
    }

    @Override
    public ArrayNode removeAll() {
        this._children = null;
        return this;
    }

    public ArrayNode addArray() {
        ArrayNode n = this.arrayNode();
        this._add(n);
        return n;
    }

    public ObjectNode addObject() {
        ObjectNode n = this.objectNode();
        this._add(n);
        return n;
    }

    public void addPOJO(Object value2) {
        if (value2 == null) {
            this.addNull();
        } else {
            this._add(this.POJONode(value2));
        }
    }

    public void addNull() {
        this._add(this.nullNode());
    }

    public void add(int v) {
        this._add(this.numberNode(v));
    }

    public void add(Integer value2) {
        if (value2 == null) {
            this.addNull();
        } else {
            this._add(this.numberNode(value2));
        }
    }

    public void add(long v) {
        this._add(this.numberNode(v));
    }

    public void add(Long value2) {
        if (value2 == null) {
            this.addNull();
        } else {
            this._add(this.numberNode(value2));
        }
    }

    public void add(float v) {
        this._add(this.numberNode(v));
    }

    public void add(Float value2) {
        if (value2 == null) {
            this.addNull();
        } else {
            this._add(this.numberNode(value2.floatValue()));
        }
    }

    public void add(double v) {
        this._add(this.numberNode(v));
    }

    public void add(Double value2) {
        if (value2 == null) {
            this.addNull();
        } else {
            this._add(this.numberNode(value2));
        }
    }

    public void add(BigDecimal v) {
        if (v == null) {
            this.addNull();
        } else {
            this._add(this.numberNode(v));
        }
    }

    public void add(String v) {
        if (v == null) {
            this.addNull();
        } else {
            this._add(this.textNode(v));
        }
    }

    public void add(boolean v) {
        this._add(this.booleanNode(v));
    }

    public void add(Boolean value2) {
        if (value2 == null) {
            this.addNull();
        } else {
            this._add(this.booleanNode(value2));
        }
    }

    public void add(byte[] v) {
        if (v == null) {
            this.addNull();
        } else {
            this._add(this.binaryNode(v));
        }
    }

    public ArrayNode insertArray(int index2) {
        ArrayNode n = this.arrayNode();
        this._insert(index2, n);
        return n;
    }

    public ObjectNode insertObject(int index2) {
        ObjectNode n = this.objectNode();
        this._insert(index2, n);
        return n;
    }

    public void insertPOJO(int index2, Object value2) {
        if (value2 == null) {
            this.insertNull(index2);
        } else {
            this._insert(index2, this.POJONode(value2));
        }
    }

    public void insertNull(int index2) {
        this._insert(index2, this.nullNode());
    }

    public void insert(int index2, int v) {
        this._insert(index2, this.numberNode(v));
    }

    public void insert(int index2, Integer value2) {
        if (value2 == null) {
            this.insertNull(index2);
        } else {
            this._insert(index2, this.numberNode(value2));
        }
    }

    public void insert(int index2, long v) {
        this._insert(index2, this.numberNode(v));
    }

    public void insert(int index2, Long value2) {
        if (value2 == null) {
            this.insertNull(index2);
        } else {
            this._insert(index2, this.numberNode(value2));
        }
    }

    public void insert(int index2, float v) {
        this._insert(index2, this.numberNode(v));
    }

    public void insert(int index2, Float value2) {
        if (value2 == null) {
            this.insertNull(index2);
        } else {
            this._insert(index2, this.numberNode(value2.floatValue()));
        }
    }

    public void insert(int index2, double v) {
        this._insert(index2, this.numberNode(v));
    }

    public void insert(int index2, Double value2) {
        if (value2 == null) {
            this.insertNull(index2);
        } else {
            this._insert(index2, this.numberNode(value2));
        }
    }

    public void insert(int index2, BigDecimal v) {
        if (v == null) {
            this.insertNull(index2);
        } else {
            this._insert(index2, this.numberNode(v));
        }
    }

    public void insert(int index2, String v) {
        if (v == null) {
            this.insertNull(index2);
        } else {
            this._insert(index2, this.textNode(v));
        }
    }

    public void insert(int index2, boolean v) {
        this._insert(index2, this.booleanNode(v));
    }

    public void insert(int index2, Boolean value2) {
        if (value2 == null) {
            this.insertNull(index2);
        } else {
            this._insert(index2, this.booleanNode(value2));
        }
    }

    public void insert(int index2, byte[] v) {
        if (v == null) {
            this.insertNull(index2);
        } else {
            this._insert(index2, this.binaryNode(v));
        }
    }

    protected void addContentsTo(List<JsonNode> dst) {
        if (this._children != null) {
            for (JsonNode n : this._children) {
                dst.add(n);
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        ArrayNode other = (ArrayNode)o;
        if (this._children == null || this._children.size() == 0) {
            return other.size() == 0;
        }
        return other._sameChildren(this._children);
    }

    public int hashCode() {
        int hash2;
        if (this._children == null) {
            hash2 = 1;
        } else {
            hash2 = this._children.size();
            for (JsonNode n : this._children) {
                if (n == null) continue;
                hash2 ^= n.hashCode();
            }
        }
        return hash2;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(16 + (this.size() << 4));
        sb.append('[');
        if (this._children != null) {
            int len = this._children.size();
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(this._children.get(i).toString());
            }
        }
        sb.append(']');
        return sb.toString();
    }

    public JsonNode _set(int index2, JsonNode value2) {
        if (this._children == null || index2 < 0 || index2 >= this._children.size()) {
            throw new IndexOutOfBoundsException("Illegal index " + index2 + ", array size " + this.size());
        }
        return this._children.set(index2, value2);
    }

    private void _add(JsonNode node) {
        if (this._children == null) {
            this._children = new ArrayList();
        }
        this._children.add(node);
    }

    private void _insert(int index2, JsonNode node) {
        if (this._children == null) {
            this._children = new ArrayList();
            this._children.add(node);
            return;
        }
        if (index2 < 0) {
            this._children.add(0, node);
        } else if (index2 >= this._children.size()) {
            this._children.add(node);
        } else {
            this._children.add(index2, node);
        }
    }

    private boolean _sameChildren(ArrayList<JsonNode> otherChildren) {
        int len = otherChildren.size();
        if (this.size() != len) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this._children.get(i).equals(otherChildren.get(i))) continue;
            return false;
        }
        return true;
    }
}

