/*
 * Decompiled with CFR 0.152.
 */
package shaded.parquet.org.codehaus.jackson.map.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import shaded.parquet.org.codehaus.jackson.JsonGenerationException;
import shaded.parquet.org.codehaus.jackson.JsonGenerator;
import shaded.parquet.org.codehaus.jackson.JsonNode;
import shaded.parquet.org.codehaus.jackson.map.JsonMappingException;
import shaded.parquet.org.codehaus.jackson.map.JsonSerializable;
import shaded.parquet.org.codehaus.jackson.map.JsonSerializableWithType;
import shaded.parquet.org.codehaus.jackson.map.ObjectMapper;
import shaded.parquet.org.codehaus.jackson.map.SerializerProvider;
import shaded.parquet.org.codehaus.jackson.map.TypeSerializer;
import shaded.parquet.org.codehaus.jackson.map.annotate.JacksonStdImpl;
import shaded.parquet.org.codehaus.jackson.map.ser.SerializerBase;
import shaded.parquet.org.codehaus.jackson.map.type.TypeFactory;
import shaded.parquet.org.codehaus.jackson.node.ObjectNode;
import shaded.parquet.org.codehaus.jackson.schema.JsonSerializableSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JacksonStdImpl
public class SerializableSerializer
extends SerializerBase<JsonSerializable> {
    public static final SerializableSerializer instance = new SerializableSerializer();

    protected SerializableSerializer() {
        super(JsonSerializable.class);
    }

    @Override
    public void serialize(JsonSerializable value2, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        value2.serialize(jgen, provider);
    }

    @Override
    public final void serializeWithType(JsonSerializable value2, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
        if (value2 instanceof JsonSerializableWithType) {
            ((JsonSerializableWithType)value2).serializeWithType(jgen, provider, typeSer);
        } else {
            this.serialize(value2, jgen, provider);
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        Class<?> rawClass;
        ObjectNode objectNode = this.createObjectNode();
        String schemaType = "any";
        String objectProperties = null;
        String itemDefinition = null;
        if (typeHint != null && (rawClass = TypeFactory.type(typeHint).getRawClass()).isAnnotationPresent(JsonSerializableSchema.class)) {
            JsonSerializableSchema schemaInfo = rawClass.getAnnotation(JsonSerializableSchema.class);
            schemaType = schemaInfo.schemaType();
            if (!"##irrelevant".equals(schemaInfo.schemaObjectPropertiesDefinition())) {
                objectProperties = schemaInfo.schemaObjectPropertiesDefinition();
            }
            if (!"##irrelevant".equals(schemaInfo.schemaItemDefinition())) {
                itemDefinition = schemaInfo.schemaItemDefinition();
            }
        }
        objectNode.put("type", schemaType);
        if (objectProperties != null) {
            try {
                objectNode.put("properties", new ObjectMapper().readValue(objectProperties, JsonNode.class));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        if (itemDefinition != null) {
            try {
                objectNode.put("items", new ObjectMapper().readValue(itemDefinition, JsonNode.class));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return objectNode;
    }
}

