/*
 * Decompiled with CFR 0.152.
 */
package shaded.parquet.org.codehaus.jackson.map.ser.std;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import shaded.parquet.org.codehaus.jackson.JsonGenerationException;
import shaded.parquet.org.codehaus.jackson.JsonGenerator;
import shaded.parquet.org.codehaus.jackson.JsonNode;
import shaded.parquet.org.codehaus.jackson.map.BeanProperty;
import shaded.parquet.org.codehaus.jackson.map.JsonMappingException;
import shaded.parquet.org.codehaus.jackson.map.JsonSerializer;
import shaded.parquet.org.codehaus.jackson.map.ResolvableSerializer;
import shaded.parquet.org.codehaus.jackson.map.SerializerProvider;
import shaded.parquet.org.codehaus.jackson.map.TypeSerializer;
import shaded.parquet.org.codehaus.jackson.map.ser.impl.PropertySerializerMap;
import shaded.parquet.org.codehaus.jackson.map.ser.std.ContainerSerializerBase;
import shaded.parquet.org.codehaus.jackson.node.ObjectNode;
import shaded.parquet.org.codehaus.jackson.schema.JsonSchema;
import shaded.parquet.org.codehaus.jackson.schema.SchemaAware;
import shaded.parquet.org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AsArraySerializerBase<T>
extends ContainerSerializerBase<T>
implements ResolvableSerializer {
    protected final boolean _staticTyping;
    protected final JavaType _elementType;
    protected final TypeSerializer _valueTypeSerializer;
    protected JsonSerializer<Object> _elementSerializer;
    protected final BeanProperty _property;
    protected PropertySerializerMap _dynamicSerializers;

    @Deprecated
    protected AsArraySerializerBase(Class<?> cls, JavaType et, boolean staticTyping, TypeSerializer vts, BeanProperty property) {
        this(cls, et, staticTyping, vts, property, null);
    }

    protected AsArraySerializerBase(Class<?> cls, JavaType et, boolean staticTyping, TypeSerializer vts, BeanProperty property, JsonSerializer<Object> elementSerializer) {
        super(cls, false);
        this._elementType = et;
        this._staticTyping = staticTyping || et != null && et.isFinal();
        this._valueTypeSerializer = vts;
        this._property = property;
        this._elementSerializer = elementSerializer;
        this._dynamicSerializers = PropertySerializerMap.emptyMap();
    }

    @Override
    public final void serialize(T value2, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        jgen.writeStartArray();
        this.serializeContents(value2, jgen, provider);
        jgen.writeEndArray();
    }

    @Override
    public final void serializeWithType(T value2, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
        typeSer.writeTypePrefixForArray(value2, jgen);
        this.serializeContents(value2, jgen, provider);
        typeSer.writeTypeSuffixForArray(value2, jgen);
    }

    protected abstract void serializeContents(T var1, JsonGenerator var2, SerializerProvider var3) throws IOException, JsonGenerationException;

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        Type[] typeArgs2;
        JavaType javaType2;
        ObjectNode o = this.createSchemaNode("array", true);
        JavaType contentType = null;
        if (typeHint != null && (contentType = (javaType2 = provider.constructType(typeHint)).getContentType()) == null && typeHint instanceof ParameterizedType && (typeArgs2 = ((ParameterizedType)typeHint).getActualTypeArguments()).length == 1) {
            contentType = provider.constructType(typeArgs2[0]);
        }
        if (contentType == null && this._elementType != null) {
            contentType = this._elementType;
        }
        if (contentType != null) {
            JsonSerializer<Object> ser;
            JsonNode schemaNode = null;
            if (contentType.getRawClass() != Object.class && (ser = provider.findValueSerializer(contentType, this._property)) instanceof SchemaAware) {
                schemaNode = ((SchemaAware)((Object)ser)).getSchema(provider, null);
            }
            if (schemaNode == null) {
                schemaNode = JsonSchema.getDefaultSchemaNode();
            }
            o.put("items", schemaNode);
        }
        return o;
    }

    @Override
    public void resolve(SerializerProvider provider) throws JsonMappingException {
        if (this._staticTyping && this._elementType != null && this._elementSerializer == null) {
            this._elementSerializer = provider.findValueSerializer(this._elementType, this._property);
        }
    }

    protected final JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap map2, Class<?> type, SerializerProvider provider) throws JsonMappingException {
        PropertySerializerMap.SerializerAndMapResult result2 = map2.findAndAddSerializer(type, provider, this._property);
        if (map2 != result2.map) {
            this._dynamicSerializers = result2.map;
        }
        return result2.serializer;
    }

    protected final JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap map2, JavaType type, SerializerProvider provider) throws JsonMappingException {
        PropertySerializerMap.SerializerAndMapResult result2 = map2.findAndAddSerializer(type, provider, this._property);
        if (map2 != result2.map) {
            this._dynamicSerializers = result2.map;
        }
        return result2.serializer;
    }
}

