/*
 * Decompiled with CFR 0.152.
 */
package shaded.parquet.org.codehaus.jackson.map.ser;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.RandomAccess;
import java.util.TimeZone;
import shaded.parquet.org.codehaus.jackson.map.AnnotationIntrospector;
import shaded.parquet.org.codehaus.jackson.map.BeanProperty;
import shaded.parquet.org.codehaus.jackson.map.ContextualSerializer;
import shaded.parquet.org.codehaus.jackson.map.JsonMappingException;
import shaded.parquet.org.codehaus.jackson.map.JsonSerializable;
import shaded.parquet.org.codehaus.jackson.map.JsonSerializableWithType;
import shaded.parquet.org.codehaus.jackson.map.JsonSerializer;
import shaded.parquet.org.codehaus.jackson.map.SerializationConfig;
import shaded.parquet.org.codehaus.jackson.map.SerializerFactory;
import shaded.parquet.org.codehaus.jackson.map.Serializers;
import shaded.parquet.org.codehaus.jackson.map.TypeSerializer;
import shaded.parquet.org.codehaus.jackson.map.annotate.JsonSerialize;
import shaded.parquet.org.codehaus.jackson.map.ext.OptionalHandlerFactory;
import shaded.parquet.org.codehaus.jackson.map.introspect.Annotated;
import shaded.parquet.org.codehaus.jackson.map.introspect.AnnotatedClass;
import shaded.parquet.org.codehaus.jackson.map.introspect.AnnotatedMethod;
import shaded.parquet.org.codehaus.jackson.map.introspect.BasicBeanDescription;
import shaded.parquet.org.codehaus.jackson.map.jsontype.NamedType;
import shaded.parquet.org.codehaus.jackson.map.jsontype.TypeResolverBuilder;
import shaded.parquet.org.codehaus.jackson.map.ser.StdSerializers;
import shaded.parquet.org.codehaus.jackson.map.ser.std.CalendarSerializer;
import shaded.parquet.org.codehaus.jackson.map.ser.std.DateSerializer;
import shaded.parquet.org.codehaus.jackson.map.ser.std.EnumMapSerializer;
import shaded.parquet.org.codehaus.jackson.map.ser.std.EnumSerializer;
import shaded.parquet.org.codehaus.jackson.map.ser.std.IndexedStringListSerializer;
import shaded.parquet.org.codehaus.jackson.map.ser.std.InetAddressSerializer;
import shaded.parquet.org.codehaus.jackson.map.ser.std.JsonValueSerializer;
import shaded.parquet.org.codehaus.jackson.map.ser.std.MapSerializer;
import shaded.parquet.org.codehaus.jackson.map.ser.std.NullSerializer;
import shaded.parquet.org.codehaus.jackson.map.ser.std.ObjectArraySerializer;
import shaded.parquet.org.codehaus.jackson.map.ser.std.SerializableSerializer;
import shaded.parquet.org.codehaus.jackson.map.ser.std.SerializableWithTypeSerializer;
import shaded.parquet.org.codehaus.jackson.map.ser.std.StdArraySerializers;
import shaded.parquet.org.codehaus.jackson.map.ser.std.StdContainerSerializers;
import shaded.parquet.org.codehaus.jackson.map.ser.std.StdJdkSerializers;
import shaded.parquet.org.codehaus.jackson.map.ser.std.StringCollectionSerializer;
import shaded.parquet.org.codehaus.jackson.map.ser.std.StringSerializer;
import shaded.parquet.org.codehaus.jackson.map.ser.std.TimeZoneSerializer;
import shaded.parquet.org.codehaus.jackson.map.ser.std.ToStringSerializer;
import shaded.parquet.org.codehaus.jackson.map.ser.std.TokenBufferSerializer;
import shaded.parquet.org.codehaus.jackson.map.type.ArrayType;
import shaded.parquet.org.codehaus.jackson.map.type.CollectionLikeType;
import shaded.parquet.org.codehaus.jackson.map.type.CollectionType;
import shaded.parquet.org.codehaus.jackson.map.type.MapLikeType;
import shaded.parquet.org.codehaus.jackson.map.type.MapType;
import shaded.parquet.org.codehaus.jackson.map.type.TypeFactory;
import shaded.parquet.org.codehaus.jackson.map.util.ClassUtil;
import shaded.parquet.org.codehaus.jackson.map.util.EnumValues;
import shaded.parquet.org.codehaus.jackson.type.JavaType;
import shaded.parquet.org.codehaus.jackson.util.TokenBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicSerializerFactory
extends SerializerFactory {
    protected static final HashMap<String, JsonSerializer<?>> _concrete = new HashMap();
    protected static final HashMap<String, Class<? extends JsonSerializer<?>>> _concreteLazy = new HashMap();
    protected static final HashMap<String, JsonSerializer<?>> _arraySerializers;
    protected OptionalHandlerFactory optionalHandlers = OptionalHandlerFactory.instance;

    protected BasicSerializerFactory() {
    }

    @Override
    public abstract JsonSerializer<Object> createSerializer(SerializationConfig var1, JavaType var2, BeanProperty var3) throws JsonMappingException;

    @Override
    public TypeSerializer createTypeSerializer(SerializationConfig config2, JavaType baseType, BeanProperty property) {
        BasicBeanDescription bean = (BasicBeanDescription)config2.introspectClassAnnotations(baseType.getRawClass());
        AnnotatedClass ac = bean.getClassInfo();
        AnnotationIntrospector ai = config2.getAnnotationIntrospector();
        TypeResolverBuilder<?> b = ai.findTypeResolver(config2, ac, baseType);
        Collection<NamedType> subtypes = null;
        if (b == null) {
            b = config2.getDefaultTyper(baseType);
        } else {
            subtypes = config2.getSubtypeResolver().collectAndResolveSubtypes(ac, config2, ai);
        }
        return b == null ? null : b.buildTypeSerializer(config2, baseType, subtypes, property);
    }

    public final JsonSerializer<?> getNullSerializer() {
        return NullSerializer.instance;
    }

    protected abstract Iterable<Serializers> customSerializers();

    public final JsonSerializer<?> findSerializerByLookup(JavaType type, SerializationConfig config2, BasicBeanDescription beanDesc, BeanProperty property, boolean staticTyping) {
        Class<?> raw2 = type.getRawClass();
        String clsName = raw2.getName();
        JsonSerializer<?> ser = _concrete.get(clsName);
        if (ser != null) {
            return ser;
        }
        Class<JsonSerializer<?>> serClass = _concreteLazy.get(clsName);
        if (serClass != null) {
            try {
                return serClass.newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to instantiate standard serializer (of type " + serClass.getName() + "): " + e.getMessage(), e);
            }
        }
        return null;
    }

    public final JsonSerializer<?> findSerializerByPrimaryType(JavaType type, SerializationConfig config2, BasicBeanDescription beanDesc, BeanProperty property, boolean staticTyping) throws JsonMappingException {
        Class<Enum<?>> raw2 = type.getRawClass();
        if (JsonSerializable.class.isAssignableFrom(raw2)) {
            if (JsonSerializableWithType.class.isAssignableFrom(raw2)) {
                return SerializableWithTypeSerializer.instance;
            }
            return SerializableSerializer.instance;
        }
        AnnotatedMethod valueMethod = beanDesc.findJsonValueMethod();
        if (valueMethod != null) {
            Method m = valueMethod.getAnnotated();
            if (config2.isEnabled(SerializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS)) {
                ClassUtil.checkAndFixAccess(m);
            }
            JsonSerializer<Object> ser = this.findSerializerFromAnnotation(config2, valueMethod, property);
            return new JsonValueSerializer(m, ser, property);
        }
        if (InetAddress.class.isAssignableFrom(raw2)) {
            return InetAddressSerializer.instance;
        }
        if (TimeZone.class.isAssignableFrom(raw2)) {
            return TimeZoneSerializer.instance;
        }
        if (Charset.class.isAssignableFrom(raw2)) {
            return ToStringSerializer.instance;
        }
        JsonSerializer<?> ser = this.optionalHandlers.findSerializer(config2, type);
        if (ser != null) {
            return ser;
        }
        if (Number.class.isAssignableFrom(raw2)) {
            return StdSerializers.NumberSerializer.instance;
        }
        if (Enum.class.isAssignableFrom(raw2)) {
            Class<Enum<?>> enumClass = raw2;
            return EnumSerializer.construct(enumClass, config2, beanDesc);
        }
        if (Calendar.class.isAssignableFrom(raw2)) {
            return CalendarSerializer.instance;
        }
        if (Date.class.isAssignableFrom(raw2)) {
            return DateSerializer.instance;
        }
        return null;
    }

    public final JsonSerializer<?> findSerializerByAddonType(SerializationConfig config2, JavaType javaType2, BasicBeanDescription beanDesc, BeanProperty property, boolean staticTyping) throws JsonMappingException {
        Class<?> type = javaType2.getRawClass();
        if (Iterator.class.isAssignableFrom(type)) {
            return this.buildIteratorSerializer(config2, javaType2, beanDesc, property, staticTyping);
        }
        if (Iterable.class.isAssignableFrom(type)) {
            return this.buildIterableSerializer(config2, javaType2, beanDesc, property, staticTyping);
        }
        if (CharSequence.class.isAssignableFrom(type)) {
            return ToStringSerializer.instance;
        }
        return null;
    }

    protected JsonSerializer<Object> findSerializerFromAnnotation(SerializationConfig config2, Annotated a, BeanProperty property) throws JsonMappingException {
        Object serDef = config2.getAnnotationIntrospector().findSerializer(a);
        if (serDef == null) {
            return null;
        }
        if (serDef instanceof JsonSerializer) {
            JsonSerializer ser = (JsonSerializer)serDef;
            if (ser instanceof ContextualSerializer) {
                return ((ContextualSerializer)((Object)ser)).createContextual(config2, property);
            }
            return ser;
        }
        if (!(serDef instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector returned value of type " + serDef.getClass().getName() + "; expected type JsonSerializer or Class<JsonSerializer> instead");
        }
        Class cls = (Class)serDef;
        if (!JsonSerializer.class.isAssignableFrom(cls)) {
            throw new IllegalStateException("AnnotationIntrospector returned Class " + cls.getName() + "; expected Class<JsonSerializer>");
        }
        JsonSerializer<Object> ser = config2.serializerInstance(a, cls);
        if (ser instanceof ContextualSerializer) {
            return ((ContextualSerializer)((Object)ser)).createContextual(config2, property);
        }
        return ser;
    }

    public JsonSerializer<?> buildContainerSerializer(SerializationConfig config2, JavaType type, BasicBeanDescription beanDesc, BeanProperty property, boolean staticTyping) {
        JavaType elementType2 = type.getContentType();
        TypeSerializer elementTypeSerializer = this.createTypeSerializer(config2, elementType2, property);
        if (elementTypeSerializer != null) {
            staticTyping = false;
        } else if (!staticTyping) {
            staticTyping = this.usesStaticTyping(config2, beanDesc, elementTypeSerializer, property);
        }
        JsonSerializer<Object> elementValueSerializer = BasicSerializerFactory.findContentSerializer(config2, beanDesc.getClassInfo(), property);
        if (type.isMapLikeType()) {
            MapLikeType mlt = (MapLikeType)type;
            JsonSerializer<Object> keySerializer = BasicSerializerFactory.findKeySerializer(config2, beanDesc.getClassInfo(), property);
            if (mlt.isTrueMapType()) {
                return this.buildMapSerializer(config2, (MapType)mlt, beanDesc, property, staticTyping, keySerializer, elementTypeSerializer, elementValueSerializer);
            }
            return this.buildMapLikeSerializer(config2, mlt, beanDesc, property, staticTyping, keySerializer, elementTypeSerializer, elementValueSerializer);
        }
        if (type.isCollectionLikeType()) {
            CollectionLikeType clt = (CollectionLikeType)type;
            if (clt.isTrueCollectionType()) {
                return this.buildCollectionSerializer(config2, (CollectionType)clt, beanDesc, property, staticTyping, elementTypeSerializer, elementValueSerializer);
            }
            return this.buildCollectionLikeSerializer(config2, clt, beanDesc, property, staticTyping, elementTypeSerializer, elementValueSerializer);
        }
        if (type.isArrayType()) {
            return this.buildArraySerializer(config2, (ArrayType)type, beanDesc, property, staticTyping, elementTypeSerializer, elementValueSerializer);
        }
        return null;
    }

    protected JsonSerializer<?> buildCollectionLikeSerializer(SerializationConfig config2, CollectionLikeType type, BasicBeanDescription beanDesc, BeanProperty property, boolean staticTyping, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) {
        for (Serializers serializers : this.customSerializers()) {
            JsonSerializer<?> ser = serializers.findCollectionLikeSerializer(config2, type, beanDesc, property, elementTypeSerializer, elementValueSerializer);
            if (ser == null) continue;
            return ser;
        }
        return null;
    }

    protected JsonSerializer<?> buildCollectionSerializer(SerializationConfig config2, CollectionType type, BasicBeanDescription beanDesc, BeanProperty property, boolean staticTyping, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) {
        for (Serializers serializers : this.customSerializers()) {
            JsonSerializer<?> ser = serializers.findCollectionSerializer(config2, type, beanDesc, property, elementTypeSerializer, elementValueSerializer);
            if (ser == null) continue;
            return ser;
        }
        Class<?> raw2 = type.getRawClass();
        if (EnumSet.class.isAssignableFrom(raw2)) {
            return this.buildEnumSetSerializer(config2, type, beanDesc, property, staticTyping, elementTypeSerializer, elementValueSerializer);
        }
        Class<?> elementRaw = type.getContentType().getRawClass();
        if (this.isIndexedList(raw2)) {
            if (elementRaw == String.class) {
                return new IndexedStringListSerializer(property, elementValueSerializer);
            }
            return StdContainerSerializers.indexedListSerializer(type.getContentType(), staticTyping, elementTypeSerializer, property, elementValueSerializer);
        }
        if (elementRaw == String.class) {
            return new StringCollectionSerializer(property, elementValueSerializer);
        }
        return StdContainerSerializers.collectionSerializer(type.getContentType(), staticTyping, elementTypeSerializer, property, elementValueSerializer);
    }

    protected JsonSerializer<?> buildEnumSetSerializer(SerializationConfig config2, JavaType type, BasicBeanDescription beanDesc, BeanProperty property, boolean staticTyping, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) {
        JavaType enumType = type.getContentType();
        if (!enumType.isEnumType()) {
            enumType = null;
        }
        return StdContainerSerializers.enumSetSerializer(enumType, property);
    }

    protected boolean isIndexedList(Class<?> cls) {
        return RandomAccess.class.isAssignableFrom(cls);
    }

    protected JsonSerializer<?> buildMapLikeSerializer(SerializationConfig config2, MapLikeType type, BasicBeanDescription beanDesc, BeanProperty property, boolean staticTyping, JsonSerializer<Object> keySerializer, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) {
        for (Serializers serializers : this.customSerializers()) {
            JsonSerializer<?> ser = serializers.findMapLikeSerializer(config2, type, beanDesc, property, keySerializer, elementTypeSerializer, elementValueSerializer);
            if (ser == null) continue;
            return ser;
        }
        return null;
    }

    protected JsonSerializer<?> buildMapSerializer(SerializationConfig config2, MapType type, BasicBeanDescription beanDesc, BeanProperty property, boolean staticTyping, JsonSerializer<Object> keySerializer, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) {
        for (Serializers serializers : this.customSerializers()) {
            JsonSerializer<?> ser = serializers.findMapSerializer(config2, type, beanDesc, property, keySerializer, elementTypeSerializer, elementValueSerializer);
            if (ser == null) continue;
            return ser;
        }
        if (EnumMap.class.isAssignableFrom(type.getRawClass())) {
            return this.buildEnumMapSerializer(config2, type, beanDesc, property, staticTyping, elementTypeSerializer, elementValueSerializer);
        }
        return MapSerializer.construct(config2.getAnnotationIntrospector().findPropertiesToIgnore(beanDesc.getClassInfo()), type, staticTyping, elementTypeSerializer, property, keySerializer, elementValueSerializer);
    }

    protected JsonSerializer<?> buildEnumMapSerializer(SerializationConfig config2, JavaType type, BasicBeanDescription beanDesc, BeanProperty property, boolean staticTyping, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) {
        JavaType keyType = type.getKeyType();
        EnumValues enums = null;
        if (keyType.isEnumType()) {
            Class<Enum<?>> enumClass = keyType.getRawClass();
            enums = EnumValues.construct(enumClass, config2.getAnnotationIntrospector());
        }
        return new EnumMapSerializer(type.getContentType(), staticTyping, enums, elementTypeSerializer, property, elementValueSerializer);
    }

    protected JsonSerializer<?> buildArraySerializer(SerializationConfig config2, ArrayType type, BasicBeanDescription beanDesc, BeanProperty property, boolean staticTyping, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) {
        Class<?> raw2 = type.getRawClass();
        if (String[].class == raw2) {
            return new StdArraySerializers.StringArraySerializer(property);
        }
        JsonSerializer<?> ser = _arraySerializers.get(raw2.getName());
        if (ser != null) {
            return ser;
        }
        return new ObjectArraySerializer(type.getContentType(), staticTyping, elementTypeSerializer, property, elementValueSerializer);
    }

    protected JsonSerializer<?> buildIteratorSerializer(SerializationConfig config2, JavaType type, BasicBeanDescription beanDesc, BeanProperty property, boolean staticTyping) {
        JavaType valueType = type.containedType(0);
        if (valueType == null) {
            valueType = TypeFactory.unknownType();
        }
        TypeSerializer vts = this.createTypeSerializer(config2, valueType, property);
        return StdContainerSerializers.iteratorSerializer(valueType, this.usesStaticTyping(config2, beanDesc, vts, property), vts, property);
    }

    protected JsonSerializer<?> buildIterableSerializer(SerializationConfig config2, JavaType type, BasicBeanDescription beanDesc, BeanProperty property, boolean staticTyping) {
        JavaType valueType = type.containedType(0);
        if (valueType == null) {
            valueType = TypeFactory.unknownType();
        }
        TypeSerializer vts = this.createTypeSerializer(config2, valueType, property);
        return StdContainerSerializers.iterableSerializer(valueType, this.usesStaticTyping(config2, beanDesc, vts, property), vts, property);
    }

    protected <T extends JavaType> T modifyTypeByAnnotation(SerializationConfig config2, Annotated a, T type) {
        Class<?> superclass = config2.getAnnotationIntrospector().findSerializationType(a);
        if (superclass != null) {
            try {
                type = type.widenBy(superclass);
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("Failed to widen type " + type + " with concrete-type annotation (value " + superclass.getName() + "), method '" + a.getName() + "': " + iae.getMessage());
            }
        }
        return BasicSerializerFactory.modifySecondaryTypesByAnnotation(config2, a, type);
    }

    protected static <T extends JavaType> T modifySecondaryTypesByAnnotation(SerializationConfig config2, Annotated a, T type) {
        AnnotationIntrospector intr = config2.getAnnotationIntrospector();
        if (((JavaType)type).isContainerType()) {
            Class<?> cc;
            Class<?> keyClass = intr.findSerializationKeyType(a, ((JavaType)type).getKeyType());
            if (keyClass != null) {
                if (!(type instanceof MapType)) {
                    throw new IllegalArgumentException("Illegal key-type annotation: type " + type + " is not a Map type");
                }
                try {
                    type = ((MapType)type).widenKey(keyClass);
                }
                catch (IllegalArgumentException iae) {
                    throw new IllegalArgumentException("Failed to narrow key type " + type + " with key-type annotation (" + keyClass.getName() + "): " + iae.getMessage());
                }
            }
            if ((cc = intr.findSerializationContentType(a, ((JavaType)type).getContentType())) != null) {
                try {
                    type = ((JavaType)type).widenContentsBy(cc);
                }
                catch (IllegalArgumentException iae) {
                    throw new IllegalArgumentException("Failed to narrow content type " + type + " with content-type annotation (" + cc.getName() + "): " + iae.getMessage());
                }
            }
        }
        return (T)type;
    }

    protected static JsonSerializer<Object> findKeySerializer(SerializationConfig config2, Annotated a, BeanProperty property) {
        AnnotationIntrospector intr = config2.getAnnotationIntrospector();
        Class<? extends JsonSerializer<?>> serClass = intr.findKeySerializer(a);
        if ((serClass == null || serClass == JsonSerializer.None.class) && property != null) {
            serClass = intr.findKeySerializer(property.getMember());
        }
        if (serClass != null && serClass != JsonSerializer.None.class) {
            return config2.serializerInstance(a, serClass);
        }
        return null;
    }

    protected static JsonSerializer<Object> findContentSerializer(SerializationConfig config2, Annotated a, BeanProperty property) {
        AnnotationIntrospector intr = config2.getAnnotationIntrospector();
        Class<? extends JsonSerializer<?>> serClass = intr.findContentSerializer(a);
        if ((serClass == null || serClass == JsonSerializer.None.class) && property != null) {
            serClass = intr.findContentSerializer(property.getMember());
        }
        if (serClass != null && serClass != JsonSerializer.None.class) {
            return config2.serializerInstance(a, serClass);
        }
        return null;
    }

    protected boolean usesStaticTyping(SerializationConfig config2, BasicBeanDescription beanDesc, TypeSerializer typeSer, BeanProperty property) {
        JavaType type;
        if (typeSer != null) {
            return false;
        }
        AnnotationIntrospector intr = config2.getAnnotationIntrospector();
        JsonSerialize.Typing t = intr.findSerializationTyping(beanDesc.getClassInfo());
        if (t != null ? t == JsonSerialize.Typing.STATIC : config2.isEnabled(SerializationConfig.Feature.USE_STATIC_TYPING)) {
            return true;
        }
        if (property != null && (type = property.getType()).isContainerType()) {
            if (intr.findSerializationContentType(property.getMember(), property.getType()) != null) {
                return true;
            }
            if (type instanceof MapType && intr.findSerializationKeyType(property.getMember(), property.getType()) != null) {
                return true;
            }
        }
        return false;
    }

    static {
        _concrete.put(String.class.getName(), new StringSerializer());
        ToStringSerializer sls = ToStringSerializer.instance;
        _concrete.put(StringBuffer.class.getName(), sls);
        _concrete.put(StringBuilder.class.getName(), sls);
        _concrete.put(Character.class.getName(), sls);
        _concrete.put(Character.TYPE.getName(), sls);
        _concrete.put(Boolean.TYPE.getName(), new StdSerializers.BooleanSerializer(true));
        _concrete.put(Boolean.class.getName(), new StdSerializers.BooleanSerializer(false));
        StdSerializers.IntegerSerializer intS = new StdSerializers.IntegerSerializer();
        _concrete.put(Integer.class.getName(), intS);
        _concrete.put(Integer.TYPE.getName(), intS);
        _concrete.put(Long.class.getName(), StdSerializers.LongSerializer.instance);
        _concrete.put(Long.TYPE.getName(), StdSerializers.LongSerializer.instance);
        _concrete.put(Byte.class.getName(), StdSerializers.IntLikeSerializer.instance);
        _concrete.put(Byte.TYPE.getName(), StdSerializers.IntLikeSerializer.instance);
        _concrete.put(Short.class.getName(), StdSerializers.IntLikeSerializer.instance);
        _concrete.put(Short.TYPE.getName(), StdSerializers.IntLikeSerializer.instance);
        _concrete.put(Float.class.getName(), StdSerializers.FloatSerializer.instance);
        _concrete.put(Float.TYPE.getName(), StdSerializers.FloatSerializer.instance);
        _concrete.put(Double.class.getName(), StdSerializers.DoubleSerializer.instance);
        _concrete.put(Double.TYPE.getName(), StdSerializers.DoubleSerializer.instance);
        StdSerializers.NumberSerializer ns = new StdSerializers.NumberSerializer();
        _concrete.put(BigInteger.class.getName(), ns);
        _concrete.put(BigDecimal.class.getName(), ns);
        _concrete.put(Calendar.class.getName(), CalendarSerializer.instance);
        DateSerializer dateSer = DateSerializer.instance;
        _concrete.put(Date.class.getName(), dateSer);
        _concrete.put(Timestamp.class.getName(), dateSer);
        _concrete.put(java.sql.Date.class.getName(), new StdSerializers.SqlDateSerializer());
        _concrete.put(Time.class.getName(), new StdSerializers.SqlTimeSerializer());
        for (Map.Entry<Class<?>, Object> en : new StdJdkSerializers().provide()) {
            Object value2 = en.getValue();
            if (value2 instanceof JsonSerializer) {
                _concrete.put(en.getKey().getName(), (JsonSerializer)value2);
                continue;
            }
            if (value2 instanceof Class) {
                Class cls = (Class)value2;
                _concreteLazy.put(en.getKey().getName(), cls);
                continue;
            }
            throw new IllegalStateException("Internal error: unrecognized value of type " + en.getClass().getName());
        }
        _concreteLazy.put(TokenBuffer.class.getName(), TokenBufferSerializer.class);
        _arraySerializers = new HashMap();
        _arraySerializers.put(boolean[].class.getName(), new StdArraySerializers.BooleanArraySerializer());
        _arraySerializers.put(byte[].class.getName(), new StdArraySerializers.ByteArraySerializer());
        _arraySerializers.put(char[].class.getName(), new StdArraySerializers.CharArraySerializer());
        _arraySerializers.put(short[].class.getName(), new StdArraySerializers.ShortArraySerializer());
        _arraySerializers.put(int[].class.getName(), new StdArraySerializers.IntArraySerializer());
        _arraySerializers.put(long[].class.getName(), new StdArraySerializers.LongArraySerializer());
        _arraySerializers.put(float[].class.getName(), new StdArraySerializers.FloatArraySerializer());
        _arraySerializers.put(double[].class.getName(), new StdArraySerializers.DoubleArraySerializer());
    }
}

