/*
 * Decompiled with CFR 0.152.
 */
package shaded.parquet.org.codehaus.jackson.map.introspect;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import shaded.parquet.org.codehaus.jackson.map.AnnotationIntrospector;
import shaded.parquet.org.codehaus.jackson.map.BeanPropertyDefinition;
import shaded.parquet.org.codehaus.jackson.map.MapperConfig;
import shaded.parquet.org.codehaus.jackson.map.PropertyNamingStrategy;
import shaded.parquet.org.codehaus.jackson.map.introspect.AnnotatedClass;
import shaded.parquet.org.codehaus.jackson.map.introspect.AnnotatedConstructor;
import shaded.parquet.org.codehaus.jackson.map.introspect.AnnotatedField;
import shaded.parquet.org.codehaus.jackson.map.introspect.AnnotatedMember;
import shaded.parquet.org.codehaus.jackson.map.introspect.AnnotatedMethod;
import shaded.parquet.org.codehaus.jackson.map.introspect.AnnotatedParameter;
import shaded.parquet.org.codehaus.jackson.map.introspect.POJOPropertyBuilder;
import shaded.parquet.org.codehaus.jackson.map.introspect.VisibilityChecker;
import shaded.parquet.org.codehaus.jackson.map.util.BeanUtil;
import shaded.parquet.org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POJOPropertiesCollector {
    protected final MapperConfig<?> _config;
    protected final boolean _forSerialization;
    protected final JavaType _type;
    protected final AnnotatedClass _classDef;
    protected final VisibilityChecker<?> _visibilityChecker;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected final LinkedHashMap<String, POJOPropertyBuilder> _properties = new LinkedHashMap();
    protected LinkedList<POJOPropertyBuilder> _creatorProperties = null;
    protected LinkedList<AnnotatedMethod> _anyGetters = null;
    protected LinkedList<AnnotatedMethod> _anySetters = null;
    protected LinkedList<AnnotatedMethod> _jsonValueGetters = null;
    protected Set<String> _ignoredPropertyNames;
    protected Set<String> _ignoredPropertyNamesForDeser;
    protected LinkedHashMap<Object, AnnotatedMember> _injectables;

    protected POJOPropertiesCollector(MapperConfig<?> config2, boolean forSerialization, JavaType type, AnnotatedClass classDef2) {
        this._config = config2;
        this._forSerialization = forSerialization;
        this._type = type;
        this._classDef = classDef2;
        this._annotationIntrospector = config2.isAnnotationProcessingEnabled() ? this._config.getAnnotationIntrospector() : null;
        this._visibilityChecker = this._annotationIntrospector == null ? this._config.getDefaultVisibilityChecker() : this._annotationIntrospector.findAutoDetectVisibility(classDef2, this._config.getDefaultVisibilityChecker());
    }

    public MapperConfig<?> getConfig() {
        return this._config;
    }

    public JavaType getType() {
        return this._type;
    }

    public AnnotatedClass getClassDef() {
        return this._classDef;
    }

    public AnnotationIntrospector getAnnotationIntrospector() {
        return this._annotationIntrospector;
    }

    public List<BeanPropertyDefinition> getProperties() {
        return new ArrayList<BeanPropertyDefinition>(this._properties.values());
    }

    public Map<Object, AnnotatedMember> getInjectables() {
        return this._injectables;
    }

    public AnnotatedMethod getJsonValueMethod() {
        if (this._jsonValueGetters != null) {
            if (this._jsonValueGetters.size() > 1) {
                this.reportProblem("Multiple value properties defined (" + this._jsonValueGetters.get(0) + " vs " + this._jsonValueGetters.get(1) + ")");
            }
            return this._jsonValueGetters.get(0);
        }
        return null;
    }

    public AnnotatedMethod getAnyGetterMethod() {
        if (this._anyGetters != null) {
            if (this._anyGetters.size() > 1) {
                this.reportProblem("Multiple 'any-getters' defined (" + this._anyGetters.get(0) + " vs " + this._anyGetters.get(1) + ")");
            }
            return this._anyGetters.getFirst();
        }
        return null;
    }

    public AnnotatedMethod getAnySetterMethod() {
        if (this._anySetters != null) {
            if (this._anySetters.size() > 1) {
                this.reportProblem("Multiple 'any-setters' defined (" + this._anySetters.get(0) + " vs " + this._anySetters.get(1) + ")");
            }
            return this._anySetters.getFirst();
        }
        return null;
    }

    public Set<String> getIgnoredPropertyNames() {
        return this._ignoredPropertyNames;
    }

    public Set<String> getIgnoredPropertyNamesForDeser() {
        return this._ignoredPropertyNamesForDeser;
    }

    protected Map<String, POJOPropertyBuilder> getPropertyMap() {
        return this._properties;
    }

    public POJOPropertiesCollector collect() {
        this._properties.clear();
        this._addFields();
        this._addMethods();
        this._addCreators();
        this._addInjectables();
        this._removeUnwantedProperties();
        this._renameProperties();
        PropertyNamingStrategy naming = this._config.getPropertyNamingStrategy();
        if (naming != null) {
            this._renameUsing(naming);
        }
        for (POJOPropertyBuilder property : this._properties.values()) {
            property.trimByVisibility();
        }
        for (POJOPropertyBuilder property : this._properties.values()) {
            property.mergeAnnotations(this._forSerialization);
        }
        this._sortProperties();
        return this;
    }

    protected void _sortProperties() {
        AnnotationIntrospector intr = this._config.getAnnotationIntrospector();
        Boolean alpha = intr.findSerializationSortAlphabetically(this._classDef);
        boolean sort2 = alpha == null ? this._config.shouldSortPropertiesAlphabetically() : alpha.booleanValue();
        String[] propertyOrder = intr.findSerializationPropertyOrder(this._classDef);
        if (!sort2 && this._creatorProperties == null && propertyOrder == null) {
            return;
        }
        int size2 = this._properties.size();
        AbstractMap all = sort2 ? new TreeMap() : new LinkedHashMap(size2 + size2);
        for (POJOPropertyBuilder prop : this._properties.values()) {
            all.put(prop.getName(), prop);
        }
        LinkedHashMap<String, POJOPropertyBuilder> ordered = new LinkedHashMap<String, POJOPropertyBuilder>(size2 + size2);
        if (propertyOrder != null) {
            for (String name2 : propertyOrder) {
                POJOPropertyBuilder w = (POJOPropertyBuilder)all.get(name2);
                if (w == null) {
                    for (POJOPropertyBuilder prop : this._properties.values()) {
                        if (!name2.equals(prop.getInternalName())) continue;
                        w = prop;
                        name2 = prop.getName();
                        break;
                    }
                }
                if (w == null) continue;
                ordered.put(name2, w);
            }
        }
        if (this._creatorProperties != null) {
            for (POJOPropertyBuilder prop : this._creatorProperties) {
                ordered.put(prop.getName(), prop);
            }
        }
        ordered.putAll(all);
        this._properties.clear();
        this._properties.putAll(ordered);
    }

    protected void _addFields() {
        AnnotationIntrospector ai = this._annotationIntrospector;
        for (AnnotatedField f2 : this._classDef.fields()) {
            boolean visible;
            String implName = f2.getName();
            String explName = ai == null ? null : (this._forSerialization ? ai.findSerializablePropertyName(f2) : ai.findDeserializablePropertyName(f2));
            if ("".equals(explName)) {
                explName = implName;
            }
            boolean bl = visible = explName != null;
            if (!visible) {
                visible = this._visibilityChecker.isFieldVisible(f2);
            }
            boolean ignored = ai != null && ai.hasIgnoreMarker(f2);
            this._property(implName).addField(f2, explName, visible, ignored);
        }
    }

    protected void _addCreators() {
        POJOPropertyBuilder prop;
        String name2;
        AnnotatedParameter param2;
        int i;
        int len;
        AnnotationIntrospector ai = this._annotationIntrospector;
        if (ai == null) {
            return;
        }
        for (AnnotatedConstructor ctor : this._classDef.getConstructors()) {
            if (this._creatorProperties == null) {
                this._creatorProperties = new LinkedList();
            }
            len = ctor.getParameterCount();
            for (i = 0; i < len; ++i) {
                param2 = ctor.getParameter(i);
                name2 = ai.findPropertyNameForParam(param2);
                if (name2 == null) continue;
                prop = this._property(name2);
                prop.addCtor(param2, name2, true, false);
                this._creatorProperties.add(prop);
            }
        }
        for (AnnotatedMethod factory : this._classDef.getStaticMethods()) {
            if (this._creatorProperties == null) {
                this._creatorProperties = new LinkedList();
            }
            len = factory.getParameterCount();
            for (i = 0; i < len; ++i) {
                param2 = factory.getParameter(i);
                name2 = ai.findPropertyNameForParam(param2);
                if (name2 == null) continue;
                prop = this._property(name2);
                prop.addCtor(param2, name2, true, false);
                this._creatorProperties.add(prop);
            }
        }
    }

    protected void _addMethods() {
        AnnotationIntrospector ai = this._annotationIntrospector;
        for (AnnotatedMethod m : this._classDef.memberMethods()) {
            boolean ignore;
            boolean visible;
            String implName;
            String explName;
            int argCount = m.getParameterCount();
            if (argCount == 0) {
                if (ai != null) {
                    if (ai.hasAnyGetterAnnotation(m)) {
                        if (this._anyGetters == null) {
                            this._anyGetters = new LinkedList();
                        }
                        this._anyGetters.add(m);
                        continue;
                    }
                    if (ai.hasAsValueAnnotation(m)) {
                        if (this._jsonValueGetters == null) {
                            this._jsonValueGetters = new LinkedList();
                        }
                        this._jsonValueGetters.add(m);
                        continue;
                    }
                }
                String string2 = explName = ai == null ? null : ai.findGettablePropertyName(m);
                if (explName == null) {
                    implName = BeanUtil.okNameForRegularGetter(m, m.getName());
                    if (implName == null) {
                        implName = BeanUtil.okNameForIsGetter(m, m.getName());
                        if (implName == null) continue;
                        visible = this._visibilityChecker.isIsGetterVisible(m);
                    } else {
                        visible = this._visibilityChecker.isGetterVisible(m);
                    }
                } else {
                    implName = BeanUtil.okNameForGetter(m);
                    if (implName == null) {
                        implName = m.getName();
                    }
                    if (explName.length() == 0) {
                        explName = implName;
                    }
                    visible = true;
                }
                ignore = ai == null ? false : ai.hasIgnoreMarker(m);
                this._property(implName).addGetter(m, explName, visible, ignore);
                continue;
            }
            if (argCount == 1) {
                String string3 = explName = ai == null ? null : ai.findSettablePropertyName(m);
                if (explName == null) {
                    implName = BeanUtil.okNameForSetter(m);
                    if (implName == null) continue;
                    visible = this._visibilityChecker.isSetterVisible(m);
                } else {
                    implName = BeanUtil.okNameForSetter(m);
                    if (implName == null) {
                        implName = m.getName();
                    }
                    if (explName.length() == 0) {
                        explName = implName;
                    }
                    visible = true;
                }
                ignore = ai == null ? false : ai.hasIgnoreMarker(m);
                this._property(implName).addSetter(m, explName, visible, ignore);
                continue;
            }
            if (argCount != 2 || ai == null || !ai.hasAnySetterAnnotation(m)) continue;
            if (this._anySetters == null) {
                this._anySetters = new LinkedList();
            }
            this._anySetters.add(m);
        }
    }

    protected void _addInjectables() {
        AnnotationIntrospector ai = this._annotationIntrospector;
        if (ai == null) {
            return;
        }
        for (AnnotatedField f2 : this._classDef.fields()) {
            this._doAddInjectable(ai.findInjectableValueId(f2), f2);
        }
        for (AnnotatedMethod m : this._classDef.memberMethods()) {
            if (m.getParameterCount() != 1) continue;
            this._doAddInjectable(ai.findInjectableValueId(m), m);
        }
    }

    protected void _doAddInjectable(Object id, AnnotatedMember m) {
        AnnotatedMember prev;
        if (id == null) {
            return;
        }
        if (this._injectables == null) {
            this._injectables = new LinkedHashMap();
        }
        if ((prev = this._injectables.put(id, m)) != null) {
            String type = id == null ? "[null]" : id.getClass().getName();
            throw new IllegalArgumentException("Duplicate injectable value with id '" + String.valueOf(id) + "' (of type " + type + ")");
        }
    }

    protected void _removeUnwantedProperties() {
        Iterator<Map.Entry<String, POJOPropertyBuilder>> it = this._properties.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, POJOPropertyBuilder> entry2 = it.next();
            POJOPropertyBuilder prop = entry2.getValue();
            if (!prop.anyVisible()) {
                it.remove();
                continue;
            }
            if (prop.anyIgnorals()) {
                this._addIgnored(prop);
                if (!prop.anyExplicitNames()) {
                    it.remove();
                    continue;
                }
                prop.removeIgnored();
            }
            prop.removeNonVisible();
        }
    }

    private void _addIgnored(POJOPropertyBuilder prop) {
        if (this._forSerialization) {
            return;
        }
        String name2 = prop.getName();
        this._ignoredPropertyNames = this.addToSet(this._ignoredPropertyNames, name2);
        if (prop.anyDeserializeIgnorals()) {
            this._ignoredPropertyNamesForDeser = this.addToSet(this._ignoredPropertyNamesForDeser, name2);
        }
    }

    protected void _renameProperties() {
        Iterator<Map.Entry<String, POJOPropertyBuilder>> it = this._properties.entrySet().iterator();
        LinkedList<POJOPropertyBuilder> renamed = null;
        while (it.hasNext()) {
            Map.Entry<String, POJOPropertyBuilder> entry2 = it.next();
            POJOPropertyBuilder prop = entry2.getValue();
            String newName = prop.findNewName();
            if (newName == null) continue;
            if (renamed == null) {
                renamed = new LinkedList<POJOPropertyBuilder>();
            }
            prop = prop.withName(newName);
            renamed.add(prop);
            it.remove();
        }
        if (renamed != null) {
            for (POJOPropertyBuilder prop : renamed) {
                String name2 = prop.getName();
                POJOPropertyBuilder old = this._properties.get(name2);
                if (old == null) {
                    this._properties.put(name2, prop);
                    continue;
                }
                old.addAll(prop);
            }
        }
    }

    protected void _renameUsing(PropertyNamingStrategy naming) {
        POJOPropertyBuilder[] props = this._properties.values().toArray(new POJOPropertyBuilder[this._properties.size()]);
        this._properties.clear();
        for (POJOPropertyBuilder prop : props) {
            POJOPropertyBuilder old;
            String name2 = prop.getName();
            if (this._forSerialization) {
                if (prop.hasGetter()) {
                    name2 = naming.nameForGetterMethod(this._config, prop.getGetter(), name2);
                } else if (prop.hasField()) {
                    name2 = naming.nameForField(this._config, prop.getField(), name2);
                }
            } else if (prop.hasSetter()) {
                name2 = naming.nameForSetterMethod(this._config, prop.getSetter(), name2);
            } else if (prop.hasConstructorParameter()) {
                name2 = naming.nameForConstructorParameter(this._config, prop.getConstructorParameter(), name2);
            } else if (prop.hasField()) {
                name2 = naming.nameForField(this._config, prop.getField(), name2);
            } else if (prop.hasGetter()) {
                name2 = naming.nameForGetterMethod(this._config, prop.getGetter(), name2);
            }
            if (!name2.equals(prop.getName())) {
                prop = prop.withName(name2);
            }
            if ((old = this._properties.get(name2)) == null) {
                this._properties.put(name2, prop);
                continue;
            }
            old.addAll(prop);
        }
    }

    protected void reportProblem(String msg) {
        throw new IllegalArgumentException("Problem with definition of " + this._classDef + ": " + msg);
    }

    protected POJOPropertyBuilder _property(String implName) {
        POJOPropertyBuilder prop = this._properties.get(implName);
        if (prop == null) {
            prop = new POJOPropertyBuilder(implName);
            this._properties.put(implName, prop);
        }
        return prop;
    }

    private Set<String> addToSet(Set<String> set2, String str) {
        if (set2 == null) {
            set2 = new HashSet<String>();
        }
        set2.add(str);
        return set2;
    }
}

