/*
 * Decompiled with CFR 0.152.
 */
package shaded.parquet.org.codehaus.jackson.map.deser;

import java.lang.reflect.Member;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import shaded.parquet.org.codehaus.jackson.JsonNode;
import shaded.parquet.org.codehaus.jackson.map.AbstractTypeResolver;
import shaded.parquet.org.codehaus.jackson.map.AnnotationIntrospector;
import shaded.parquet.org.codehaus.jackson.map.BeanProperty;
import shaded.parquet.org.codehaus.jackson.map.BeanPropertyDefinition;
import shaded.parquet.org.codehaus.jackson.map.DeserializationConfig;
import shaded.parquet.org.codehaus.jackson.map.DeserializerFactory;
import shaded.parquet.org.codehaus.jackson.map.DeserializerProvider;
import shaded.parquet.org.codehaus.jackson.map.Deserializers;
import shaded.parquet.org.codehaus.jackson.map.JsonDeserializer;
import shaded.parquet.org.codehaus.jackson.map.JsonMappingException;
import shaded.parquet.org.codehaus.jackson.map.KeyDeserializer;
import shaded.parquet.org.codehaus.jackson.map.KeyDeserializers;
import shaded.parquet.org.codehaus.jackson.map.TypeDeserializer;
import shaded.parquet.org.codehaus.jackson.map.deser.AbstractDeserializer;
import shaded.parquet.org.codehaus.jackson.map.deser.BasicDeserializerFactory;
import shaded.parquet.org.codehaus.jackson.map.deser.BeanDeserializer;
import shaded.parquet.org.codehaus.jackson.map.deser.BeanDeserializerBuilder;
import shaded.parquet.org.codehaus.jackson.map.deser.BeanDeserializerModifier;
import shaded.parquet.org.codehaus.jackson.map.deser.SettableAnyProperty;
import shaded.parquet.org.codehaus.jackson.map.deser.SettableBeanProperty;
import shaded.parquet.org.codehaus.jackson.map.deser.ValueInstantiator;
import shaded.parquet.org.codehaus.jackson.map.deser.ValueInstantiators;
import shaded.parquet.org.codehaus.jackson.map.deser.impl.CreatorCollector;
import shaded.parquet.org.codehaus.jackson.map.deser.impl.CreatorProperty;
import shaded.parquet.org.codehaus.jackson.map.deser.std.StdKeyDeserializers;
import shaded.parquet.org.codehaus.jackson.map.deser.std.ThrowableDeserializer;
import shaded.parquet.org.codehaus.jackson.map.introspect.AnnotatedClass;
import shaded.parquet.org.codehaus.jackson.map.introspect.AnnotatedConstructor;
import shaded.parquet.org.codehaus.jackson.map.introspect.AnnotatedField;
import shaded.parquet.org.codehaus.jackson.map.introspect.AnnotatedMember;
import shaded.parquet.org.codehaus.jackson.map.introspect.AnnotatedMethod;
import shaded.parquet.org.codehaus.jackson.map.introspect.AnnotatedParameter;
import shaded.parquet.org.codehaus.jackson.map.introspect.BasicBeanDescription;
import shaded.parquet.org.codehaus.jackson.map.introspect.VisibilityChecker;
import shaded.parquet.org.codehaus.jackson.map.type.ArrayType;
import shaded.parquet.org.codehaus.jackson.map.type.CollectionLikeType;
import shaded.parquet.org.codehaus.jackson.map.type.CollectionType;
import shaded.parquet.org.codehaus.jackson.map.type.MapLikeType;
import shaded.parquet.org.codehaus.jackson.map.type.MapType;
import shaded.parquet.org.codehaus.jackson.map.util.ArrayBuilders;
import shaded.parquet.org.codehaus.jackson.map.util.ClassUtil;
import shaded.parquet.org.codehaus.jackson.map.util.EnumResolver;
import shaded.parquet.org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDeserializerFactory
extends BasicDeserializerFactory {
    private static final Class<?>[] INIT_CAUSE_PARAMS = new Class[]{Throwable.class};
    public static final BeanDeserializerFactory instance = new BeanDeserializerFactory(null);
    protected final DeserializerFactory.Config _factoryConfig;

    @Deprecated
    public BeanDeserializerFactory() {
        this(null);
    }

    public BeanDeserializerFactory(DeserializerFactory.Config config2) {
        if (config2 == null) {
            config2 = new ConfigImpl();
        }
        this._factoryConfig = config2;
    }

    @Override
    public final DeserializerFactory.Config getConfig() {
        return this._factoryConfig;
    }

    @Override
    public DeserializerFactory withConfig(DeserializerFactory.Config config2) {
        if (this._factoryConfig == config2) {
            return this;
        }
        if (this.getClass() != BeanDeserializerFactory.class) {
            throw new IllegalStateException("Subtype of BeanDeserializerFactory (" + this.getClass().getName() + ") has not properly overridden method 'withAdditionalDeserializers': can not instantiate subtype with " + "additional deserializer definitions");
        }
        return new BeanDeserializerFactory(config2);
    }

    @Override
    public KeyDeserializer createKeyDeserializer(DeserializationConfig config2, JavaType type, BeanProperty property) throws JsonMappingException {
        Class<?> raw2;
        if (this._factoryConfig.hasKeyDeserializers()) {
            BasicBeanDescription beanDesc = (BasicBeanDescription)config2.introspectClassAnnotations(type.getRawClass());
            for (KeyDeserializers d : this._factoryConfig.keyDeserializers()) {
                KeyDeserializer deser = d.findKeyDeserializer(type, config2, beanDesc, property);
                if (deser == null) continue;
                return deser;
            }
        }
        if ((raw2 = type.getRawClass()) == String.class || raw2 == Object.class) {
            return StdKeyDeserializers.constructStringKeyDeserializer(config2, type);
        }
        KeyDeserializer kdes = (KeyDeserializer)_keyDeserializers.get(type);
        if (kdes != null) {
            return kdes;
        }
        if (type.isEnumType()) {
            return this._createEnumKeyDeserializer(config2, type, property);
        }
        kdes = StdKeyDeserializers.findStringBasedKeyDeserializer(config2, type);
        return kdes;
    }

    private KeyDeserializer _createEnumKeyDeserializer(DeserializationConfig config2, JavaType type, BeanProperty property) throws JsonMappingException {
        BasicBeanDescription beanDesc = (BasicBeanDescription)config2.introspect(type);
        Class<?> enumClass = type.getRawClass();
        EnumResolver<?> enumRes = this.constructEnumResolver(enumClass, config2);
        for (AnnotatedMethod factory : beanDesc.getFactoryMethods()) {
            Class<?> returnType;
            if (!config2.getAnnotationIntrospector().hasCreatorAnnotation(factory)) continue;
            int argCount = factory.getParameterCount();
            if (argCount == 1 && (returnType = factory.getRawType()).isAssignableFrom(enumClass)) {
                if (factory.getParameterType(0) != String.class) {
                    throw new IllegalArgumentException("Parameter #0 type for factory method (" + factory + ") not suitable, must be java.lang.String");
                }
                if (config2.canOverrideAccessModifiers()) {
                    ClassUtil.checkAndFixAccess(factory.getMember());
                }
                return StdKeyDeserializers.constructEnumKeyDeserializer(enumRes, factory);
            }
            throw new IllegalArgumentException("Unsuitable method (" + factory + ") decorated with @JsonCreator (for Enum type " + enumClass.getName() + ")");
        }
        return StdKeyDeserializers.constructEnumKeyDeserializer(enumRes);
    }

    @Override
    protected JsonDeserializer<?> _findCustomArrayDeserializer(ArrayType type, DeserializationConfig config2, DeserializerProvider provider, BeanProperty property, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> deser = d.findArrayDeserializer(type, config2, provider, property, elementTypeDeserializer, elementDeserializer);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    @Override
    protected JsonDeserializer<?> _findCustomCollectionDeserializer(CollectionType type, DeserializationConfig config2, DeserializerProvider provider, BasicBeanDescription beanDesc, BeanProperty property, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> deser = d.findCollectionDeserializer(type, config2, provider, beanDesc, property, elementTypeDeserializer, elementDeserializer);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    @Override
    protected JsonDeserializer<?> _findCustomCollectionLikeDeserializer(CollectionLikeType type, DeserializationConfig config2, DeserializerProvider provider, BasicBeanDescription beanDesc, BeanProperty property, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> deser = d.findCollectionLikeDeserializer(type, config2, provider, beanDesc, property, elementTypeDeserializer, elementDeserializer);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    @Override
    protected JsonDeserializer<?> _findCustomEnumDeserializer(Class<?> type, DeserializationConfig config2, BasicBeanDescription beanDesc, BeanProperty property) throws JsonMappingException {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> deser = d.findEnumDeserializer(type, config2, beanDesc, property);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    @Override
    protected JsonDeserializer<?> _findCustomMapDeserializer(MapType type, DeserializationConfig config2, DeserializerProvider provider, BasicBeanDescription beanDesc, BeanProperty property, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> deser = d.findMapDeserializer(type, config2, provider, beanDesc, property, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    @Override
    protected JsonDeserializer<?> _findCustomMapLikeDeserializer(MapLikeType type, DeserializationConfig config2, DeserializerProvider provider, BasicBeanDescription beanDesc, BeanProperty property, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> deser = d.findMapLikeDeserializer(type, config2, provider, beanDesc, property, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    @Override
    protected JsonDeserializer<?> _findCustomTreeNodeDeserializer(Class<? extends JsonNode> type, DeserializationConfig config2, BeanProperty property) throws JsonMappingException {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> deser = d.findTreeNodeDeserializer(type, config2, property);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    protected JsonDeserializer<Object> _findCustomBeanDeserializer(JavaType type, DeserializationConfig config2, DeserializerProvider provider, BasicBeanDescription beanDesc, BeanProperty property) throws JsonMappingException {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            JsonDeserializer<Object> deser = d.findBeanDeserializer(type, config2, provider, beanDesc, property);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    @Override
    public JavaType mapAbstractType(DeserializationConfig config2, JavaType type) throws JsonMappingException {
        JavaType next2;
        while ((next2 = this._mapAbstractType2(config2, type)) != null) {
            Class<?> nextCls;
            Class<?> prevCls = type.getRawClass();
            if (prevCls == (nextCls = next2.getRawClass()) || !prevCls.isAssignableFrom(nextCls)) {
                throw new IllegalArgumentException("Invalid abstract type resolution from " + type + " to " + next2 + ": latter is not a subtype of former");
            }
            type = next2;
        }
        return type;
    }

    @Override
    public ValueInstantiator findValueInstantiator(DeserializationConfig config2, BasicBeanDescription beanDesc) throws JsonMappingException {
        ValueInstantiator instantiator;
        AnnotatedClass ac = beanDesc.getClassInfo();
        Object instDef = config2.getAnnotationIntrospector().findValueInstantiator(ac);
        if (instDef != null) {
            if (instDef instanceof ValueInstantiator) {
                instantiator = (ValueInstantiator)instDef;
            } else {
                if (!(instDef instanceof Class)) {
                    throw new IllegalStateException("Invalid value instantiator returned for type " + beanDesc + ": neither a Class nor ValueInstantiator");
                }
                Class cls = (Class)instDef;
                if (!ValueInstantiator.class.isAssignableFrom(cls)) {
                    throw new IllegalStateException("Invalid instantiator Class<?> returned for type " + beanDesc + ": " + cls.getName() + " not a ValueInstantiator");
                }
                Class instClass = cls;
                instantiator = config2.valueInstantiatorInstance(ac, instClass);
            }
        } else {
            instantiator = this.constructDefaultValueInstantiator(config2, beanDesc);
        }
        if (this._factoryConfig.hasValueInstantiators()) {
            for (ValueInstantiators insts : this._factoryConfig.valueInstantiators()) {
                instantiator = insts.findValueInstantiator(config2, beanDesc, instantiator);
                if (instantiator != null) continue;
                throw new JsonMappingException("Broken registered ValueInstantiators (of type " + insts.getClass().getName() + "): returned null ValueInstantiator");
            }
        }
        return instantiator;
    }

    @Override
    public JsonDeserializer<Object> createBeanDeserializer(DeserializationConfig config2, DeserializerProvider p, JavaType type, BeanProperty property) throws JsonMappingException {
        JavaType concreteType;
        JsonDeserializer<Object> custom;
        BasicBeanDescription beanDesc;
        JsonDeserializer<Object> ad;
        if (type.isAbstract()) {
            type = this.mapAbstractType(config2, type);
        }
        if ((ad = this.findDeserializerFromAnnotation(config2, (beanDesc = (BasicBeanDescription)config2.introspect(type)).getClassInfo(), property)) != null) {
            return ad;
        }
        JavaType newType = this.modifyTypeByAnnotation(config2, beanDesc.getClassInfo(), type, null);
        if (newType.getRawClass() != type.getRawClass()) {
            type = newType;
            beanDesc = (BasicBeanDescription)config2.introspect(type);
        }
        if ((custom = this._findCustomBeanDeserializer(type, config2, p, beanDesc, property)) != null) {
            return custom;
        }
        if (type.isThrowable()) {
            return this.buildThrowableDeserializer(config2, type, beanDesc, property);
        }
        if (type.isAbstract() && (concreteType = this.materializeAbstractType(config2, beanDesc)) != null) {
            beanDesc = (BasicBeanDescription)config2.introspect(concreteType);
            return this.buildBeanDeserializer(config2, concreteType, beanDesc, property);
        }
        JsonDeserializer<Object> deser = this.findStdBeanDeserializer(config2, p, type, property);
        if (deser != null) {
            return deser;
        }
        if (!this.isPotentialBeanType(type.getRawClass())) {
            return null;
        }
        return this.buildBeanDeserializer(config2, type, beanDesc, property);
    }

    protected JavaType _mapAbstractType2(DeserializationConfig config2, JavaType type) throws JsonMappingException {
        Class<?> currClass = type.getRawClass();
        if (this._factoryConfig.hasAbstractTypeResolvers()) {
            for (AbstractTypeResolver resolver : this._factoryConfig.abstractTypeResolvers()) {
                JavaType concrete = resolver.findTypeMapping(config2, type);
                if (concrete == null || concrete.getRawClass() == currClass) continue;
                return concrete;
            }
        }
        return null;
    }

    protected JavaType materializeAbstractType(DeserializationConfig config2, BasicBeanDescription beanDesc) throws JsonMappingException {
        JavaType abstractType = beanDesc.getType();
        for (AbstractTypeResolver r : this._factoryConfig.abstractTypeResolvers()) {
            JavaType concrete = r.resolveAbstractType(config2, abstractType);
            if (concrete == null) continue;
            return concrete;
        }
        return null;
    }

    public JsonDeserializer<Object> buildBeanDeserializer(DeserializationConfig config2, JavaType type, BasicBeanDescription beanDesc, BeanProperty property) throws JsonMappingException {
        ValueInstantiator valueInstantiator = this.findValueInstantiator(config2, beanDesc);
        if (type.isAbstract() && !valueInstantiator.canInstantiate()) {
            return new AbstractDeserializer(type);
        }
        BeanDeserializerBuilder builder = this.constructBeanDeserializerBuilder(beanDesc);
        builder.setValueInstantiator(valueInstantiator);
        this.addBeanProps(config2, beanDesc, builder);
        this.addReferenceProperties(config2, beanDesc, builder);
        this.addInjectables(config2, beanDesc, builder);
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                builder = mod.updateBuilder(config2, beanDesc, builder);
            }
        }
        JsonDeserializer<Object> deserializer = builder.build(property);
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                deserializer = mod.modifyDeserializer(config2, beanDesc, deserializer);
            }
        }
        return deserializer;
    }

    public JsonDeserializer<Object> buildThrowableDeserializer(DeserializationConfig config2, JavaType type, BasicBeanDescription beanDesc, BeanProperty property) throws JsonMappingException {
        JsonDeserializer deserializer;
        SettableBeanProperty prop;
        BeanDeserializerBuilder builder = this.constructBeanDeserializerBuilder(beanDesc);
        builder.setValueInstantiator(this.findValueInstantiator(config2, beanDesc));
        this.addBeanProps(config2, beanDesc, builder);
        AnnotatedMethod am = beanDesc.findMethod("initCause", INIT_CAUSE_PARAMS);
        if (am != null && (prop = this.constructSettableProperty(config2, beanDesc, "cause", am)) != null) {
            builder.addOrReplaceProperty(prop, true);
        }
        builder.addIgnorable("localizedMessage");
        builder.addIgnorable("message");
        builder.addIgnorable("suppressed");
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                builder = mod.updateBuilder(config2, beanDesc, builder);
            }
        }
        if ((deserializer = builder.build(property)) instanceof BeanDeserializer) {
            deserializer = new ThrowableDeserializer((BeanDeserializer)deserializer);
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                deserializer = mod.modifyDeserializer(config2, beanDesc, deserializer);
            }
        }
        return deserializer;
    }

    protected BeanDeserializerBuilder constructBeanDeserializerBuilder(BasicBeanDescription beanDesc) {
        return new BeanDeserializerBuilder(beanDesc);
    }

    protected ValueInstantiator constructDefaultValueInstantiator(DeserializationConfig config2, BasicBeanDescription beanDesc) throws JsonMappingException {
        AnnotatedConstructor defaultCtor;
        boolean fixAccess = config2.isEnabled(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS);
        CreatorCollector creators = new CreatorCollector(beanDesc, fixAccess);
        AnnotationIntrospector intr = config2.getAnnotationIntrospector();
        if (beanDesc.getType().isConcrete() && (defaultCtor = beanDesc.findDefaultConstructor()) != null) {
            if (fixAccess) {
                ClassUtil.checkAndFixAccess((Member)((Object)defaultCtor.getAnnotated()));
            }
            creators.setDefaultConstructor(defaultCtor);
        }
        VisibilityChecker<?> vchecker = config2.getDefaultVisibilityChecker();
        vchecker = config2.getAnnotationIntrospector().findAutoDetectVisibility(beanDesc.getClassInfo(), vchecker);
        this._addDeserializerFactoryMethods(config2, beanDesc, vchecker, intr, creators);
        this._addDeserializerConstructors(config2, beanDesc, vchecker, intr, creators);
        return creators.constructValueInstantiator(config2);
    }

    protected void _addDeserializerConstructors(DeserializationConfig config2, BasicBeanDescription beanDesc, VisibilityChecker<?> vchecker, AnnotationIntrospector intr, CreatorCollector creators) throws JsonMappingException {
        for (AnnotatedConstructor ctor : beanDesc.getConstructors()) {
            int argCount = ctor.getParameterCount();
            if (argCount < 1) continue;
            boolean isCreator = intr.hasCreatorAnnotation(ctor);
            boolean isVisible = vchecker.isCreatorVisible(ctor);
            if (argCount == 1) {
                this._handleSingleArgumentConstructor(config2, beanDesc, vchecker, intr, creators, ctor, isCreator, isVisible);
                continue;
            }
            if (!isCreator && !isVisible) continue;
            boolean annotationFound = false;
            AnnotatedParameter nonAnnotatedParam = null;
            int namedCount = 0;
            int injectCount = 0;
            CreatorProperty[] properties = new CreatorProperty[argCount];
            for (int i = 0; i < argCount; ++i) {
                AnnotatedParameter param2 = ctor.getParameter(i);
                String name2 = param2 == null ? null : intr.findPropertyNameForParam(param2);
                Object injectId = intr.findInjectableValueId(param2);
                if (name2 != null && name2.length() > 0) {
                    ++namedCount;
                    properties[i] = this.constructCreatorProperty(config2, beanDesc, name2, i, param2, injectId);
                    continue;
                }
                if (injectId != null) {
                    ++injectCount;
                    properties[i] = this.constructCreatorProperty(config2, beanDesc, name2, i, param2, injectId);
                    continue;
                }
                if (nonAnnotatedParam != null) continue;
                nonAnnotatedParam = param2;
            }
            if (isCreator || namedCount > 0 || injectCount > 0) {
                if (namedCount + injectCount == argCount) {
                    creators.addPropertyCreator(ctor, properties);
                } else {
                    if (namedCount == 0 && injectCount + 1 == argCount) {
                        throw new IllegalArgumentException("Delegated constructor with Injectables not yet supported (see [JACKSON-712]) for " + ctor);
                    }
                    throw new IllegalArgumentException("Argument #" + nonAnnotatedParam.getIndex() + " of constructor " + ctor + " has no property name annotation; must have name when multiple-paramater constructor annotated as Creator");
                }
            }
            if (!annotationFound) continue;
            creators.addPropertyCreator(ctor, properties);
        }
    }

    protected boolean _handleSingleArgumentConstructor(DeserializationConfig config2, BasicBeanDescription beanDesc, VisibilityChecker<?> vchecker, AnnotationIntrospector intr, CreatorCollector creators, AnnotatedConstructor ctor, boolean isCreator, boolean isVisible) throws JsonMappingException {
        AnnotatedParameter param2 = ctor.getParameter(0);
        String name2 = intr.findPropertyNameForParam(param2);
        Object injectId = intr.findInjectableValueId(param2);
        if (injectId != null || name2 != null && name2.length() > 0) {
            CreatorProperty[] properties = new CreatorProperty[]{this.constructCreatorProperty(config2, beanDesc, name2, 0, param2, injectId)};
            creators.addPropertyCreator(ctor, properties);
            return true;
        }
        Class<?> type = ctor.getParameterClass(0);
        if (type == String.class) {
            if (isCreator || isVisible) {
                creators.addStringCreator(ctor);
            }
            return true;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            if (isCreator || isVisible) {
                creators.addIntCreator(ctor);
            }
            return true;
        }
        if (type == Long.TYPE || type == Long.class) {
            if (isCreator || isVisible) {
                creators.addLongCreator(ctor);
            }
            return true;
        }
        if (type == Double.TYPE || type == Double.class) {
            if (isCreator || isVisible) {
                creators.addDoubleCreator(ctor);
            }
            return true;
        }
        if (isCreator) {
            creators.addDelegatingCreator(ctor);
            return true;
        }
        return false;
    }

    protected void _addDeserializerFactoryMethods(DeserializationConfig config2, BasicBeanDescription beanDesc, VisibilityChecker<?> vchecker, AnnotationIntrospector intr, CreatorCollector creators) throws JsonMappingException {
        for (AnnotatedMethod factory : beanDesc.getFactoryMethods()) {
            int argCount = factory.getParameterCount();
            if (argCount < 1) continue;
            boolean isCreator = intr.hasCreatorAnnotation(factory);
            if (argCount == 1) {
                AnnotatedParameter param2 = factory.getParameter(0);
                String name2 = intr.findPropertyNameForParam(param2);
                Object injectId = intr.findInjectableValueId(param2);
                if (injectId == null && (name2 == null || name2.length() == 0)) {
                    this._handleSingleArgumentFactory(config2, beanDesc, vchecker, intr, creators, factory, isCreator);
                    continue;
                }
            } else if (!intr.hasCreatorAnnotation(factory)) continue;
            CreatorProperty[] properties = new CreatorProperty[argCount];
            for (int i = 0; i < argCount; ++i) {
                AnnotatedParameter param3 = factory.getParameter(i);
                String name3 = intr.findPropertyNameForParam(param3);
                Object injectableId = intr.findInjectableValueId(param3);
                if ((name3 == null || name3.length() == 0) && injectableId == null) {
                    throw new IllegalArgumentException("Argument #" + i + " of factory method " + factory + " has no property name annotation; must have when multiple-paramater static method annotated as Creator");
                }
                properties[i] = this.constructCreatorProperty(config2, beanDesc, name3, i, param3, injectableId);
            }
            creators.addPropertyCreator(factory, properties);
        }
    }

    protected boolean _handleSingleArgumentFactory(DeserializationConfig config2, BasicBeanDescription beanDesc, VisibilityChecker<?> vchecker, AnnotationIntrospector intr, CreatorCollector creators, AnnotatedMethod factory, boolean isCreator) throws JsonMappingException {
        Class<?> type = factory.getParameterClass(0);
        if (type == String.class) {
            if (isCreator || vchecker.isCreatorVisible(factory)) {
                creators.addStringCreator(factory);
            }
            return true;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            if (isCreator || vchecker.isCreatorVisible(factory)) {
                creators.addIntCreator(factory);
            }
            return true;
        }
        if (type == Long.TYPE || type == Long.class) {
            if (isCreator || vchecker.isCreatorVisible(factory)) {
                creators.addLongCreator(factory);
            }
            return true;
        }
        if (type == Double.TYPE || type == Double.class) {
            if (isCreator || vchecker.isCreatorVisible(factory)) {
                creators.addDoubleCreator(factory);
            }
            return true;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            if (isCreator || vchecker.isCreatorVisible(factory)) {
                creators.addBooleanCreator(factory);
            }
            return true;
        }
        if (intr.hasCreatorAnnotation(factory)) {
            creators.addDelegatingCreator(factory);
            return true;
        }
        return false;
    }

    protected CreatorProperty constructCreatorProperty(DeserializationConfig config2, BasicBeanDescription beanDesc, String name2, int index2, AnnotatedParameter param2, Object injectableValueId) throws JsonMappingException {
        BeanProperty.Std property;
        JavaType t0 = config2.getTypeFactory().constructType(param2.getParameterType(), beanDesc.bindingsForBeanType());
        JavaType type = this.resolveType(config2, beanDesc, t0, param2, property = new BeanProperty.Std(name2, t0, beanDesc.getClassAnnotations(), param2));
        if (type != t0) {
            property = property.withType(type);
        }
        JsonDeserializer<Object> deser = this.findDeserializerFromAnnotation(config2, param2, property);
        TypeDeserializer typeDeser = (TypeDeserializer)(type = this.modifyTypeByAnnotation(config2, param2, type, name2)).getTypeHandler();
        if (typeDeser == null) {
            typeDeser = this.findTypeDeserializer(config2, type, property);
        }
        SettableBeanProperty prop = new CreatorProperty(name2, type, typeDeser, beanDesc.getClassAnnotations(), param2, index2, injectableValueId);
        if (deser != null) {
            prop = prop.withValueDeserializer((JsonDeserializer)deser);
        }
        return prop;
    }

    protected void addBeanProps(DeserializationConfig config2, BasicBeanDescription beanDesc, BeanDeserializerBuilder builder) throws JsonMappingException {
        String name2;
        Set<String> ignored2;
        List<BeanPropertyDefinition> props = beanDesc.findProperties();
        AnnotationIntrospector intr = config2.getAnnotationIntrospector();
        boolean ignoreAny = false;
        Boolean B = intr.findIgnoreUnknownProperties(beanDesc.getClassInfo());
        if (B != null) {
            ignoreAny = B;
            builder.setIgnoreUnknownProperties(ignoreAny);
        }
        HashSet<String> ignored = ArrayBuilders.arrayToSet(intr.findPropertiesToIgnore(beanDesc.getClassInfo()));
        for (String propName : ignored) {
            builder.addIgnorable(propName);
        }
        AnnotatedMethod anySetter = beanDesc.findAnySetter();
        Set<String> set2 = ignored2 = anySetter == null ? beanDesc.getIgnoredPropertyNames() : beanDesc.getIgnoredPropertyNamesForDeser();
        if (ignored2 != null) {
            for (String propName : ignored2) {
                builder.addIgnorable(propName);
            }
        }
        HashMap ignoredTypes = new HashMap();
        for (BeanPropertyDefinition property : props) {
            SettableBeanProperty prop;
            Class<?> type;
            name2 = property.getName();
            if (ignored.contains(name2)) continue;
            if (property.hasConstructorParameter()) {
                builder.addCreatorProperty(property);
                continue;
            }
            if (property.hasSetter()) {
                AnnotatedMethod setter2 = property.getSetter();
                type = setter2.getParameterClass(0);
                if (this.isIgnorableType(config2, beanDesc, type, ignoredTypes)) {
                    builder.addIgnorable(name2);
                    continue;
                }
                prop = this.constructSettableProperty(config2, beanDesc, name2, setter2);
                if (prop == null) continue;
                builder.addProperty(prop);
                continue;
            }
            if (!property.hasField()) continue;
            AnnotatedField field2 = property.getField();
            type = field2.getRawType();
            if (this.isIgnorableType(config2, beanDesc, type, ignoredTypes)) {
                builder.addIgnorable(name2);
                continue;
            }
            prop = this.constructSettableProperty(config2, beanDesc, name2, field2);
            if (prop == null) continue;
            builder.addProperty(prop);
        }
        if (anySetter != null) {
            builder.setAnySetter(this.constructAnySetter(config2, beanDesc, anySetter));
        }
        if (config2.isEnabled(DeserializationConfig.Feature.USE_GETTERS_AS_SETTERS)) {
            for (BeanPropertyDefinition property : props) {
                AnnotatedMethod getter2;
                Class<?> rt;
                if (!property.hasGetter() || builder.hasProperty(name2 = property.getName()) || ignored.contains(name2) || !Collection.class.isAssignableFrom(rt = (getter2 = property.getGetter()).getRawType()) && !Map.class.isAssignableFrom(rt) || ignored.contains(name2) || builder.hasProperty(name2)) continue;
                builder.addProperty(this.constructSetterlessProperty(config2, beanDesc, name2, getter2));
            }
        }
    }

    protected void addReferenceProperties(DeserializationConfig config2, BasicBeanDescription beanDesc, BeanDeserializerBuilder builder) throws JsonMappingException {
        Map<String, AnnotatedMember> refs = beanDesc.findBackReferenceProperties();
        if (refs != null) {
            for (Map.Entry<String, AnnotatedMember> en : refs.entrySet()) {
                String name2 = en.getKey();
                AnnotatedMember m = en.getValue();
                if (m instanceof AnnotatedMethod) {
                    builder.addBackReferenceProperty(name2, this.constructSettableProperty(config2, beanDesc, m.getName(), (AnnotatedMethod)m));
                    continue;
                }
                builder.addBackReferenceProperty(name2, this.constructSettableProperty(config2, beanDesc, m.getName(), (AnnotatedField)m));
            }
        }
    }

    protected void addInjectables(DeserializationConfig config2, BasicBeanDescription beanDesc, BeanDeserializerBuilder builder) throws JsonMappingException {
        Map<Object, AnnotatedMember> raw2 = beanDesc.findInjectables();
        if (raw2 != null) {
            boolean fixAccess = config2.isEnabled(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS);
            for (Map.Entry<Object, AnnotatedMember> entry2 : raw2.entrySet()) {
                AnnotatedMember m = entry2.getValue();
                if (fixAccess) {
                    m.fixAccess();
                }
                builder.addInjectable(m.getName(), beanDesc.resolveType(m.getGenericType()), beanDesc.getClassAnnotations(), m, entry2.getKey());
            }
        }
    }

    protected SettableAnyProperty constructAnySetter(DeserializationConfig config2, BasicBeanDescription beanDesc, AnnotatedMethod setter2) throws JsonMappingException {
        if (config2.isEnabled(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS)) {
            setter2.fixAccess();
        }
        JavaType type = beanDesc.bindingsForBeanType().resolveType(setter2.getParameterType(1));
        BeanProperty.Std property = new BeanProperty.Std(setter2.getName(), type, beanDesc.getClassAnnotations(), setter2);
        type = this.resolveType(config2, beanDesc, type, setter2, property);
        JsonDeserializer<Object> deser = this.findDeserializerFromAnnotation(config2, setter2, property);
        if (deser != null) {
            return new SettableAnyProperty((BeanProperty)property, setter2, type, deser);
        }
        type = this.modifyTypeByAnnotation(config2, setter2, type, property.getName());
        return new SettableAnyProperty((BeanProperty)property, setter2, type, null);
    }

    protected SettableBeanProperty constructSettableProperty(DeserializationConfig config2, BasicBeanDescription beanDesc, String name2, AnnotatedMethod setter2) throws JsonMappingException {
        AnnotationIntrospector.ReferenceProperty ref;
        BeanProperty.Std property;
        JavaType t0;
        JavaType type;
        if (config2.isEnabled(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS)) {
            setter2.fixAccess();
        }
        if ((type = this.resolveType(config2, beanDesc, t0 = beanDesc.bindingsForBeanType().resolveType(setter2.getParameterType(0)), setter2, property = new BeanProperty.Std(name2, t0, beanDesc.getClassAnnotations(), setter2))) != t0) {
            property = property.withType(type);
        }
        JsonDeserializer<Object> propDeser = this.findDeserializerFromAnnotation(config2, setter2, property);
        type = this.modifyTypeByAnnotation(config2, setter2, type, name2);
        TypeDeserializer typeDeser = (TypeDeserializer)type.getTypeHandler();
        SettableBeanProperty prop = new SettableBeanProperty.MethodProperty(name2, type, typeDeser, beanDesc.getClassAnnotations(), setter2);
        if (propDeser != null) {
            prop = prop.withValueDeserializer(propDeser);
        }
        if ((ref = config2.getAnnotationIntrospector().findReferenceType(setter2)) != null && ref.isManagedReference()) {
            prop.setManagedReferenceName(ref.getName());
        }
        return prop;
    }

    protected SettableBeanProperty constructSettableProperty(DeserializationConfig config2, BasicBeanDescription beanDesc, String name2, AnnotatedField field2) throws JsonMappingException {
        AnnotationIntrospector.ReferenceProperty ref;
        BeanProperty.Std property;
        JavaType t0;
        JavaType type;
        if (config2.isEnabled(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS)) {
            field2.fixAccess();
        }
        if ((type = this.resolveType(config2, beanDesc, t0 = beanDesc.bindingsForBeanType().resolveType(field2.getGenericType()), field2, property = new BeanProperty.Std(name2, t0, beanDesc.getClassAnnotations(), field2))) != t0) {
            property = property.withType(type);
        }
        JsonDeserializer<Object> propDeser = this.findDeserializerFromAnnotation(config2, field2, property);
        type = this.modifyTypeByAnnotation(config2, field2, type, name2);
        TypeDeserializer typeDeser = (TypeDeserializer)type.getTypeHandler();
        SettableBeanProperty prop = new SettableBeanProperty.FieldProperty(name2, type, typeDeser, beanDesc.getClassAnnotations(), field2);
        if (propDeser != null) {
            prop = prop.withValueDeserializer(propDeser);
        }
        if ((ref = config2.getAnnotationIntrospector().findReferenceType(field2)) != null && ref.isManagedReference()) {
            prop.setManagedReferenceName(ref.getName());
        }
        return prop;
    }

    protected SettableBeanProperty constructSetterlessProperty(DeserializationConfig config2, BasicBeanDescription beanDesc, String name2, AnnotatedMethod getter2) throws JsonMappingException {
        if (config2.isEnabled(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS)) {
            getter2.fixAccess();
        }
        JavaType type = getter2.getType(beanDesc.bindingsForBeanType());
        BeanProperty.Std property = new BeanProperty.Std(name2, type, beanDesc.getClassAnnotations(), getter2);
        JsonDeserializer<Object> propDeser = this.findDeserializerFromAnnotation(config2, getter2, property);
        type = this.modifyTypeByAnnotation(config2, getter2, type, name2);
        TypeDeserializer typeDeser = (TypeDeserializer)type.getTypeHandler();
        SettableBeanProperty prop = new SettableBeanProperty.SetterlessProperty(name2, type, typeDeser, beanDesc.getClassAnnotations(), getter2);
        if (propDeser != null) {
            prop = ((SettableBeanProperty)prop).withValueDeserializer(propDeser);
        }
        return prop;
    }

    protected boolean isPotentialBeanType(Class<?> type) {
        String typeStr = ClassUtil.canBeABeanType(type);
        if (typeStr != null) {
            throw new IllegalArgumentException("Can not deserialize Class " + type.getName() + " (of type " + typeStr + ") as a Bean");
        }
        if (ClassUtil.isProxyType(type)) {
            throw new IllegalArgumentException("Can not deserialize Proxy class " + type.getName() + " as a Bean");
        }
        typeStr = ClassUtil.isLocalType(type, true);
        if (typeStr != null) {
            throw new IllegalArgumentException("Can not deserialize Class " + type.getName() + " (of type " + typeStr + ") as a Bean");
        }
        return true;
    }

    protected boolean isIgnorableType(DeserializationConfig config2, BasicBeanDescription beanDesc, Class<?> type, Map<Class<?>, Boolean> ignoredTypes) {
        Boolean status = ignoredTypes.get(type);
        if (status == null) {
            BasicBeanDescription desc = (BasicBeanDescription)config2.introspectClassAnnotations(type);
            status = config2.getAnnotationIntrospector().isIgnorableType(desc.getClassInfo());
            if (status == null) {
                status = Boolean.FALSE;
            }
        }
        return status;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConfigImpl
    extends DeserializerFactory.Config {
        protected static final KeyDeserializers[] NO_KEY_DESERIALIZERS = new KeyDeserializers[0];
        protected static final BeanDeserializerModifier[] NO_MODIFIERS = new BeanDeserializerModifier[0];
        protected static final AbstractTypeResolver[] NO_ABSTRACT_TYPE_RESOLVERS = new AbstractTypeResolver[0];
        protected static final ValueInstantiators[] NO_VALUE_INSTANTIATORS = new ValueInstantiators[0];
        protected final Deserializers[] _additionalDeserializers;
        protected final KeyDeserializers[] _additionalKeyDeserializers;
        protected final BeanDeserializerModifier[] _modifiers;
        protected final AbstractTypeResolver[] _abstractTypeResolvers;
        protected final ValueInstantiators[] _valueInstantiators;

        public ConfigImpl() {
            this(null, null, null, null, null);
        }

        protected ConfigImpl(Deserializers[] allAdditionalDeserializers, KeyDeserializers[] allAdditionalKeyDeserializers, BeanDeserializerModifier[] modifiers, AbstractTypeResolver[] atr, ValueInstantiators[] vi) {
            this._additionalDeserializers = allAdditionalDeserializers == null ? NO_DESERIALIZERS : allAdditionalDeserializers;
            this._additionalKeyDeserializers = allAdditionalKeyDeserializers == null ? NO_KEY_DESERIALIZERS : allAdditionalKeyDeserializers;
            this._modifiers = modifiers == null ? NO_MODIFIERS : modifiers;
            this._abstractTypeResolvers = atr == null ? NO_ABSTRACT_TYPE_RESOLVERS : atr;
            this._valueInstantiators = vi == null ? NO_VALUE_INSTANTIATORS : vi;
        }

        @Override
        public DeserializerFactory.Config withAdditionalDeserializers(Deserializers additional) {
            if (additional == null) {
                throw new IllegalArgumentException("Can not pass null Deserializers");
            }
            Deserializers[] all = ArrayBuilders.insertInListNoDup(this._additionalDeserializers, additional);
            return new ConfigImpl(all, this._additionalKeyDeserializers, this._modifiers, this._abstractTypeResolvers, this._valueInstantiators);
        }

        @Override
        public DeserializerFactory.Config withAdditionalKeyDeserializers(KeyDeserializers additional) {
            if (additional == null) {
                throw new IllegalArgumentException("Can not pass null KeyDeserializers");
            }
            KeyDeserializers[] all = ArrayBuilders.insertInListNoDup(this._additionalKeyDeserializers, additional);
            return new ConfigImpl(this._additionalDeserializers, all, this._modifiers, this._abstractTypeResolvers, this._valueInstantiators);
        }

        @Override
        public DeserializerFactory.Config withDeserializerModifier(BeanDeserializerModifier modifier) {
            if (modifier == null) {
                throw new IllegalArgumentException("Can not pass null modifier");
            }
            BeanDeserializerModifier[] all = ArrayBuilders.insertInListNoDup(this._modifiers, modifier);
            return new ConfigImpl(this._additionalDeserializers, this._additionalKeyDeserializers, all, this._abstractTypeResolvers, this._valueInstantiators);
        }

        @Override
        public DeserializerFactory.Config withAbstractTypeResolver(AbstractTypeResolver resolver) {
            if (resolver == null) {
                throw new IllegalArgumentException("Can not pass null resolver");
            }
            AbstractTypeResolver[] all = ArrayBuilders.insertInListNoDup(this._abstractTypeResolvers, resolver);
            return new ConfigImpl(this._additionalDeserializers, this._additionalKeyDeserializers, this._modifiers, all, this._valueInstantiators);
        }

        @Override
        public DeserializerFactory.Config withValueInstantiators(ValueInstantiators instantiators) {
            if (instantiators == null) {
                throw new IllegalArgumentException("Can not pass null resolver");
            }
            ValueInstantiators[] all = ArrayBuilders.insertInListNoDup(this._valueInstantiators, instantiators);
            return new ConfigImpl(this._additionalDeserializers, this._additionalKeyDeserializers, this._modifiers, this._abstractTypeResolvers, all);
        }

        @Override
        public boolean hasDeserializers() {
            return this._additionalDeserializers.length > 0;
        }

        @Override
        public boolean hasKeyDeserializers() {
            return this._additionalKeyDeserializers.length > 0;
        }

        @Override
        public boolean hasDeserializerModifiers() {
            return this._modifiers.length > 0;
        }

        @Override
        public boolean hasAbstractTypeResolvers() {
            return this._abstractTypeResolvers.length > 0;
        }

        @Override
        public boolean hasValueInstantiators() {
            return this._valueInstantiators.length > 0;
        }

        @Override
        public Iterable<Deserializers> deserializers() {
            return ArrayBuilders.arrayAsIterable(this._additionalDeserializers);
        }

        @Override
        public Iterable<KeyDeserializers> keyDeserializers() {
            return ArrayBuilders.arrayAsIterable(this._additionalKeyDeserializers);
        }

        @Override
        public Iterable<BeanDeserializerModifier> deserializerModifiers() {
            return ArrayBuilders.arrayAsIterable(this._modifiers);
        }

        @Override
        public Iterable<AbstractTypeResolver> abstractTypeResolvers() {
            return ArrayBuilders.arrayAsIterable(this._abstractTypeResolvers);
        }

        @Override
        public Iterable<ValueInstantiators> valueInstantiators() {
            return ArrayBuilders.arrayAsIterable(this._valueInstantiators);
        }
    }
}

