/*
 * Decompiled with CFR 0.152.
 */
package shaded.parquet.org.codehaus.jackson.io;

public final class NumberOutput {
    private static final char NULL_CHAR = '\u0000';
    private static int MILLION = 1000000;
    private static int BILLION = 1000000000;
    private static long TEN_BILLION_L = 10000000000L;
    private static long THOUSAND_L = 1000L;
    private static long MIN_INT_AS_LONG = Integer.MIN_VALUE;
    private static long MAX_INT_AS_LONG = Integer.MAX_VALUE;
    static final String SMALLEST_LONG = String.valueOf(Long.MIN_VALUE);
    static final char[] LEADING_TRIPLETS = new char[4000];
    static final char[] FULL_TRIPLETS = new char[4000];
    static final byte[] FULL_TRIPLETS_B;
    static final String[] sSmallIntStrs;
    static final String[] sSmallIntStrs2;

    public static int outputInt(int value2, char[] buffer2, int offset) {
        boolean hasBillions;
        if (value2 < 0) {
            if (value2 == Integer.MIN_VALUE) {
                return NumberOutput.outputLong((long)value2, buffer2, offset);
            }
            buffer2[offset++] = 45;
            value2 = -value2;
        }
        if (value2 < MILLION) {
            if (value2 < 1000) {
                if (value2 < 10) {
                    buffer2[offset++] = (char)(48 + value2);
                } else {
                    offset = NumberOutput.outputLeadingTriplet(value2, buffer2, offset);
                }
            } else {
                int thousands = value2 / 1000;
                offset = NumberOutput.outputLeadingTriplet(thousands, buffer2, offset);
                offset = NumberOutput.outputFullTriplet(value2 -= thousands * 1000, buffer2, offset);
            }
            return offset;
        }
        boolean bl = hasBillions = value2 >= BILLION;
        if (hasBillions) {
            if ((value2 -= BILLION) >= BILLION) {
                value2 -= BILLION;
                buffer2[offset++] = 50;
            } else {
                buffer2[offset++] = 49;
            }
        }
        int newValue = value2 / 1000;
        int ones = value2 - newValue * 1000;
        value2 = newValue;
        int thousands = value2 - (newValue /= 1000) * 1000;
        offset = hasBillions ? NumberOutput.outputFullTriplet(newValue, buffer2, offset) : NumberOutput.outputLeadingTriplet(newValue, buffer2, offset);
        offset = NumberOutput.outputFullTriplet(thousands, buffer2, offset);
        offset = NumberOutput.outputFullTriplet(ones, buffer2, offset);
        return offset;
    }

    public static int outputInt(int value2, byte[] buffer2, int offset) {
        boolean hasBillions;
        if (value2 < 0) {
            if (value2 == Integer.MIN_VALUE) {
                return NumberOutput.outputLong((long)value2, buffer2, offset);
            }
            buffer2[offset++] = 45;
            value2 = -value2;
        }
        if (value2 < MILLION) {
            if (value2 < 1000) {
                if (value2 < 10) {
                    buffer2[offset++] = (byte)(48 + value2);
                } else {
                    offset = NumberOutput.outputLeadingTriplet(value2, buffer2, offset);
                }
            } else {
                int thousands = value2 / 1000;
                offset = NumberOutput.outputLeadingTriplet(thousands, buffer2, offset);
                offset = NumberOutput.outputFullTriplet(value2 -= thousands * 1000, buffer2, offset);
            }
            return offset;
        }
        boolean bl = hasBillions = value2 >= BILLION;
        if (hasBillions) {
            if ((value2 -= BILLION) >= BILLION) {
                value2 -= BILLION;
                buffer2[offset++] = 50;
            } else {
                buffer2[offset++] = 49;
            }
        }
        int newValue = value2 / 1000;
        int ones = value2 - newValue * 1000;
        value2 = newValue;
        int thousands = value2 - (newValue /= 1000) * 1000;
        offset = hasBillions ? NumberOutput.outputFullTriplet(newValue, buffer2, offset) : NumberOutput.outputLeadingTriplet(newValue, buffer2, offset);
        offset = NumberOutput.outputFullTriplet(thousands, buffer2, offset);
        offset = NumberOutput.outputFullTriplet(ones, buffer2, offset);
        return offset;
    }

    public static int outputLong(long value2, char[] buffer2, int offset) {
        int triplet;
        if (value2 < 0L) {
            if (value2 > MIN_INT_AS_LONG) {
                return NumberOutput.outputInt((int)value2, buffer2, offset);
            }
            if (value2 == Long.MIN_VALUE) {
                int len = SMALLEST_LONG.length();
                SMALLEST_LONG.getChars(0, len, buffer2, offset);
                return offset + len;
            }
            buffer2[offset++] = 45;
            value2 = -value2;
        } else if (value2 <= MAX_INT_AS_LONG) {
            return NumberOutput.outputInt((int)value2, buffer2, offset);
        }
        int origOffset = offset;
        int ptr = offset += NumberOutput.calcLongStrLength(value2);
        while (value2 > MAX_INT_AS_LONG) {
            long newValue = value2 / THOUSAND_L;
            triplet = (int)(value2 - newValue * THOUSAND_L);
            NumberOutput.outputFullTriplet(triplet, buffer2, ptr -= 3);
            value2 = newValue;
        }
        int ivalue = (int)value2;
        while (ivalue >= 1000) {
            int newValue = ivalue / 1000;
            triplet = ivalue - newValue * 1000;
            NumberOutput.outputFullTriplet(triplet, buffer2, ptr -= 3);
            ivalue = newValue;
        }
        NumberOutput.outputLeadingTriplet(ivalue, buffer2, origOffset);
        return offset;
    }

    public static int outputLong(long value2, byte[] buffer2, int offset) {
        int triplet;
        if (value2 < 0L) {
            if (value2 > MIN_INT_AS_LONG) {
                return NumberOutput.outputInt((int)value2, buffer2, offset);
            }
            if (value2 == Long.MIN_VALUE) {
                int len = SMALLEST_LONG.length();
                for (int i = 0; i < len; ++i) {
                    buffer2[offset++] = (byte)SMALLEST_LONG.charAt(i);
                }
                return offset;
            }
            buffer2[offset++] = 45;
            value2 = -value2;
        } else if (value2 <= MAX_INT_AS_LONG) {
            return NumberOutput.outputInt((int)value2, buffer2, offset);
        }
        int origOffset = offset;
        int ptr = offset += NumberOutput.calcLongStrLength(value2);
        while (value2 > MAX_INT_AS_LONG) {
            long newValue = value2 / THOUSAND_L;
            triplet = (int)(value2 - newValue * THOUSAND_L);
            NumberOutput.outputFullTriplet(triplet, buffer2, ptr -= 3);
            value2 = newValue;
        }
        int ivalue = (int)value2;
        while (ivalue >= 1000) {
            int newValue = ivalue / 1000;
            triplet = ivalue - newValue * 1000;
            NumberOutput.outputFullTriplet(triplet, buffer2, ptr -= 3);
            ivalue = newValue;
        }
        NumberOutput.outputLeadingTriplet(ivalue, buffer2, origOffset);
        return offset;
    }

    public static String toString(int value2) {
        if (value2 < sSmallIntStrs.length) {
            if (value2 >= 0) {
                return sSmallIntStrs[value2];
            }
            int v2 = -value2 - 1;
            if (v2 < sSmallIntStrs2.length) {
                return sSmallIntStrs2[v2];
            }
        }
        return Integer.toString(value2);
    }

    public static String toString(long value2) {
        if (value2 <= Integer.MAX_VALUE && value2 >= Integer.MIN_VALUE) {
            return NumberOutput.toString((int)value2);
        }
        return Long.toString(value2);
    }

    public static String toString(double value2) {
        return Double.toString(value2);
    }

    private static int outputLeadingTriplet(int triplet, char[] buffer2, int offset) {
        char c;
        int digitOffset = triplet << 2;
        if ((c = LEADING_TRIPLETS[digitOffset++]) != '\u0000') {
            buffer2[offset++] = c;
        }
        if ((c = LEADING_TRIPLETS[digitOffset++]) != '\u0000') {
            buffer2[offset++] = c;
        }
        buffer2[offset++] = LEADING_TRIPLETS[digitOffset];
        return offset;
    }

    private static int outputLeadingTriplet(int triplet, byte[] buffer2, int offset) {
        char c;
        int digitOffset = triplet << 2;
        if ((c = LEADING_TRIPLETS[digitOffset++]) != '\u0000') {
            buffer2[offset++] = (byte)c;
        }
        if ((c = LEADING_TRIPLETS[digitOffset++]) != '\u0000') {
            buffer2[offset++] = (byte)c;
        }
        buffer2[offset++] = (byte)LEADING_TRIPLETS[digitOffset];
        return offset;
    }

    private static int outputFullTriplet(int triplet, char[] buffer2, int offset) {
        int digitOffset = triplet << 2;
        buffer2[offset++] = FULL_TRIPLETS[digitOffset++];
        buffer2[offset++] = FULL_TRIPLETS[digitOffset++];
        buffer2[offset++] = FULL_TRIPLETS[digitOffset];
        return offset;
    }

    private static int outputFullTriplet(int triplet, byte[] buffer2, int offset) {
        int digitOffset = triplet << 2;
        buffer2[offset++] = FULL_TRIPLETS_B[digitOffset++];
        buffer2[offset++] = FULL_TRIPLETS_B[digitOffset++];
        buffer2[offset++] = FULL_TRIPLETS_B[digitOffset];
        return offset;
    }

    private static int calcLongStrLength(long posValue) {
        int len;
        long comp = TEN_BILLION_L;
        for (len = 10; posValue >= comp && len != 19; ++len) {
            comp = (comp << 3) + (comp << 1);
        }
        return len;
    }

    static {
        int ix = 0;
        for (int i1 = 0; i1 < 10; ++i1) {
            char f1 = (char)(48 + i1);
            char l1 = i1 == 0 ? (char)'\u0000' : f1;
            for (int i2 = 0; i2 < 10; ++i2) {
                char f2 = (char)(48 + i2);
                char l2 = i1 == 0 && i2 == 0 ? (char)'\u0000' : f2;
                for (int i3 = 0; i3 < 10; ++i3) {
                    char f3 = (char)(48 + i3);
                    NumberOutput.LEADING_TRIPLETS[ix] = l1;
                    NumberOutput.LEADING_TRIPLETS[ix + 1] = l2;
                    NumberOutput.LEADING_TRIPLETS[ix + 2] = f3;
                    NumberOutput.FULL_TRIPLETS[ix] = f1;
                    NumberOutput.FULL_TRIPLETS[ix + 1] = f2;
                    NumberOutput.FULL_TRIPLETS[ix + 2] = f3;
                    ix += 4;
                }
            }
        }
        FULL_TRIPLETS_B = new byte[4000];
        for (int i = 0; i < 4000; ++i) {
            NumberOutput.FULL_TRIPLETS_B[i] = (byte)FULL_TRIPLETS[i];
        }
        sSmallIntStrs = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
        sSmallIntStrs2 = new String[]{"-1", "-2", "-3", "-4", "-5", "-6", "-7", "-8", "-9", "-10"};
    }
}

