/*
 * Decompiled with CFR 0.152.
 */
package shaded.parquet.org.codehaus.jackson;

import java.io.Closeable;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import shaded.parquet.org.codehaus.jackson.Base64Variant;
import shaded.parquet.org.codehaus.jackson.Base64Variants;
import shaded.parquet.org.codehaus.jackson.FormatSchema;
import shaded.parquet.org.codehaus.jackson.JsonGenerationException;
import shaded.parquet.org.codehaus.jackson.JsonNode;
import shaded.parquet.org.codehaus.jackson.JsonParser;
import shaded.parquet.org.codehaus.jackson.JsonProcessingException;
import shaded.parquet.org.codehaus.jackson.JsonStreamContext;
import shaded.parquet.org.codehaus.jackson.ObjectCodec;
import shaded.parquet.org.codehaus.jackson.PrettyPrinter;
import shaded.parquet.org.codehaus.jackson.SerializableString;
import shaded.parquet.org.codehaus.jackson.Version;
import shaded.parquet.org.codehaus.jackson.Versioned;
import shaded.parquet.org.codehaus.jackson.io.CharacterEscapes;
import shaded.parquet.org.codehaus.jackson.io.SerializedString;

public abstract class JsonGenerator
implements Closeable,
Versioned {
    protected PrettyPrinter _cfgPrettyPrinter;

    protected JsonGenerator() {
    }

    public void setSchema(FormatSchema schema) {
        throw new UnsupportedOperationException("Generator of type " + this.getClass().getName() + " does not support schema of type '" + schema.getSchemaType() + "'");
    }

    public boolean canUseSchema(FormatSchema schema) {
        return false;
    }

    public Version version() {
        return Version.unknownVersion();
    }

    public Object getOutputTarget() {
        return null;
    }

    public abstract JsonGenerator enable(Feature var1);

    public abstract JsonGenerator disable(Feature var1);

    public JsonGenerator configure(Feature f2, boolean state) {
        if (state) {
            this.enable(f2);
        } else {
            this.disable(f2);
        }
        return this;
    }

    public abstract boolean isEnabled(Feature var1);

    public abstract JsonGenerator setCodec(ObjectCodec var1);

    public abstract ObjectCodec getCodec();

    @Deprecated
    public void enableFeature(Feature f2) {
        this.enable(f2);
    }

    @Deprecated
    public void disableFeature(Feature f2) {
        this.disable(f2);
    }

    @Deprecated
    public void setFeature(Feature f2, boolean state) {
        this.configure(f2, state);
    }

    @Deprecated
    public boolean isFeatureEnabled(Feature f2) {
        return this.isEnabled(f2);
    }

    public JsonGenerator setPrettyPrinter(PrettyPrinter pp2) {
        this._cfgPrettyPrinter = pp2;
        return this;
    }

    public abstract JsonGenerator useDefaultPrettyPrinter();

    public JsonGenerator setHighestNonEscapedChar(int charCode) {
        return this;
    }

    public int getHighestEscapedChar() {
        return 0;
    }

    public CharacterEscapes getCharacterEscapes() {
        return null;
    }

    public JsonGenerator setCharacterEscapes(CharacterEscapes esc) {
        return this;
    }

    public abstract void writeStartArray() throws IOException, JsonGenerationException;

    public abstract void writeEndArray() throws IOException, JsonGenerationException;

    public abstract void writeStartObject() throws IOException, JsonGenerationException;

    public abstract void writeEndObject() throws IOException, JsonGenerationException;

    public abstract void writeFieldName(String var1) throws IOException, JsonGenerationException;

    public void writeFieldName(SerializedString name2) throws IOException, JsonGenerationException {
        this.writeFieldName(name2.getValue());
    }

    public void writeFieldName(SerializableString name2) throws IOException, JsonGenerationException {
        this.writeFieldName(name2.getValue());
    }

    public abstract void writeString(String var1) throws IOException, JsonGenerationException;

    public abstract void writeString(char[] var1, int var2, int var3) throws IOException, JsonGenerationException;

    public void writeString(SerializableString text2) throws IOException, JsonGenerationException {
        this.writeString(text2.getValue());
    }

    public abstract void writeRawUTF8String(byte[] var1, int var2, int var3) throws IOException, JsonGenerationException;

    public abstract void writeUTF8String(byte[] var1, int var2, int var3) throws IOException, JsonGenerationException;

    public abstract void writeRaw(String var1) throws IOException, JsonGenerationException;

    public abstract void writeRaw(String var1, int var2, int var3) throws IOException, JsonGenerationException;

    public abstract void writeRaw(char[] var1, int var2, int var3) throws IOException, JsonGenerationException;

    public abstract void writeRaw(char var1) throws IOException, JsonGenerationException;

    public abstract void writeRawValue(String var1) throws IOException, JsonGenerationException;

    public abstract void writeRawValue(String var1, int var2, int var3) throws IOException, JsonGenerationException;

    public abstract void writeRawValue(char[] var1, int var2, int var3) throws IOException, JsonGenerationException;

    public abstract void writeBinary(Base64Variant var1, byte[] var2, int var3, int var4) throws IOException, JsonGenerationException;

    public void writeBinary(byte[] data2, int offset, int len) throws IOException, JsonGenerationException {
        this.writeBinary(Base64Variants.getDefaultVariant(), data2, offset, len);
    }

    public void writeBinary(byte[] data2) throws IOException, JsonGenerationException {
        this.writeBinary(Base64Variants.getDefaultVariant(), data2, 0, data2.length);
    }

    public abstract void writeNumber(int var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(long var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(BigInteger var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(double var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(float var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(BigDecimal var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(String var1) throws IOException, JsonGenerationException, UnsupportedOperationException;

    public abstract void writeBoolean(boolean var1) throws IOException, JsonGenerationException;

    public abstract void writeNull() throws IOException, JsonGenerationException;

    public abstract void writeObject(Object var1) throws IOException, JsonProcessingException;

    public abstract void writeTree(JsonNode var1) throws IOException, JsonProcessingException;

    public void writeStringField(String fieldName, String value2) throws IOException, JsonGenerationException {
        this.writeFieldName(fieldName);
        this.writeString(value2);
    }

    public final void writeBooleanField(String fieldName, boolean value2) throws IOException, JsonGenerationException {
        this.writeFieldName(fieldName);
        this.writeBoolean(value2);
    }

    public final void writeNullField(String fieldName) throws IOException, JsonGenerationException {
        this.writeFieldName(fieldName);
        this.writeNull();
    }

    public final void writeNumberField(String fieldName, int value2) throws IOException, JsonGenerationException {
        this.writeFieldName(fieldName);
        this.writeNumber(value2);
    }

    public final void writeNumberField(String fieldName, long value2) throws IOException, JsonGenerationException {
        this.writeFieldName(fieldName);
        this.writeNumber(value2);
    }

    public final void writeNumberField(String fieldName, double value2) throws IOException, JsonGenerationException {
        this.writeFieldName(fieldName);
        this.writeNumber(value2);
    }

    public final void writeNumberField(String fieldName, float value2) throws IOException, JsonGenerationException {
        this.writeFieldName(fieldName);
        this.writeNumber(value2);
    }

    public final void writeNumberField(String fieldName, BigDecimal value2) throws IOException, JsonGenerationException {
        this.writeFieldName(fieldName);
        this.writeNumber(value2);
    }

    public final void writeBinaryField(String fieldName, byte[] data2) throws IOException, JsonGenerationException {
        this.writeFieldName(fieldName);
        this.writeBinary(data2);
    }

    public final void writeArrayFieldStart(String fieldName) throws IOException, JsonGenerationException {
        this.writeFieldName(fieldName);
        this.writeStartArray();
    }

    public final void writeObjectFieldStart(String fieldName) throws IOException, JsonGenerationException {
        this.writeFieldName(fieldName);
        this.writeStartObject();
    }

    public final void writeObjectField(String fieldName, Object pojo) throws IOException, JsonProcessingException {
        this.writeFieldName(fieldName);
        this.writeObject(pojo);
    }

    public abstract void copyCurrentEvent(JsonParser var1) throws IOException, JsonProcessingException;

    public abstract void copyCurrentStructure(JsonParser var1) throws IOException, JsonProcessingException;

    public abstract JsonStreamContext getOutputContext();

    public abstract void flush() throws IOException;

    public abstract boolean isClosed();

    public abstract void close() throws IOException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Feature {
        AUTO_CLOSE_TARGET(true),
        AUTO_CLOSE_JSON_CONTENT(true),
        QUOTE_FIELD_NAMES(true),
        QUOTE_NON_NUMERIC_NUMBERS(true),
        WRITE_NUMBERS_AS_STRINGS(false),
        FLUSH_PASSED_TO_STREAM(true),
        ESCAPE_NON_ASCII(false);

        final boolean _defaultState;
        final int _mask;

        public static int collectDefaults() {
            int flags2 = 0;
            for (Feature f2 : Feature.values()) {
                if (!f2.enabledByDefault()) continue;
                flags2 |= f2.getMask();
            }
            return flags2;
        }

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
            this._mask = 1 << this.ordinal();
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return this._mask;
        }
    }
}

