/*
 * Decompiled with CFR 0.152.
 */
package riffle.process.scheduler;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.ListIterator;
import riffle.process.scheduler.ProcessException;
import riffle.process.scheduler.ProcessWrapper;

public class ProcessChain {
    private ProcessWrapper[] processes;
    private Thread thread;
    private ProcessRunner processRunner;

    public ProcessChain(boolean topologicallyOrder, Object ... objects) {
        this.processes = new ProcessWrapper[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            this.processes[i] = new ProcessWrapper(objects[i]);
        }
        if (topologicallyOrder) {
            try {
                this.processes = ProcessChain.topologicallyOrder(this.processes);
            }
            catch (ProcessException exception) {
                throw new IllegalStateException("unable to sort processes", exception.getCause());
            }
        }
    }

    public void start() {
        this.processRunner = new ProcessRunner();
        this.thread = new Thread(this.processRunner);
        this.thread.start();
    }

    public void complete() {
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void stop() {
        if (this.processRunner != null) {
            this.processRunner.stop();
        }
    }

    private static ProcessWrapper[] topologicallyOrder(ProcessWrapper[] processes) throws ProcessException {
        while (!ProcessChain.isTopologicallyOrdered(processes)) {
            LinkedList<ProcessWrapper> sorted2 = new LinkedList<ProcessWrapper>();
            sorted2.add(processes[0]);
            for (int i = 1; i < processes.length; ++i) {
                ProcessWrapper process2 = processes[i];
                ListIterator<ProcessWrapper> iterator2 = sorted2.listIterator();
                boolean inserted = false;
                while (iterator2.hasNext()) {
                    ProcessWrapper current = (ProcessWrapper)iterator2.next();
                    if (ProcessChain.equalsOrContains(process2.getDependencyIncoming(), current.getDependencyIncoming())) {
                        iterator2.add(process2);
                        inserted = true;
                        break;
                    }
                    if (ProcessChain.equalsOrContains(process2.getDependencyIncoming(), current.getDependencyOutgoing())) {
                        iterator2.add(process2);
                        inserted = true;
                        break;
                    }
                    if (!ProcessChain.equalsOrContains(current.getDependencyIncoming(), process2.getDependencyOutgoing())) continue;
                    iterator2.remove();
                    iterator2.add(process2);
                    iterator2.add(current);
                    inserted = true;
                    break;
                }
                if (inserted) continue;
                sorted2.add(0, process2);
            }
            processes = sorted2.toArray(new ProcessWrapper[sorted2.size()]);
        }
        return processes;
    }

    private static boolean equalsOrContains(Object lhs, Object rhs) {
        if (!(lhs instanceof Collection) && !(rhs instanceof Collection)) {
            return lhs.equals(rhs);
        }
        if (lhs instanceof Collection && !(rhs instanceof Collection)) {
            return ((Collection)lhs).contains(rhs);
        }
        if (!(lhs instanceof Collection) && rhs instanceof Collection) {
            return ((Collection)rhs).contains(lhs);
        }
        return !Collections.disjoint((Collection)lhs, (Collection)rhs);
    }

    private static boolean isTopologicallyOrdered(ProcessWrapper[] processes) throws ProcessException {
        for (int i = 0; i < processes.length; ++i) {
            ProcessWrapper lhs = processes[i];
            for (int j = i; j < processes.length; ++j) {
                ProcessWrapper rhs = processes[j];
                if (!ProcessChain.equalsOrContains(lhs.getDependencyIncoming(), rhs.getDependencyOutgoing())) continue;
                return false;
            }
        }
        return true;
    }

    private class ProcessRunner
    implements Runnable {
        private boolean stop;
        private int runningIndex = 0;

        private ProcessRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int i;
            try {
                for (i = 0; i < ProcessChain.this.processes.length; ++i) {
                    ProcessChain.this.processes[i].prepare();
                }
                this.runningIndex = 0;
                while (this.runningIndex < ProcessChain.this.processes.length) {
                    if (!this.stop) {
                        ProcessChain.this.processes[this.runningIndex].complete();
                    }
                    ++this.runningIndex;
                }
            }
            catch (ProcessException exception) {
                for (int i2 = 0; i2 < ProcessChain.this.processes.length; ++i2) {
                    try {
                        ProcessChain.this.processes[i2].cleanup();
                        continue;
                    }
                    catch (ProcessException processException) {
                        // empty catch block
                    }
                }
            }
            finally {
                for (i = 0; i < ProcessChain.this.processes.length; ++i) {
                    try {
                        ProcessChain.this.processes[i].cleanup();
                        continue;
                    }
                    catch (ProcessException exception) {}
                }
            }
        }

        public synchronized void stop() {
            if (this.stop) {
                return;
            }
            this.stop = true;
            for (int i = this.runningIndex; i < ProcessChain.this.processes.length; ++i) {
                try {
                    ProcessChain.this.processes[i].stop();
                    continue;
                }
                catch (ProcessException processException) {
                    // empty catch block
                }
            }
        }
    }
}

