/*
 * Decompiled with CFR 0.152.
 */
package parquet.org.apache.thrift.server;

import parquet.org.apache.thrift.TProcessor;
import parquet.org.apache.thrift.TProcessorFactory;
import parquet.org.apache.thrift.protocol.TBinaryProtocol;
import parquet.org.apache.thrift.protocol.TProtocolFactory;
import parquet.org.apache.thrift.transport.TServerTransport;
import parquet.org.apache.thrift.transport.TTransportFactory;

public abstract class TServer {
    protected TProcessorFactory processorFactory_;
    protected TServerTransport serverTransport_;
    protected TTransportFactory inputTransportFactory_;
    protected TTransportFactory outputTransportFactory_;
    protected TProtocolFactory inputProtocolFactory_;
    protected TProtocolFactory outputProtocolFactory_;
    private boolean isServing;

    protected TServer(AbstractServerArgs args2) {
        this.processorFactory_ = args2.processorFactory;
        this.serverTransport_ = args2.serverTransport;
        this.inputTransportFactory_ = args2.inputTransportFactory;
        this.outputTransportFactory_ = args2.outputTransportFactory;
        this.inputProtocolFactory_ = args2.inputProtocolFactory;
        this.outputProtocolFactory_ = args2.outputProtocolFactory;
    }

    public abstract void serve();

    public void stop() {
    }

    public boolean isServing() {
        return this.isServing;
    }

    protected void setServing(boolean serving) {
        this.isServing = serving;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractServerArgs<T extends AbstractServerArgs<T>> {
        final TServerTransport serverTransport;
        TProcessorFactory processorFactory;
        TTransportFactory inputTransportFactory = new TTransportFactory();
        TTransportFactory outputTransportFactory = new TTransportFactory();
        TProtocolFactory inputProtocolFactory = new TBinaryProtocol.Factory();
        TProtocolFactory outputProtocolFactory = new TBinaryProtocol.Factory();

        public AbstractServerArgs(TServerTransport transport) {
            this.serverTransport = transport;
        }

        public T processorFactory(TProcessorFactory factory) {
            this.processorFactory = factory;
            return (T)this;
        }

        public T processor(TProcessor processor) {
            this.processorFactory = new TProcessorFactory(processor);
            return (T)this;
        }

        public T transportFactory(TTransportFactory factory) {
            this.inputTransportFactory = factory;
            this.outputTransportFactory = factory;
            return (T)this;
        }

        public T inputTransportFactory(TTransportFactory factory) {
            this.inputTransportFactory = factory;
            return (T)this;
        }

        public T outputTransportFactory(TTransportFactory factory) {
            this.outputTransportFactory = factory;
            return (T)this;
        }

        public T protocolFactory(TProtocolFactory factory) {
            this.inputProtocolFactory = factory;
            this.outputProtocolFactory = factory;
            return (T)this;
        }

        public T inputProtocolFactory(TProtocolFactory factory) {
            this.inputProtocolFactory = factory;
            return (T)this;
        }

        public T outputProtocolFactory(TProtocolFactory factory) {
            this.outputProtocolFactory = factory;
            return (T)this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Args
    extends AbstractServerArgs<Args> {
        public Args(TServerTransport transport) {
            super(transport);
        }
    }
}

