/*
 * Decompiled with CFR 0.152.
 */
package parquet.org.apache.thrift.protocol;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import parquet.org.apache.thrift.TException;
import parquet.org.apache.thrift.protocol.TField;
import parquet.org.apache.thrift.protocol.TList;
import parquet.org.apache.thrift.protocol.TMap;
import parquet.org.apache.thrift.protocol.TMessage;
import parquet.org.apache.thrift.protocol.TProtocol;
import parquet.org.apache.thrift.protocol.TProtocolException;
import parquet.org.apache.thrift.protocol.TProtocolFactory;
import parquet.org.apache.thrift.protocol.TSet;
import parquet.org.apache.thrift.protocol.TStruct;
import parquet.org.apache.thrift.transport.TTransport;

public class TBinaryProtocol
extends TProtocol {
    private static final TStruct ANONYMOUS_STRUCT = new TStruct();
    protected static final int VERSION_MASK = -65536;
    protected static final int VERSION_1 = -2147418112;
    protected boolean strictRead_ = false;
    protected boolean strictWrite_ = true;
    protected int readLength_;
    protected boolean checkReadLength_ = false;
    private byte[] bout = new byte[1];
    private byte[] i16out = new byte[2];
    private byte[] i32out = new byte[4];
    private byte[] i64out = new byte[8];
    private byte[] bin = new byte[1];
    private byte[] i16rd = new byte[2];
    private byte[] i32rd = new byte[4];
    private byte[] i64rd = new byte[8];

    public TBinaryProtocol(TTransport trans) {
        this(trans, false, true);
    }

    public TBinaryProtocol(TTransport trans, boolean strictRead, boolean strictWrite) {
        super(trans);
        this.strictRead_ = strictRead;
        this.strictWrite_ = strictWrite;
    }

    public void writeMessageBegin(TMessage message) throws TException {
        if (this.strictWrite_) {
            int version = 0x80010000 | message.type;
            this.writeI32(version);
            this.writeString(message.name);
            this.writeI32(message.seqid);
        } else {
            this.writeString(message.name);
            this.writeByte(message.type);
            this.writeI32(message.seqid);
        }
    }

    public void writeMessageEnd() {
    }

    public void writeStructBegin(TStruct struct) {
    }

    public void writeStructEnd() {
    }

    public void writeFieldBegin(TField field2) throws TException {
        this.writeByte(field2.type);
        this.writeI16(field2.id);
    }

    public void writeFieldEnd() {
    }

    public void writeFieldStop() throws TException {
        this.writeByte((byte)0);
    }

    public void writeMapBegin(TMap map2) throws TException {
        this.writeByte(map2.keyType);
        this.writeByte(map2.valueType);
        this.writeI32(map2.size);
    }

    public void writeMapEnd() {
    }

    public void writeListBegin(TList list2) throws TException {
        this.writeByte(list2.elemType);
        this.writeI32(list2.size);
    }

    public void writeListEnd() {
    }

    public void writeSetBegin(TSet set2) throws TException {
        this.writeByte(set2.elemType);
        this.writeI32(set2.size);
    }

    public void writeSetEnd() {
    }

    public void writeBool(boolean b) throws TException {
        this.writeByte(b ? (byte)1 : 0);
    }

    public void writeByte(byte b) throws TException {
        this.bout[0] = b;
        this.trans_.write(this.bout, 0, 1);
    }

    public void writeI16(short i16) throws TException {
        this.i16out[0] = (byte)(0xFF & i16 >> 8);
        this.i16out[1] = (byte)(0xFF & i16);
        this.trans_.write(this.i16out, 0, 2);
    }

    public void writeI32(int i32) throws TException {
        this.i32out[0] = (byte)(0xFF & i32 >> 24);
        this.i32out[1] = (byte)(0xFF & i32 >> 16);
        this.i32out[2] = (byte)(0xFF & i32 >> 8);
        this.i32out[3] = (byte)(0xFF & i32);
        this.trans_.write(this.i32out, 0, 4);
    }

    public void writeI64(long i64) throws TException {
        this.i64out[0] = (byte)(0xFFL & i64 >> 56);
        this.i64out[1] = (byte)(0xFFL & i64 >> 48);
        this.i64out[2] = (byte)(0xFFL & i64 >> 40);
        this.i64out[3] = (byte)(0xFFL & i64 >> 32);
        this.i64out[4] = (byte)(0xFFL & i64 >> 24);
        this.i64out[5] = (byte)(0xFFL & i64 >> 16);
        this.i64out[6] = (byte)(0xFFL & i64 >> 8);
        this.i64out[7] = (byte)(0xFFL & i64);
        this.trans_.write(this.i64out, 0, 8);
    }

    public void writeDouble(double dub) throws TException {
        this.writeI64(Double.doubleToLongBits(dub));
    }

    public void writeString(String str) throws TException {
        try {
            byte[] dat = str.getBytes("UTF-8");
            this.writeI32(dat.length);
            this.trans_.write(dat, 0, dat.length);
        }
        catch (UnsupportedEncodingException uex) {
            throw new TException("JVM DOES NOT SUPPORT UTF-8");
        }
    }

    public void writeBinary(ByteBuffer bin) throws TException {
        int length = bin.limit() - bin.position();
        this.writeI32(length);
        this.trans_.write(bin.array(), bin.position() + bin.arrayOffset(), length);
    }

    public TMessage readMessageBegin() throws TException {
        int size2 = this.readI32();
        if (size2 < 0) {
            int version = size2 & 0xFFFF0000;
            if (version != -2147418112) {
                throw new TProtocolException(4, "Bad version in readMessageBegin");
            }
            return new TMessage(this.readString(), (byte)(size2 & 0xFF), this.readI32());
        }
        if (this.strictRead_) {
            throw new TProtocolException(4, "Missing version in readMessageBegin, old client?");
        }
        return new TMessage(this.readStringBody(size2), this.readByte(), this.readI32());
    }

    public void readMessageEnd() {
    }

    public TStruct readStructBegin() {
        return ANONYMOUS_STRUCT;
    }

    public void readStructEnd() {
    }

    public TField readFieldBegin() throws TException {
        byte type = this.readByte();
        short id = type == 0 ? (short)0 : this.readI16();
        return new TField("", type, id);
    }

    public void readFieldEnd() {
    }

    public TMap readMapBegin() throws TException {
        return new TMap(this.readByte(), this.readByte(), this.readI32());
    }

    public void readMapEnd() {
    }

    public TList readListBegin() throws TException {
        return new TList(this.readByte(), this.readI32());
    }

    public void readListEnd() {
    }

    public TSet readSetBegin() throws TException {
        return new TSet(this.readByte(), this.readI32());
    }

    public void readSetEnd() {
    }

    public boolean readBool() throws TException {
        return this.readByte() == 1;
    }

    public byte readByte() throws TException {
        if (this.trans_.getBytesRemainingInBuffer() >= 1) {
            byte b = this.trans_.getBuffer()[this.trans_.getBufferPosition()];
            this.trans_.consumeBuffer(1);
            return b;
        }
        this.readAll(this.bin, 0, 1);
        return this.bin[0];
    }

    public short readI16() throws TException {
        byte[] buf = this.i16rd;
        int off = 0;
        if (this.trans_.getBytesRemainingInBuffer() >= 2) {
            buf = this.trans_.getBuffer();
            off = this.trans_.getBufferPosition();
            this.trans_.consumeBuffer(2);
        } else {
            this.readAll(this.i16rd, 0, 2);
        }
        return (short)((buf[off] & 0xFF) << 8 | buf[off + 1] & 0xFF);
    }

    public int readI32() throws TException {
        byte[] buf = this.i32rd;
        int off = 0;
        if (this.trans_.getBytesRemainingInBuffer() >= 4) {
            buf = this.trans_.getBuffer();
            off = this.trans_.getBufferPosition();
            this.trans_.consumeBuffer(4);
        } else {
            this.readAll(this.i32rd, 0, 4);
        }
        return (buf[off] & 0xFF) << 24 | (buf[off + 1] & 0xFF) << 16 | (buf[off + 2] & 0xFF) << 8 | buf[off + 3] & 0xFF;
    }

    public long readI64() throws TException {
        byte[] buf = this.i64rd;
        int off = 0;
        if (this.trans_.getBytesRemainingInBuffer() >= 8) {
            buf = this.trans_.getBuffer();
            off = this.trans_.getBufferPosition();
            this.trans_.consumeBuffer(8);
        } else {
            this.readAll(this.i64rd, 0, 8);
        }
        return (long)(buf[off] & 0xFF) << 56 | (long)(buf[off + 1] & 0xFF) << 48 | (long)(buf[off + 2] & 0xFF) << 40 | (long)(buf[off + 3] & 0xFF) << 32 | (long)(buf[off + 4] & 0xFF) << 24 | (long)(buf[off + 5] & 0xFF) << 16 | (long)(buf[off + 6] & 0xFF) << 8 | (long)(buf[off + 7] & 0xFF);
    }

    public double readDouble() throws TException {
        return Double.longBitsToDouble(this.readI64());
    }

    public String readString() throws TException {
        int size2 = this.readI32();
        if (this.trans_.getBytesRemainingInBuffer() >= size2) {
            try {
                String s2 = new String(this.trans_.getBuffer(), this.trans_.getBufferPosition(), size2, "UTF-8");
                this.trans_.consumeBuffer(size2);
                return s2;
            }
            catch (UnsupportedEncodingException e) {
                throw new TException("JVM DOES NOT SUPPORT UTF-8");
            }
        }
        return this.readStringBody(size2);
    }

    public String readStringBody(int size2) throws TException {
        try {
            this.checkReadLength(size2);
            byte[] buf = new byte[size2];
            this.trans_.readAll(buf, 0, size2);
            return new String(buf, "UTF-8");
        }
        catch (UnsupportedEncodingException uex) {
            throw new TException("JVM DOES NOT SUPPORT UTF-8");
        }
    }

    public ByteBuffer readBinary() throws TException {
        int size2 = this.readI32();
        this.checkReadLength(size2);
        if (this.trans_.getBytesRemainingInBuffer() >= size2) {
            ByteBuffer bb = ByteBuffer.wrap(this.trans_.getBuffer(), this.trans_.getBufferPosition(), size2);
            this.trans_.consumeBuffer(size2);
            return bb;
        }
        byte[] buf = new byte[size2];
        this.trans_.readAll(buf, 0, size2);
        return ByteBuffer.wrap(buf);
    }

    private int readAll(byte[] buf, int off, int len) throws TException {
        this.checkReadLength(len);
        return this.trans_.readAll(buf, off, len);
    }

    public void setReadLength(int readLength) {
        this.readLength_ = readLength;
        this.checkReadLength_ = true;
    }

    protected void checkReadLength(int length) throws TException {
        if (length < 0) {
            throw new TException("Negative length: " + length);
        }
        if (this.checkReadLength_) {
            this.readLength_ -= length;
            if (this.readLength_ < 0) {
                throw new TException("Message length exceeded: " + length);
            }
        }
    }

    public static class Factory
    implements TProtocolFactory {
        protected boolean strictRead_ = false;
        protected boolean strictWrite_ = true;
        protected int readLength_;

        public Factory() {
            this(false, true);
        }

        public Factory(boolean strictRead, boolean strictWrite) {
            this(strictRead, strictWrite, 0);
        }

        public Factory(boolean strictRead, boolean strictWrite, int readLength) {
            this.strictRead_ = strictRead;
            this.strictWrite_ = strictWrite;
            this.readLength_ = readLength;
        }

        public TProtocol getProtocol(TTransport trans) {
            TBinaryProtocol proto = new TBinaryProtocol(trans, this.strictRead_, this.strictWrite_);
            if (this.readLength_ != 0) {
                proto.setReadLength(this.readLength_);
            }
            return proto;
        }
    }
}

