/*
 * Decompiled with CFR 0.152.
 */
package parquet.org.apache.thrift;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import parquet.org.apache.thrift.TBase;
import parquet.org.apache.thrift.TBaseHelper;
import parquet.org.apache.thrift.TException;
import parquet.org.apache.thrift.TFieldIdEnum;
import parquet.org.apache.thrift.protocol.TField;
import parquet.org.apache.thrift.protocol.TProtocol;
import parquet.org.apache.thrift.protocol.TProtocolException;
import parquet.org.apache.thrift.protocol.TStruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TUnion<T extends TUnion<?, ?>, F extends TFieldIdEnum>
implements TBase<T, F> {
    protected Object value_;
    protected F setField_;

    protected TUnion() {
        this.setField_ = null;
        this.value_ = null;
    }

    protected TUnion(F setField, Object value2) {
        this.setFieldValue(setField, value2);
    }

    protected TUnion(TUnion<T, F> other) {
        if (!other.getClass().equals(this.getClass())) {
            throw new ClassCastException();
        }
        this.setField_ = other.setField_;
        this.value_ = TUnion.deepCopyObject(other.value_);
    }

    private static Object deepCopyObject(Object o) {
        if (o instanceof TBase) {
            return ((TBase)o).deepCopy();
        }
        if (o instanceof ByteBuffer) {
            return TBaseHelper.copyBinary((ByteBuffer)o);
        }
        if (o instanceof List) {
            return TUnion.deepCopyList((List)o);
        }
        if (o instanceof Set) {
            return TUnion.deepCopySet((Set)o);
        }
        if (o instanceof Map) {
            return TUnion.deepCopyMap((Map)o);
        }
        return o;
    }

    private static Map deepCopyMap(Map<Object, Object> map2) {
        HashMap<Object, Object> copy = new HashMap<Object, Object>();
        for (Map.Entry<Object, Object> entry2 : map2.entrySet()) {
            copy.put(TUnion.deepCopyObject(entry2.getKey()), TUnion.deepCopyObject(entry2.getValue()));
        }
        return copy;
    }

    private static Set deepCopySet(Set set2) {
        HashSet<Object> copy = new HashSet<Object>();
        for (Object o : set2) {
            copy.add(TUnion.deepCopyObject(o));
        }
        return copy;
    }

    private static List deepCopyList(List list2) {
        ArrayList<Object> copy = new ArrayList<Object>(list2.size());
        for (Object o : list2) {
            copy.add(TUnion.deepCopyObject(o));
        }
        return copy;
    }

    public F getSetField() {
        return this.setField_;
    }

    public Object getFieldValue() {
        return this.value_;
    }

    @Override
    public Object getFieldValue(F fieldId) {
        if (fieldId != this.setField_) {
            throw new IllegalArgumentException("Cannot get the value of field " + fieldId + " because union's set field is " + this.setField_);
        }
        return this.getFieldValue();
    }

    @Override
    public Object getFieldValue(int fieldId) {
        return this.getFieldValue(this.enumForId((short)fieldId));
    }

    public boolean isSet() {
        return this.setField_ != null;
    }

    @Override
    public boolean isSet(F fieldId) {
        return this.setField_ == fieldId;
    }

    @Override
    public boolean isSet(int fieldId) {
        return this.isSet(this.enumForId((short)fieldId));
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        this.setField_ = null;
        this.value_ = null;
        iprot.readStructBegin();
        TField field2 = iprot.readFieldBegin();
        this.value_ = this.readValue(iprot, field2);
        if (this.value_ != null) {
            this.setField_ = this.enumForId(field2.id);
        }
        iprot.readFieldEnd();
        iprot.readFieldBegin();
        iprot.readStructEnd();
    }

    @Override
    public void setFieldValue(F fieldId, Object value2) {
        this.checkType(fieldId, value2);
        this.setField_ = fieldId;
        this.value_ = value2;
    }

    @Override
    public void setFieldValue(int fieldId, Object value2) {
        this.setFieldValue(this.enumForId((short)fieldId), value2);
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        if (this.getSetField() == null || this.getFieldValue() == null) {
            throw new TProtocolException("Cannot write a TUnion with no set value!");
        }
        oprot.writeStructBegin(this.getStructDesc());
        oprot.writeFieldBegin(this.getFieldDesc(this.setField_));
        this.writeValue(oprot);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    protected abstract void checkType(F var1, Object var2) throws ClassCastException;

    protected abstract Object readValue(TProtocol var1, TField var2) throws TException;

    protected abstract void writeValue(TProtocol var1) throws TException;

    protected abstract TStruct getStructDesc();

    protected abstract TField getFieldDesc(F var1);

    protected abstract F enumForId(short var1);

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        sb.append(this.getClass().getSimpleName());
        sb.append(" ");
        if (this.getSetField() != null) {
            Object v = this.getFieldValue();
            sb.append(this.getFieldDesc(this.getSetField()).name);
            sb.append(":");
            if (v instanceof ByteBuffer) {
                TBaseHelper.toString((ByteBuffer)v, sb);
            } else {
                sb.append(v.toString());
            }
        }
        sb.append(">");
        return sb.toString();
    }

    @Override
    public final void clear() {
        this.setField_ = null;
        this.value_ = null;
    }
}

