/*
 * Decompiled with CFR 0.152.
 */
package parquet.org.apache.thrift;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import parquet.org.apache.thrift.TBase;
import parquet.org.apache.thrift.TException;
import parquet.org.apache.thrift.TFieldIdEnum;
import parquet.org.apache.thrift.protocol.TBinaryProtocol;
import parquet.org.apache.thrift.protocol.TField;
import parquet.org.apache.thrift.protocol.TProtocol;
import parquet.org.apache.thrift.protocol.TProtocolFactory;
import parquet.org.apache.thrift.protocol.TProtocolUtil;
import parquet.org.apache.thrift.transport.TMemoryInputTransport;

public class TDeserializer {
    private final TProtocol protocol_;
    private final TMemoryInputTransport trans_ = new TMemoryInputTransport();

    public TDeserializer() {
        this(new TBinaryProtocol.Factory());
    }

    public TDeserializer(TProtocolFactory protocolFactory) {
        this.protocol_ = protocolFactory.getProtocol(this.trans_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deserialize(TBase base, byte[] bytes2) throws TException {
        try {
            this.trans_.reset(bytes2);
            base.read(this.protocol_);
        }
        finally {
            this.trans_.clear();
            this.protocol_.reset();
        }
    }

    public void deserialize(TBase base, String data2, String charset) throws TException {
        try {
            this.deserialize(base, data2.getBytes(charset));
        }
        catch (UnsupportedEncodingException uex) {
            throw new TException("JVM DOES NOT SUPPORT ENCODING: " + charset);
        }
        finally {
            this.protocol_.reset();
        }
    }

    public void partialDeserialize(TBase tb, byte[] bytes2, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) throws TException {
        try {
            if (this.locateField(bytes2, fieldIdPathFirst, fieldIdPathRest) != null) {
                tb.read(this.protocol_);
            }
        }
        catch (Exception e) {
            throw new TException(e);
        }
        finally {
            this.trans_.clear();
            this.protocol_.reset();
        }
    }

    public Boolean partialDeserializeBool(byte[] bytes2, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) throws TException {
        return (Boolean)this.partialDeserializeField((byte)2, bytes2, fieldIdPathFirst, fieldIdPathRest);
    }

    public Byte partialDeserializeByte(byte[] bytes2, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) throws TException {
        return (Byte)this.partialDeserializeField((byte)3, bytes2, fieldIdPathFirst, fieldIdPathRest);
    }

    public Double partialDeserializeDouble(byte[] bytes2, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) throws TException {
        return (Double)this.partialDeserializeField((byte)4, bytes2, fieldIdPathFirst, fieldIdPathRest);
    }

    public Short partialDeserializeI16(byte[] bytes2, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) throws TException {
        return (Short)this.partialDeserializeField((byte)6, bytes2, fieldIdPathFirst, fieldIdPathRest);
    }

    public Integer partialDeserializeI32(byte[] bytes2, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) throws TException {
        return (Integer)this.partialDeserializeField((byte)8, bytes2, fieldIdPathFirst, fieldIdPathRest);
    }

    public Long partialDeserializeI64(byte[] bytes2, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) throws TException {
        return (Long)this.partialDeserializeField((byte)10, bytes2, fieldIdPathFirst, fieldIdPathRest);
    }

    public String partialDeserializeString(byte[] bytes2, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) throws TException {
        return (String)this.partialDeserializeField((byte)11, bytes2, fieldIdPathFirst, fieldIdPathRest);
    }

    public ByteBuffer partialDeserializeByteArray(byte[] bytes2, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) throws TException {
        return (ByteBuffer)this.partialDeserializeField((byte)100, bytes2, fieldIdPathFirst, fieldIdPathRest);
    }

    public Short partialDeserializeSetFieldIdInUnion(byte[] bytes2, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) throws TException {
        try {
            TField field2 = this.locateField(bytes2, fieldIdPathFirst, fieldIdPathRest);
            if (field2 != null) {
                this.protocol_.readStructBegin();
                Short s2 = this.protocol_.readFieldBegin().id;
                return s2;
            }
            Short s3 = null;
            return s3;
        }
        catch (Exception e) {
            throw new TException(e);
        }
        finally {
            this.trans_.clear();
            this.protocol_.reset();
        }
    }

    private Object partialDeserializeField(byte ttype, byte[] bytes2, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) throws TException {
        try {
            TField field2 = this.locateField(bytes2, fieldIdPathFirst, fieldIdPathRest);
            if (field2 != null) {
                switch (ttype) {
                    case 2: {
                        if (field2.type != 2) break;
                        Boolean bl = this.protocol_.readBool();
                        return bl;
                    }
                    case 3: {
                        if (field2.type != 3) break;
                        Byte by2 = this.protocol_.readByte();
                        return by2;
                    }
                    case 4: {
                        if (field2.type != 4) break;
                        Double d = this.protocol_.readDouble();
                        return d;
                    }
                    case 6: {
                        if (field2.type != 6) break;
                        Short s2 = this.protocol_.readI16();
                        return s2;
                    }
                    case 8: {
                        if (field2.type != 8) break;
                        Integer n = this.protocol_.readI32();
                        return n;
                    }
                    case 10: {
                        if (field2.type != 10) break;
                        Long l = this.protocol_.readI64();
                        return l;
                    }
                    case 11: {
                        if (field2.type != 11) break;
                        String string2 = this.protocol_.readString();
                        return string2;
                    }
                    case 100: {
                        if (field2.type != 11) break;
                        ByteBuffer byteBuffer = this.protocol_.readBinary();
                        return byteBuffer;
                    }
                }
            }
            Object var6_15 = null;
            return var6_15;
        }
        catch (Exception e) {
            throw new TException(e);
        }
        finally {
            this.trans_.clear();
            this.protocol_.reset();
        }
    }

    private TField locateField(byte[] bytes2, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) throws TException {
        this.trans_.reset(bytes2);
        TFieldIdEnum[] fieldIdPath = new TFieldIdEnum[fieldIdPathRest.length + 1];
        fieldIdPath[0] = fieldIdPathFirst;
        for (int i = 0; i < fieldIdPathRest.length; ++i) {
            fieldIdPath[i + 1] = fieldIdPathRest[i];
        }
        int curPathIndex = 0;
        TField field2 = null;
        this.protocol_.readStructBegin();
        while (curPathIndex < fieldIdPath.length) {
            field2 = this.protocol_.readFieldBegin();
            if (field2.type == 0 || field2.id > fieldIdPath[curPathIndex].getThriftFieldId()) {
                return null;
            }
            if (field2.id != fieldIdPath[curPathIndex].getThriftFieldId()) {
                TProtocolUtil.skip(this.protocol_, field2.type);
                this.protocol_.readFieldEnd();
                continue;
            }
            if (++curPathIndex >= fieldIdPath.length) continue;
            this.protocol_.readStructBegin();
        }
        return field2;
    }

    public void fromString(TBase base, String data2) throws TException {
        this.deserialize(base, data2.getBytes());
    }
}

