/*
 * Decompiled with CFR 0.152.
 */
package org.objenesis;

import java.util.HashMap;
import java.util.Map;
import org.objenesis.Objenesis;
import org.objenesis.instantiator.ObjectInstantiator;
import org.objenesis.strategy.InstantiatorStrategy;

public class ObjenesisBase
implements Objenesis {
    protected final InstantiatorStrategy strategy;
    protected Map cache;

    public ObjenesisBase(InstantiatorStrategy strategy) {
        this(strategy, true);
    }

    public ObjenesisBase(InstantiatorStrategy strategy, boolean useCache) {
        if (strategy == null) {
            throw new IllegalArgumentException("A strategy can't be null");
        }
        this.strategy = strategy;
        this.cache = useCache ? new HashMap() : null;
    }

    public String toString() {
        return this.getClass().getName() + " using " + this.strategy.getClass().getName() + (this.cache == null ? " without" : " with") + " caching";
    }

    public Object newInstance(Class clazz2) {
        return this.getInstantiatorOf(clazz2).newInstance();
    }

    public synchronized ObjectInstantiator getInstantiatorOf(Class clazz2) {
        if (this.cache == null) {
            return this.strategy.newInstantiatorOf(clazz2);
        }
        ObjectInstantiator instantiator = (ObjectInstantiator)this.cache.get(clazz2.getName());
        if (instantiator == null) {
            instantiator = this.strategy.newInstantiatorOf(clazz2);
            this.cache.put(clazz2.getName(), instantiator);
        }
        return instantiator;
    }
}

