/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util.ajax;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.mortbay.log.Log;
import org.mortbay.util.ajax.JSON;

public class JSONPojoConvertor
implements JSON.Convertor {
    public static final Object[] GETTER_ARG = new Object[0];
    public static final Object[] NULL_ARG = new Object[]{null};
    private static final Map __numberTypes = new HashMap();
    protected boolean _fromJSON;
    protected Class _pojoClass;
    protected Map _getters = new HashMap();
    protected Map _setters = new HashMap();
    protected Set _excluded;
    public static final NumberType SHORT = new NumberType(){

        public Object getActualValue(Number number2) {
            return new Short(number2.shortValue());
        }
    };
    public static final NumberType INTEGER = new NumberType(){

        public Object getActualValue(Number number2) {
            return new Integer(number2.intValue());
        }
    };
    public static final NumberType FLOAT = new NumberType(){

        public Object getActualValue(Number number2) {
            return new Float(number2.floatValue());
        }
    };
    public static final NumberType LONG = new NumberType(){

        public Object getActualValue(Number number2) {
            return number2 instanceof Long ? (Number)number2 : (Number)new Long(number2.longValue());
        }
    };
    public static final NumberType DOUBLE = new NumberType(){

        public Object getActualValue(Number number2) {
            return number2 instanceof Double ? (Number)number2 : (Number)new Double(number2.doubleValue());
        }
    };
    static /* synthetic */ Class class$java$lang$Object;

    public static NumberType getNumberType(Class clazz2) {
        return (NumberType)__numberTypes.get(clazz2);
    }

    public JSONPojoConvertor(Class pojoClass) {
        this(pojoClass, null, true);
    }

    public JSONPojoConvertor(Class pojoClass, String[] excluded) {
        this(pojoClass, new HashSet<String>(Arrays.asList(excluded)), true);
    }

    public JSONPojoConvertor(Class pojoClass, Set excluded) {
        this(pojoClass, excluded, true);
    }

    public JSONPojoConvertor(Class pojoClass, Set excluded, boolean fromJSON) {
        this._pojoClass = pojoClass;
        this._excluded = excluded;
        this._fromJSON = fromJSON;
        this.init();
    }

    public JSONPojoConvertor(Class pojoClass, boolean fromJSON) {
        this(pojoClass, null, fromJSON);
    }

    protected void init() {
        Method[] methods2 = this._pojoClass.getMethods();
        block4: for (int i = 0; i < methods2.length; ++i) {
            Method m = methods2[i];
            if (Modifier.isStatic(m.getModifiers()) || m.getDeclaringClass() == (class$java$lang$Object == null ? JSONPojoConvertor.class$("java.lang.Object") : class$java$lang$Object)) continue;
            String name2 = m.getName();
            switch (m.getParameterTypes().length) {
                case 0: {
                    if (m.getReturnType() == null) continue block4;
                    if (name2.startsWith("is") && name2.length() > 2) {
                        name2 = name2.substring(2, 3).toLowerCase() + name2.substring(3);
                    } else {
                        if (!name2.startsWith("get") || name2.length() <= 3) continue block4;
                        name2 = name2.substring(3, 4).toLowerCase() + name2.substring(4);
                    }
                    if (!this.includeField(name2, m)) continue block4;
                    this.addGetter(name2, m);
                    continue block4;
                }
                case 1: {
                    if (!name2.startsWith("set") || name2.length() <= 3 || !this.includeField(name2 = name2.substring(3, 4).toLowerCase() + name2.substring(4), m)) continue block4;
                    this.addSetter(name2, m);
                }
            }
        }
    }

    protected void addGetter(String name2, Method method) {
        this._getters.put(name2, method);
    }

    protected void addSetter(String name2, Method method) {
        this._setters.put(name2, new Setter(name2, method));
    }

    protected Setter getSetter(String name2) {
        return (Setter)this._setters.get(name2);
    }

    protected boolean includeField(String name2, Method m) {
        return this._excluded == null || !this._excluded.contains(name2);
    }

    protected int getExcludedCount() {
        return this._excluded == null ? 0 : this._excluded.size();
    }

    public Object fromJSON(Map object) {
        Object obj = null;
        try {
            obj = this._pojoClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.setProps(obj, object);
        return obj;
    }

    public int setProps(Object obj, Map props) {
        int count2 = 0;
        Iterator iterator2 = props.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry2 = iterator2.next();
            Setter setter2 = this.getSetter((String)entry2.getKey());
            if (setter2 == null) continue;
            try {
                setter2.invoke(obj, entry2.getValue());
                ++count2;
            }
            catch (Exception e) {
                Log.warn("{} property '{}' not set. (errors)", this._pojoClass.getName(), setter2.getPropertyName());
                this.log(e);
            }
        }
        return count2;
    }

    public void toJSON(Object obj, JSON.Output out) {
        if (this._fromJSON) {
            out.addClass(this._pojoClass);
        }
        Iterator iterator2 = this._getters.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry2 = iterator2.next();
            try {
                out.add((String)entry2.getKey(), ((Method)entry2.getValue()).invoke(obj, GETTER_ARG));
            }
            catch (Exception e) {
                Log.warn("{} property '{}' excluded. (errors)", this._pojoClass.getName(), entry2.getKey());
                this.log(e);
            }
        }
    }

    protected void log(Throwable t) {
        Log.ignore(t);
    }

    static {
        __numberTypes.put(Short.class, SHORT);
        __numberTypes.put(Short.TYPE, SHORT);
        __numberTypes.put(Integer.class, INTEGER);
        __numberTypes.put(Integer.TYPE, INTEGER);
        __numberTypes.put(Long.class, LONG);
        __numberTypes.put(Long.TYPE, LONG);
        __numberTypes.put(Float.class, FLOAT);
        __numberTypes.put(Float.TYPE, FLOAT);
        __numberTypes.put(Double.class, DOUBLE);
        __numberTypes.put(Double.TYPE, DOUBLE);
    }

    public static interface NumberType {
        public Object getActualValue(Number var1);
    }

    public static class Setter {
        protected String _propertyName;
        protected Method _method;
        protected NumberType _numberType;
        protected Class _type;
        protected Class _componentType;

        public Setter(String propertyName, Method method) {
            this._propertyName = propertyName;
            this._method = method;
            this._type = method.getParameterTypes()[0];
            this._numberType = (NumberType)__numberTypes.get(this._type);
            if (this._numberType == null && this._type.isArray()) {
                this._componentType = this._type.getComponentType();
                this._numberType = (NumberType)__numberTypes.get(this._componentType);
            }
        }

        public String getPropertyName() {
            return this._propertyName;
        }

        public Method getMethod() {
            return this._method;
        }

        public NumberType getNumberType() {
            return this._numberType;
        }

        public Class getType() {
            return this._type;
        }

        public Class getComponentType() {
            return this._componentType;
        }

        public boolean isPropertyNumber() {
            return this._numberType != null;
        }

        public void invoke(Object obj, Object value2) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (value2 == null) {
                this._method.invoke(obj, NULL_ARG);
            } else {
                this.invokeObject(obj, value2);
            }
        }

        protected void invokeObject(Object obj, Object value2) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (this._numberType != null && value2 instanceof Number) {
                this._method.invoke(obj, this._numberType.getActualValue((Number)value2));
            } else if (this._componentType != null && value2.getClass().isArray()) {
                if (this._numberType == null) {
                    int len = Array.getLength(value2);
                    Object array2 = Array.newInstance(this._componentType, len);
                    try {
                        System.arraycopy(value2, 0, array2, 0, len);
                    }
                    catch (Exception e) {
                        Log.ignore(e);
                        this._method.invoke(obj, value2);
                        return;
                    }
                    this._method.invoke(obj, array2);
                } else {
                    Object[] old = (Object[])value2;
                    Object array3 = Array.newInstance(this._componentType, old.length);
                    try {
                        for (int i = 0; i < old.length; ++i) {
                            Array.set(array3, i, this._numberType.getActualValue((Number)old[i]));
                        }
                    }
                    catch (Exception e) {
                        Log.ignore(e);
                        this._method.invoke(obj, value2);
                        return;
                    }
                    this._method.invoke(obj, array3);
                }
            } else {
                this._method.invoke(obj, value2);
            }
        }
    }
}

