/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.mortbay.log.Log;

public class Scanner {
    private int _scanInterval;
    private List _listeners = Collections.synchronizedList(new ArrayList());
    private Map _prevScan = new HashMap();
    private Map _currentScan = new HashMap();
    private FilenameFilter _filter;
    private List _scanDirs;
    private volatile boolean _running = false;
    private boolean _reportExisting = true;
    private Timer _timer;
    private TimerTask _task;
    private boolean _recursive = true;

    public int getScanInterval() {
        return this._scanInterval;
    }

    public synchronized void setScanInterval(int scanInterval) {
        this._scanInterval = scanInterval;
        this.schedule();
    }

    public void setScanDir(File dir) {
        this._scanDirs = new ArrayList();
        this._scanDirs.add(dir);
    }

    public File getScanDir() {
        return this._scanDirs == null ? null : (File)this._scanDirs.get(0);
    }

    public void setScanDirs(List dirs2) {
        this._scanDirs = dirs2;
    }

    public List getScanDirs() {
        return this._scanDirs;
    }

    public void setRecursive(boolean recursive) {
        this._recursive = recursive;
    }

    public boolean getRecursive() {
        return this._recursive;
    }

    public void setFilenameFilter(FilenameFilter filter2) {
        this._filter = filter2;
    }

    public FilenameFilter getFilenameFilter() {
        return this._filter;
    }

    public void setReportExistingFilesOnStartup(boolean reportExisting) {
        this._reportExisting = reportExisting;
    }

    public synchronized void addListener(Listener listener) {
        if (listener == null) {
            return;
        }
        this._listeners.add(listener);
    }

    public synchronized void removeListener(Listener listener) {
        if (listener == null) {
            return;
        }
        this._listeners.remove(listener);
    }

    public synchronized void start() {
        if (this._running) {
            return;
        }
        this._running = true;
        if (this._reportExisting) {
            this.scan();
        } else {
            this.scanFiles();
            this._prevScan.putAll(this._currentScan);
        }
        this.schedule();
    }

    public TimerTask newTimerTask() {
        return new TimerTask(){

            public void run() {
                Scanner.this.scan();
            }
        };
    }

    public Timer newTimer() {
        return new Timer(true);
    }

    public void schedule() {
        if (this._running) {
            if (this._timer != null) {
                this._timer.cancel();
            }
            if (this._task != null) {
                this._task.cancel();
            }
            if (this.getScanInterval() > 0) {
                this._timer = this.newTimer();
                this._task = this.newTimerTask();
                this._timer.schedule(this._task, 1000L * (long)this.getScanInterval(), 1000L * (long)this.getScanInterval());
            }
        }
    }

    public synchronized void stop() {
        if (this._running) {
            this._running = false;
            if (this._timer != null) {
                this._timer.cancel();
            }
            if (this._task != null) {
                this._task.cancel();
            }
            this._task = null;
            this._timer = null;
        }
    }

    public void scan() {
        this.scanFiles();
        this.reportDifferences(this._currentScan, this._prevScan);
        this._prevScan.clear();
        this._prevScan.putAll(this._currentScan);
    }

    public void scanFiles() {
        if (this._scanDirs == null) {
            return;
        }
        this._currentScan.clear();
        Iterator itor = this._scanDirs.iterator();
        while (itor.hasNext()) {
            File dir = (File)itor.next();
            if (dir == null || !dir.exists()) continue;
            this.scanFile(dir, this._currentScan);
        }
    }

    public void reportDifferences(Map currentScan, Map oldScan) {
        ArrayList<Object> bulkChanges = new ArrayList<Object>();
        HashSet oldScanKeys = new HashSet(oldScan.keySet());
        Iterator itor = currentScan.entrySet().iterator();
        while (itor.hasNext()) {
            Map.Entry entry2 = itor.next();
            if (!oldScanKeys.contains(entry2.getKey())) {
                Log.debug("File added: " + entry2.getKey());
                this.reportAddition((String)entry2.getKey());
                bulkChanges.add(entry2.getKey());
                continue;
            }
            if (!oldScan.get(entry2.getKey()).equals(entry2.getValue())) {
                Log.debug("File changed: " + entry2.getKey());
                this.reportChange((String)entry2.getKey());
                oldScanKeys.remove(entry2.getKey());
                bulkChanges.add(entry2.getKey());
                continue;
            }
            oldScanKeys.remove(entry2.getKey());
        }
        if (!oldScanKeys.isEmpty()) {
            Iterator keyItor = oldScanKeys.iterator();
            while (keyItor.hasNext()) {
                String filename = (String)keyItor.next();
                Log.debug("File removed: " + filename);
                this.reportRemoval(filename);
                bulkChanges.add(filename);
            }
        }
        if (!bulkChanges.isEmpty()) {
            this.reportBulkChanges(bulkChanges);
        }
    }

    private void scanFile(File f2, Map scanInfoMap) {
        try {
            if (!f2.exists()) {
                return;
            }
            if (f2.isFile()) {
                if (this._filter == null || this._filter != null && this._filter.accept(f2.getParentFile(), f2.getName())) {
                    String name2 = f2.getCanonicalPath();
                    long lastModified = f2.lastModified();
                    scanInfoMap.put(name2, new Long(lastModified));
                }
            } else if (f2.isDirectory() && (this._recursive || this._scanDirs.contains(f2))) {
                File[] files2 = f2.listFiles();
                for (int i = 0; i < files2.length; ++i) {
                    this.scanFile(files2[i], scanInfoMap);
                }
            }
        }
        catch (IOException e) {
            Log.warn("Error scanning watched files", e);
        }
    }

    private void warn(Object listener, String filename, Throwable th) {
        Log.warn(th);
        Log.warn(listener + " failed on '" + filename);
    }

    private void reportAddition(String filename) {
        Iterator itor = this._listeners.iterator();
        while (itor.hasNext()) {
            Object l = itor.next();
            try {
                if (!(l instanceof DiscreteListener)) continue;
                ((DiscreteListener)l).fileAdded(filename);
            }
            catch (Exception e) {
                this.warn(l, filename, e);
            }
            catch (Error e) {
                this.warn(l, filename, e);
            }
        }
    }

    private void reportRemoval(String filename) {
        Iterator itor = this._listeners.iterator();
        while (itor.hasNext()) {
            Object l = itor.next();
            try {
                if (!(l instanceof DiscreteListener)) continue;
                ((DiscreteListener)l).fileRemoved(filename);
            }
            catch (Exception e) {
                this.warn(l, filename, e);
            }
            catch (Error e) {
                this.warn(l, filename, e);
            }
        }
    }

    private void reportChange(String filename) {
        Iterator itor = this._listeners.iterator();
        while (itor.hasNext()) {
            Object l = itor.next();
            try {
                if (!(l instanceof DiscreteListener)) continue;
                ((DiscreteListener)l).fileChanged(filename);
            }
            catch (Exception e) {
                this.warn(l, filename, e);
            }
            catch (Error e) {
                this.warn(l, filename, e);
            }
        }
    }

    private void reportBulkChanges(List filenames) {
        Iterator itor = this._listeners.iterator();
        while (itor.hasNext()) {
            Object l = itor.next();
            try {
                if (!(l instanceof BulkListener)) continue;
                ((BulkListener)l).filesChanged(filenames);
            }
            catch (Exception e) {
                this.warn(l, filenames.toString(), e);
            }
            catch (Error e) {
                this.warn(l, filenames.toString(), e);
            }
        }
    }

    public static interface BulkListener
    extends Listener {
        public void filesChanged(List var1) throws Exception;
    }

    public static interface DiscreteListener
    extends Listener {
        public void fileChanged(String var1) throws Exception;

        public void fileAdded(String var1) throws Exception;

        public void fileRemoved(String var1) throws Exception;
    }

    public static interface Listener {
    }
}

