/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;

public class IntrospectionUtil {
    public static boolean isJavaBeanCompliantSetter(Method method) {
        if (method == null) {
            return false;
        }
        if (method.getReturnType() != Void.TYPE) {
            return false;
        }
        if (!method.getName().startsWith("set")) {
            return false;
        }
        return method.getParameterTypes().length == 1;
    }

    public static Method findMethod(Class clazz2, String methodName, Class[] args2, boolean checkInheritance, boolean strictArgs) throws NoSuchMethodException {
        if (clazz2 == null) {
            throw new NoSuchMethodException("No class");
        }
        if (methodName == null || methodName.trim().equals("")) {
            throw new NoSuchMethodException("No method name");
        }
        Method method = null;
        Method[] methods2 = clazz2.getDeclaredMethods();
        for (int i = 0; i < methods2.length && method == null; ++i) {
            if (!methods2[i].getName().equals(methodName) || !IntrospectionUtil.checkParams(methods2[i].getParameterTypes(), args2 == null ? new Class[]{} : args2, strictArgs)) continue;
            method = methods2[i];
        }
        if (method != null) {
            return method;
        }
        if (checkInheritance) {
            return IntrospectionUtil.findInheritedMethod(clazz2.getPackage(), clazz2.getSuperclass(), methodName, args2, strictArgs);
        }
        throw new NoSuchMethodException("No such method " + methodName + " on class " + clazz2.getName());
    }

    public static Field findField(Class clazz2, String targetName, Class targetType, boolean checkInheritance, boolean strictType) throws NoSuchFieldException {
        if (clazz2 == null) {
            throw new NoSuchFieldException("No class");
        }
        if (targetName == null) {
            throw new NoSuchFieldException("No field name");
        }
        try {
            Field field2 = clazz2.getDeclaredField(targetName);
            if (strictType ? field2.getType().equals(targetType) : field2.getType().isAssignableFrom(targetType)) {
                return field2;
            }
            if (checkInheritance) {
                return IntrospectionUtil.findInheritedField(clazz2.getPackage(), clazz2.getSuperclass(), targetName, targetType, strictType);
            }
            throw new NoSuchFieldException("No field with name " + targetName + " in class " + clazz2.getName() + " of type " + targetType);
        }
        catch (NoSuchFieldException e) {
            return IntrospectionUtil.findInheritedField(clazz2.getPackage(), clazz2.getSuperclass(), targetName, targetType, strictType);
        }
    }

    public static boolean isInheritable(Package pack2, Member member) {
        if (pack2 == null) {
            return false;
        }
        if (member == null) {
            return false;
        }
        int modifiers = member.getModifiers();
        if (Modifier.isPublic(modifiers)) {
            return true;
        }
        if (Modifier.isProtected(modifiers)) {
            return true;
        }
        return !Modifier.isPrivate(modifiers) && pack2.equals(member.getDeclaringClass().getPackage());
    }

    public static boolean checkParams(Class[] formalParams, Class[] actualParams, boolean strict) {
        int j;
        if (formalParams == null && actualParams == null) {
            return true;
        }
        if (formalParams == null && actualParams != null) {
            return false;
        }
        if (formalParams != null && actualParams == null) {
            return false;
        }
        if (formalParams.length != actualParams.length) {
            return false;
        }
        if (formalParams.length == 0) {
            return true;
        }
        if (strict) {
            for (j = 0; j < formalParams.length && formalParams[j].equals(actualParams[j]); ++j) {
            }
        } else {
            while (j < formalParams.length && formalParams[j].isAssignableFrom(actualParams[j])) {
                ++j;
            }
        }
        return j == formalParams.length;
    }

    public static boolean isSameSignature(Method methodA, Method methodB) {
        if (methodA == null) {
            return false;
        }
        if (methodB == null) {
            return false;
        }
        List<Class<Class<?>>> parameterTypesA = Arrays.asList(methodA.getParameterTypes());
        List<Class<?>> parameterTypesB = Arrays.asList(methodB.getParameterTypes());
        return methodA.getName().equals(methodB.getName()) && parameterTypesA.containsAll(parameterTypesB);
    }

    public static boolean isTypeCompatible(Class formalType, Class actualType, boolean strict) {
        if (formalType == null && actualType != null) {
            return false;
        }
        if (formalType != null && actualType == null) {
            return false;
        }
        if (formalType == null && actualType == null) {
            return true;
        }
        if (strict) {
            return formalType.equals(actualType);
        }
        return formalType.isAssignableFrom(actualType);
    }

    public static boolean containsSameMethodSignature(Method method, Class c, boolean checkPackage) {
        if (checkPackage && !c.getPackage().equals(method.getDeclaringClass().getPackage())) {
            return false;
        }
        boolean samesig = false;
        Method[] methods2 = c.getDeclaredMethods();
        for (int i = 0; i < methods2.length && !samesig; ++i) {
            if (!IntrospectionUtil.isSameSignature(method, methods2[i])) continue;
            samesig = true;
        }
        return samesig;
    }

    public static boolean containsSameFieldName(Field field2, Class c, boolean checkPackage) {
        if (checkPackage && !c.getPackage().equals(field2.getDeclaringClass().getPackage())) {
            return false;
        }
        boolean sameName = false;
        Field[] fields2 = c.getDeclaredFields();
        for (int i = 0; i < fields2.length && !sameName; ++i) {
            if (!fields2[i].getName().equals(field2.getName())) continue;
            sameName = true;
        }
        return sameName;
    }

    protected static Method findInheritedMethod(Package pack2, Class clazz2, String methodName, Class[] args2, boolean strictArgs) throws NoSuchMethodException {
        if (clazz2 == null) {
            throw new NoSuchMethodException("No class");
        }
        if (methodName == null) {
            throw new NoSuchMethodException("No method name");
        }
        Method method = null;
        Method[] methods2 = clazz2.getDeclaredMethods();
        for (int i = 0; i < methods2.length && method == null; ++i) {
            if (!methods2[i].getName().equals(methodName) || !IntrospectionUtil.isInheritable(pack2, methods2[i]) || !IntrospectionUtil.checkParams(methods2[i].getParameterTypes(), args2, strictArgs)) continue;
            method = methods2[i];
        }
        if (method != null) {
            return method;
        }
        return IntrospectionUtil.findInheritedMethod(clazz2.getPackage(), clazz2.getSuperclass(), methodName, args2, strictArgs);
    }

    protected static Field findInheritedField(Package pack2, Class clazz2, String fieldName, Class fieldType, boolean strictType) throws NoSuchFieldException {
        if (clazz2 == null) {
            throw new NoSuchFieldException("No class");
        }
        if (fieldName == null) {
            throw new NoSuchFieldException("No field name");
        }
        try {
            Field field2 = clazz2.getDeclaredField(fieldName);
            if (IntrospectionUtil.isInheritable(pack2, field2) && IntrospectionUtil.isTypeCompatible(fieldType, field2.getType(), strictType)) {
                return field2;
            }
            return IntrospectionUtil.findInheritedField(clazz2.getPackage(), clazz2.getSuperclass(), fieldName, fieldType, strictType);
        }
        catch (NoSuchFieldException e) {
            return IntrospectionUtil.findInheritedField(clazz2.getPackage(), clazz2.getSuperclass(), fieldName, fieldType, strictType);
        }
    }
}

