/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashSet;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.util.IO;

public class ProxyServlet
implements Servlet {
    protected HashSet _DontProxyHeaders = new HashSet();
    protected ServletConfig _config;
    protected ServletContext _context;

    public ProxyServlet() {
        this._DontProxyHeaders.add("proxy-connection");
        this._DontProxyHeaders.add("connection");
        this._DontProxyHeaders.add("keep-alive");
        this._DontProxyHeaders.add("transfer-encoding");
        this._DontProxyHeaders.add("te");
        this._DontProxyHeaders.add("trailer");
        this._DontProxyHeaders.add("proxy-authorization");
        this._DontProxyHeaders.add("proxy-authenticate");
        this._DontProxyHeaders.add("upgrade");
    }

    public void init(ServletConfig config2) throws ServletException {
        this._config = config2;
        this._context = config2.getServletContext();
    }

    public ServletConfig getServletConfig() {
        return this._config;
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if ("CONNECT".equalsIgnoreCase(request.getMethod())) {
            this.handleConnect(request, response);
        } else {
            String cache_control;
            String connectionHdr;
            String uri = request.getRequestURI();
            if (request.getQueryString() != null) {
                uri = uri + "?" + request.getQueryString();
            }
            URL url = this.proxyHttpURL(request.getScheme(), request.getServerName(), request.getServerPort(), uri);
            URLConnection connection = url.openConnection();
            connection.setAllowUserInteraction(false);
            HttpURLConnection http = null;
            if (connection instanceof HttpURLConnection) {
                http = (HttpURLConnection)connection;
                http.setRequestMethod(request.getMethod());
                http.setInstanceFollowRedirects(false);
            }
            if ((connectionHdr = request.getHeader("Connection")) != null && ((connectionHdr = connectionHdr.toLowerCase()).equals("keep-alive") || connectionHdr.equals("close"))) {
                connectionHdr = null;
            }
            boolean xForwardedFor = false;
            boolean hasContent = false;
            Enumeration enm = request.getHeaderNames();
            while (enm.hasMoreElements()) {
                String hdr = (String)enm.nextElement();
                String lhdr = hdr.toLowerCase();
                if (this._DontProxyHeaders.contains(lhdr) || connectionHdr != null && connectionHdr.indexOf(lhdr) >= 0) continue;
                if ("content-type".equals(lhdr)) {
                    hasContent = true;
                }
                Enumeration vals = request.getHeaders(hdr);
                while (vals.hasMoreElements()) {
                    String val = (String)vals.nextElement();
                    if (val == null) continue;
                    connection.addRequestProperty(hdr, val);
                    xForwardedFor |= "X-Forwarded-For".equalsIgnoreCase(hdr);
                }
            }
            connection.setRequestProperty("Via", "1.1 (jetty)");
            if (!xForwardedFor) {
                connection.addRequestProperty("X-Forwarded-For", request.getRemoteAddr());
                connection.addRequestProperty("X-Forwarded-Proto", request.getScheme());
                connection.addRequestProperty("X-Forwarded-Host", request.getServerName());
                connection.addRequestProperty("X-Forwarded-Server", request.getLocalName());
            }
            if ((cache_control = request.getHeader("Cache-Control")) != null && (cache_control.indexOf("no-cache") >= 0 || cache_control.indexOf("no-store") >= 0)) {
                connection.setUseCaches(false);
            }
            try {
                connection.setDoInput(true);
                ServletInputStream in = request.getInputStream();
                if (hasContent) {
                    connection.setDoOutput(true);
                    IO.copy(in, connection.getOutputStream());
                }
                connection.connect();
            }
            catch (Exception e) {
                this._context.log("proxy", e);
            }
            InputStream proxy_in = null;
            int code = 500;
            if (http != null) {
                proxy_in = http.getErrorStream();
                code = http.getResponseCode();
                response.setStatus(code, http.getResponseMessage());
            }
            if (proxy_in == null) {
                try {
                    proxy_in = connection.getInputStream();
                }
                catch (Exception e) {
                    this._context.log("stream", e);
                    proxy_in = http.getErrorStream();
                }
            }
            response.setHeader("Date", null);
            response.setHeader("Server", null);
            int h = 0;
            String hdr = connection.getHeaderFieldKey(h);
            String val = connection.getHeaderField(h);
            while (hdr != null || val != null) {
                String lhdr;
                String string2 = lhdr = hdr != null ? hdr.toLowerCase() : null;
                if (hdr != null && val != null && !this._DontProxyHeaders.contains(lhdr)) {
                    response.addHeader(hdr, val);
                }
                hdr = connection.getHeaderFieldKey(++h);
                val = connection.getHeaderField(h);
            }
            response.addHeader("Via", "1.1 (jetty)");
            if (proxy_in != null) {
                IO.copy(proxy_in, response.getOutputStream());
            }
        }
    }

    protected URL proxyHttpURL(String scheme, String serverName, int serverPort, String uri) throws MalformedURLException {
        return new URL(scheme, serverName, serverPort, uri);
    }

    public void handleConnect(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String uri = request.getRequestURI();
        String port = "";
        String host = "";
        int c = uri.indexOf(58);
        if (c >= 0) {
            port = uri.substring(c + 1);
            host = uri.substring(0, c);
            if (host.indexOf(47) > 0) {
                host = host.substring(host.indexOf(47) + 1);
            }
        }
        InetSocketAddress inetAddress = new InetSocketAddress(host, Integer.parseInt(port));
        ServletInputStream in = request.getInputStream();
        ServletOutputStream out = response.getOutputStream();
        Socket socket = new Socket(inetAddress.getAddress(), inetAddress.getPort());
        response.setStatus(200);
        response.setHeader("Connection", "close");
        response.flushBuffer();
        IO.copyThread(socket.getInputStream(), out);
        IO.copy(in, socket.getOutputStream());
    }

    public String getServletInfo() {
        return "Proxy Servlet";
    }

    public void destroy() {
    }

    public static class Transparent
    extends ProxyServlet {
        String _prefix;
        String _proxyTo;

        public Transparent() {
        }

        public Transparent(String prefix, String server, int port) {
            this._prefix = prefix;
            this._proxyTo = "http://" + server + ":" + port;
        }

        public void init(ServletConfig config2) throws ServletException {
            if (config2.getInitParameter("ProxyTo") != null) {
                this._proxyTo = config2.getInitParameter("ProxyTo");
            }
            if (config2.getInitParameter("Prefix") != null) {
                this._prefix = config2.getInitParameter("Prefix");
            }
            if (this._proxyTo == null) {
                throw new UnavailableException("No ProxyTo");
            }
            super.init(config2);
            this._context.log("Transparent ProxyServlet @ " + (this._prefix == null ? "-" : this._prefix) + " to " + this._proxyTo);
        }

        protected URL proxyHttpURL(String scheme, String serverName, int serverPort, String uri) throws MalformedURLException {
            if (this._prefix != null && !uri.startsWith(this._prefix)) {
                return null;
            }
            if (this._prefix != null) {
                return new URL(this._proxyTo + uri.substring(this._prefix.length()));
            }
            return new URL(this._proxyTo + uri);
        }
    }
}

