/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.servlet;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.mortbay.util.LazyList;
import org.mortbay.util.MultiMap;
import org.mortbay.util.StringUtil;
import org.mortbay.util.TypeUtil;

public class MultiPartFilter
implements Filter {
    private static final String FILES = "org.mortbay.servlet.MultiPartFilter.files";
    private File tempdir;
    private boolean _deleteFiles;
    private ServletContext _context;
    private int _fileOutputBuffer = 0;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.tempdir = (File)filterConfig.getServletContext().getAttribute("javax.servlet.context.tempdir");
        this._deleteFiles = "true".equals(filterConfig.getInitParameter("deleteFiles"));
        String fileOutputBuffer = filterConfig.getInitParameter("fileOutputBuffer");
        if (fileOutputBuffer != null) {
            this._fileOutputBuffer = Integer.parseInt(fileOutputBuffer);
        }
        this._context = filterConfig.getServletContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain2) throws IOException, ServletException {
        HttpServletRequest srequest = (HttpServletRequest)request;
        if (srequest.getContentType() == null || !srequest.getContentType().startsWith("multipart/form-data")) {
            chain2.doFilter(request, response);
            return;
        }
        BufferedInputStream in = new BufferedInputStream(request.getInputStream());
        String content_type = srequest.getContentType();
        String boundary = "--" + this.value(content_type.substring(content_type.indexOf("boundary=")));
        byte[] byteBoundary = (boundary + "--").getBytes(StringUtil.__ISO_8859_1);
        MultiMap params2 = new MultiMap();
        Iterator i = request.getParameterMap().entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry2 = i.next();
            Object value2 = entry2.getValue();
            if (value2 instanceof String[]) {
                params2.addValues(entry2.getKey(), (String[])value2);
                continue;
            }
            params2.add(entry2.getKey(), value2);
        }
        try {
            String line;
            byte[] bytes2 = TypeUtil.readLine(in);
            String string2 = line = bytes2 == null ? null : new String(bytes2, "UTF-8");
            if (line == null || !line.equals(boundary)) {
                throw new IOException("Missing initial multi part boundary");
            }
            boolean lastPart = false;
            String content_disposition = null;
            block5: while (!lastPart) {
                while ((bytes2 = TypeUtil.readLine(in)) != null) {
                    Object var26_27;
                    if (bytes2.length != 0) {
                        line = new String(bytes2, "UTF-8");
                        int c = line.indexOf(58, 0);
                        if (c <= 0) continue;
                        String key = line.substring(0, c).trim().toLowerCase();
                        String value3 = line.substring(c + 1, line.length()).trim();
                        if (!key.equals("content-disposition")) continue;
                        content_disposition = value3;
                        continue;
                    }
                    boolean form_data = false;
                    if (content_disposition == null) {
                        throw new IOException("Missing content-disposition");
                    }
                    StringTokenizer tok = new StringTokenizer(content_disposition, ";");
                    String name2 = null;
                    String filename = null;
                    while (tok.hasMoreTokens()) {
                        String t = tok.nextToken().trim();
                        String tl = t.toLowerCase();
                        if (t.startsWith("form-data")) {
                            form_data = true;
                            continue;
                        }
                        if (tl.startsWith("name=")) {
                            name2 = this.value(t);
                            continue;
                        }
                        if (!tl.startsWith("filename=")) continue;
                        filename = this.value(t);
                    }
                    if (!form_data || name2 == null) continue block5;
                    OutputStream out = null;
                    File file = null;
                    try {
                        if (filename != null && filename.length() > 0) {
                            file = File.createTempFile("MultiPart", "", this.tempdir);
                            out = new FileOutputStream(file);
                            if (this._fileOutputBuffer > 0) {
                                out = new BufferedOutputStream(out, this._fileOutputBuffer);
                            }
                            request.setAttribute(name2, file);
                            params2.add(name2, filename);
                            if (this._deleteFiles) {
                                file.deleteOnExit();
                                ArrayList<File> files2 = (ArrayList<File>)request.getAttribute(FILES);
                                if (files2 == null) {
                                    files2 = new ArrayList<File>();
                                    request.setAttribute(FILES, files2);
                                }
                                files2.add(file);
                            }
                        } else {
                            out = new ByteArrayOutputStream();
                        }
                        int state = -2;
                        boolean cr = false;
                        boolean lf = false;
                        while (true) {
                            int c;
                            int b = 0;
                            while ((c = state != -2 ? state : in.read()) != -1) {
                                state = -2;
                                if (c == 13 || c == 10) {
                                    if (c != 13) break;
                                    state = in.read();
                                    break;
                                }
                                if (b >= 0 && b < byteBoundary.length && c == byteBoundary[b]) {
                                    ++b;
                                    continue;
                                }
                                if (cr) {
                                    out.write(13);
                                }
                                if (lf) {
                                    out.write(10);
                                }
                                lf = false;
                                cr = false;
                                if (b > 0) {
                                    out.write(byteBoundary, 0, b);
                                }
                                b = -1;
                                out.write(c);
                            }
                            if (b > 0 && b < byteBoundary.length - 2 || b == byteBoundary.length - 1) {
                                if (cr) {
                                    out.write(13);
                                }
                                if (lf) {
                                    out.write(10);
                                }
                                lf = false;
                                cr = false;
                                out.write(byteBoundary, 0, b);
                                b = -1;
                            }
                            if (b > 0 || c == -1) {
                                if (b == byteBoundary.length) {
                                    lastPart = true;
                                }
                                if (state != 10) break;
                                state = -2;
                                break;
                            }
                            if (cr) {
                                out.write(13);
                            }
                            if (lf) {
                                out.write(10);
                            }
                            cr = c == 13;
                            boolean bl = lf = c == 10 || state == 10;
                            if (state != 10) continue;
                            state = -2;
                        }
                        var26_27 = null;
                    }
                    catch (Throwable throwable2) {
                        var26_27 = null;
                        out.close();
                        throw throwable2;
                    }
                    out.close();
                    if (file != null) continue block5;
                    bytes2 = ((ByteArrayOutputStream)out).toByteArray();
                    params2.add(name2, bytes2);
                    continue block5;
                }
                break block5;
            }
            chain2.doFilter(new Wrapper(srequest, params2), response);
            Object var28_29 = null;
            this.deleteFiles(request);
        }
        catch (Throwable throwable3) {
            Object var28_30 = null;
            this.deleteFiles(request);
            throw throwable3;
        }
    }

    private void deleteFiles(ServletRequest request) {
        ArrayList files2 = (ArrayList)request.getAttribute(FILES);
        if (files2 != null) {
            Iterator iter2 = files2.iterator();
            while (iter2.hasNext()) {
                File file = (File)iter2.next();
                try {
                    file.delete();
                }
                catch (Exception e) {
                    this._context.log("failed to delete " + file, e);
                }
            }
        }
    }

    private String value(String nameEqualsValue) {
        String value2 = nameEqualsValue.substring(nameEqualsValue.indexOf(61) + 1).trim();
        int i = value2.indexOf(59);
        if (i > 0) {
            value2 = value2.substring(0, i);
        }
        if (value2.startsWith("\"")) {
            value2 = value2.substring(1, value2.indexOf(34, 1));
        } else {
            i = value2.indexOf(32);
            if (i > 0) {
                value2 = value2.substring(0, i);
            }
        }
        return value2;
    }

    public void destroy() {
    }

    private static class Wrapper
    extends HttpServletRequestWrapper {
        String encoding = "UTF-8";
        MultiMap map;

        public Wrapper(HttpServletRequest request, MultiMap map2) {
            super(request);
            this.map = map2;
        }

        public int getContentLength() {
            return 0;
        }

        public String getParameter(String name2) {
            Object o = this.map.get(name2);
            if (!(o instanceof byte[]) && LazyList.size(o) > 0) {
                o = LazyList.get(o, 0);
            }
            if (o instanceof byte[]) {
                try {
                    String s2 = new String((byte[])o, this.encoding);
                    return s2;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (o != null) {
                return String.valueOf(o);
            }
            return null;
        }

        public Map getParameterMap() {
            return Collections.unmodifiableMap(this.map.toStringArrayMap());
        }

        public Enumeration getParameterNames() {
            return Collections.enumeration(this.map.keySet());
        }

        public String[] getParameterValues(String name2) {
            List l = this.map.getValues(name2);
            if (l == null || l.size() == 0) {
                return new String[0];
            }
            String[] v = new String[l.size()];
            for (int i = 0; i < l.size(); ++i) {
                Object o = l.get(i);
                if (o instanceof byte[]) {
                    try {
                        v[i] = new String((byte[])o, this.encoding);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!(o instanceof String)) continue;
                v[i] = (String)o;
            }
            return v;
        }

        public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
            this.encoding = enc;
        }
    }
}

