/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.log.Log;
import org.mortbay.util.IO;
import org.mortbay.util.StringUtil;

public class CGI
extends HttpServlet {
    private boolean _ok;
    private File _docRoot;
    private String _path;
    private String _cmdPrefix;
    private EnvList _env;
    private boolean _ignoreExitState;

    public void init() throws ServletException {
        String os;
        this._env = new EnvList();
        this._cmdPrefix = this.getInitParameter("commandPrefix");
        String tmp = this.getInitParameter("cgibinResourceBase");
        if (tmp == null && (tmp = this.getInitParameter("resourceBase")) == null) {
            tmp = this.getServletContext().getRealPath("/");
        }
        if (tmp == null) {
            Log.warn("CGI: no CGI bin !");
            return;
        }
        File dir = new File(tmp);
        if (!dir.exists()) {
            Log.warn("CGI: CGI bin does not exist - " + dir);
            return;
        }
        if (!dir.canRead()) {
            Log.warn("CGI: CGI bin is not readable - " + dir);
            return;
        }
        if (!dir.isDirectory()) {
            Log.warn("CGI: CGI bin is not a directory - " + dir);
            return;
        }
        try {
            this._docRoot = dir.getCanonicalFile();
        }
        catch (IOException e) {
            Log.warn("CGI: CGI bin failed - " + dir, e);
            return;
        }
        this._path = this.getInitParameter("Path");
        if (this._path != null) {
            this._env.set("PATH", this._path);
        }
        this._ignoreExitState = "true".equalsIgnoreCase(this.getInitParameter("ignoreExitState"));
        Enumeration e = this.getInitParameterNames();
        while (e.hasMoreElements()) {
            String n = (String)e.nextElement();
            if (n == null || !n.startsWith("ENV_")) continue;
            this._env.set(n.substring(4), this.getInitParameter(n));
        }
        if (!this._env.envMap.containsKey("SystemRoot") && (os = System.getProperty("os.name")) != null && os.toLowerCase().indexOf("windows") != -1) {
            String windir = System.getProperty("windir");
            this._env.set("SystemRoot", windir != null ? windir : "C:\\WINDOWS");
        }
        this._ok = true;
    }

    public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String both;
        if (!this._ok) {
            res.sendError(503);
            return;
        }
        String pathInContext = StringUtil.nonNull(req.getServletPath()) + StringUtil.nonNull(req.getPathInfo());
        if (Log.isDebugEnabled()) {
            Log.debug("CGI: ContextPath : " + req.getContextPath());
            Log.debug("CGI: ServletPath : " + req.getServletPath());
            Log.debug("CGI: PathInfo    : " + req.getPathInfo());
            Log.debug("CGI: _docRoot    : " + this._docRoot);
            Log.debug("CGI: _path       : " + this._path);
            Log.debug("CGI: _ignoreExitState: " + this._ignoreExitState);
        }
        String first2 = both = pathInContext;
        String last2 = "";
        File exe = new File(this._docRoot, first2);
        while ((first2.endsWith("/") || !exe.exists()) && first2.length() >= 0) {
            int index2 = first2.lastIndexOf(47);
            first2 = first2.substring(0, index2);
            last2 = both.substring(index2, both.length());
            exe = new File(this._docRoot, first2);
        }
        if (first2.length() == 0 || !exe.exists() || exe.isDirectory() || !exe.getCanonicalPath().equals(exe.getAbsolutePath())) {
            res.sendError(404);
        } else {
            if (Log.isDebugEnabled()) {
                Log.debug("CGI: script is " + exe);
                Log.debug("CGI: pathInfo is " + last2);
            }
            this.exec(exe, last2, req, res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void exec(File command2, String pathInfo, HttpServletRequest req, HttpServletResponse res) throws IOException {
        block24: {
            OutputStream os;
            Process p;
            block23: {
                block22: {
                    int exitValue;
                    String path = command2.getAbsolutePath();
                    File dir = command2.getParentFile();
                    String scriptName = req.getRequestURI().substring(0, req.getRequestURI().length() - pathInfo.length());
                    String scriptPath = this.getServletContext().getRealPath(scriptName);
                    String pathTranslated = req.getPathTranslated();
                    int len = req.getContentLength();
                    if (len < 0) {
                        len = 0;
                    }
                    if (pathTranslated == null || pathTranslated.length() == 0) {
                        pathTranslated = path;
                    }
                    EnvList env = new EnvList(this._env);
                    env.set("AUTH_TYPE", req.getAuthType());
                    env.set("CONTENT_LENGTH", Integer.toString(len));
                    env.set("CONTENT_TYPE", req.getContentType());
                    env.set("GATEWAY_INTERFACE", "CGI/1.1");
                    if (pathInfo != null && pathInfo.length() > 0) {
                        env.set("PATH_INFO", pathInfo);
                    }
                    env.set("PATH_TRANSLATED", pathTranslated);
                    env.set("QUERY_STRING", req.getQueryString());
                    env.set("REMOTE_ADDR", req.getRemoteAddr());
                    env.set("REMOTE_HOST", req.getRemoteHost());
                    env.set("REMOTE_USER", req.getRemoteUser());
                    env.set("REQUEST_METHOD", req.getMethod());
                    env.set("SCRIPT_NAME", scriptName);
                    env.set("SCRIPT_FILENAME", scriptPath);
                    env.set("SERVER_NAME", req.getServerName());
                    env.set("SERVER_PORT", Integer.toString(req.getServerPort()));
                    env.set("SERVER_PROTOCOL", req.getProtocol());
                    env.set("SERVER_SOFTWARE", this.getServletContext().getServerInfo());
                    Enumeration enm = req.getHeaderNames();
                    while (enm.hasMoreElements()) {
                        String name2 = (String)enm.nextElement();
                        String value2 = req.getHeader(name2);
                        env.set("HTTP_" + name2.toUpperCase().replace('-', '_'), value2);
                    }
                    env.set("HTTPS", req.isSecure() ? "ON" : "OFF");
                    String execCmd = path;
                    if (execCmd.charAt(0) != '\"' && execCmd.indexOf(" ") >= 0) {
                        execCmd = "\"" + execCmd + "\"";
                    }
                    if (this._cmdPrefix != null) {
                        execCmd = this._cmdPrefix + " " + execCmd;
                    }
                    p = dir == null ? Runtime.getRuntime().exec(execCmd, env.getEnvArray()) : Runtime.getRuntime().exec(execCmd, env.getEnvArray(), dir);
                    final ServletInputStream inFromReq = req.getInputStream();
                    final OutputStream outToCgi = p.getOutputStream();
                    final int inLength = len;
                    IO.copyThread(p.getErrorStream(), System.err);
                    new Thread(new Runnable(){

                        public void run() {
                            try {
                                if (inLength > 0) {
                                    IO.copy(inFromReq, outToCgi, (long)inLength);
                                }
                                outToCgi.close();
                            }
                            catch (IOException e) {
                                Log.ignore(e);
                            }
                        }
                    }).start();
                    os = null;
                    String line = null;
                    InputStream inFromCgi = p.getInputStream();
                    while ((line = this.getTextLineFromStream(inFromCgi)).length() > 0) {
                        int k;
                        if (line.startsWith("HTTP") || (k = line.indexOf(58)) <= 0) continue;
                        String key = line.substring(0, k).trim();
                        String value3 = line.substring(k + 1).trim();
                        if ("Location".equals(key)) {
                            res.sendRedirect(value3);
                            continue;
                        }
                        if ("Status".equals(key)) {
                            String[] token2 = value3.split(" ");
                            int status = Integer.parseInt(token2[0]);
                            res.setStatus(status);
                            continue;
                        }
                        res.addHeader(key, value3);
                    }
                    os = res.getOutputStream();
                    IO.copy(inFromCgi, os);
                    p.waitFor();
                    if (this._ignoreExitState || 0 == (exitValue = p.exitValue())) break block22;
                    Log.warn("Non-zero exit status (" + exitValue + ") from CGI program: " + path);
                    if (res.isCommitted()) break block22;
                    res.sendError(500, "Failed to exec CGI");
                }
                Object var27_28 = null;
                if (os == null) break block23;
                try {
                    os.close();
                }
                catch (Exception e2) {
                    Log.ignore(e2);
                }
            }
            os = null;
            p.destroy();
            {
                break block24;
                catch (IOException e) {
                    Log.debug("CGI: Client closed connection!");
                    Object var27_29 = null;
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Exception e2) {
                            Log.ignore(e2);
                        }
                    }
                    os = null;
                    p.destroy();
                    break block24;
                }
                catch (InterruptedException ie) {
                    Log.debug("CGI: interrupted!");
                    Object var27_30 = null;
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Exception e2) {
                            Log.ignore(e2);
                        }
                    }
                    os = null;
                    p.destroy();
                }
            }
            catch (Throwable throwable2) {
                Object var27_31 = null;
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (Exception e2) {
                        Log.ignore(e2);
                    }
                }
                os = null;
                p.destroy();
                throw throwable2;
            }
        }
    }

    private String getTextLineFromStream(InputStream is) throws IOException {
        int b;
        StringBuffer buffer2 = new StringBuffer();
        while ((b = is.read()) != -1 && b != 10) {
            buffer2.append((char)b);
        }
        return buffer2.toString().trim();
    }

    private static class EnvList {
        private Map envMap;

        EnvList() {
            this.envMap = new HashMap();
        }

        EnvList(EnvList l) {
            this.envMap = new HashMap(l.envMap);
        }

        public void set(String name2, String value2) {
            this.envMap.put(name2, name2 + "=" + StringUtil.nonNull(value2));
        }

        public String[] getEnvArray() {
            return this.envMap.values().toArray(new String[this.envMap.size()]);
        }

        public String toString() {
            return this.envMap.toString();
        }
    }
}

