/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.resource;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.mortbay.log.Log;
import org.mortbay.resource.Resource;
import org.mortbay.resource.URLResource;
import org.mortbay.util.IO;
import org.mortbay.util.URIUtil;

public class JarResource
extends URLResource {
    protected transient JarURLConnection _jarConnection;

    JarResource(URL url) {
        super(url, null);
    }

    JarResource(URL url, boolean useCaches) {
        super(url, null, useCaches);
    }

    public synchronized void release() {
        this._jarConnection = null;
        super.release();
    }

    protected boolean checkConnection() {
        super.checkConnection();
        try {
            if (this._jarConnection != this._connection) {
                this.newConnection();
            }
        }
        catch (IOException e) {
            Log.ignore(e);
            this._jarConnection = null;
        }
        return this._jarConnection != null;
    }

    protected void newConnection() throws IOException {
        this._jarConnection = (JarURLConnection)this._connection;
    }

    public boolean exists() {
        if (this._urlString.endsWith("!/")) {
            return this.checkConnection();
        }
        return super.exists();
    }

    public File getFile() throws IOException {
        return null;
    }

    public InputStream getInputStream() throws IOException {
        this.checkConnection();
        if (!this._urlString.endsWith("!/")) {
            return new FilterInputStream(super.getInputStream()){

                public void close() throws IOException {
                    this.in = IO.getClosedStream();
                }
            };
        }
        URL url = new URL(this._urlString.substring(4, this._urlString.length() - 2));
        InputStream is = url.openStream();
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extract(Resource resource, File directory, boolean deleteOnExit) throws IOException {
        Manifest manifest2;
        JarEntry entry2;
        boolean subEntryIsDir;
        String urlString;
        int endOfJarUrl;
        int startOfJarUrl;
        if (Log.isDebugEnabled()) {
            Log.debug("Extract " + resource + " to " + directory);
        }
        int n = startOfJarUrl = (endOfJarUrl = (urlString = resource.getURL().toExternalForm().trim()).indexOf("!/")) >= 0 ? 4 : 0;
        if (endOfJarUrl < 0) {
            throw new IOException("Not a valid jar url: " + urlString);
        }
        URL jarFileURL = new URL(urlString.substring(startOfJarUrl, endOfJarUrl));
        String subEntryName = endOfJarUrl + 2 < urlString.length() ? urlString.substring(endOfJarUrl + 2) : null;
        boolean bl = subEntryIsDir = subEntryName != null && subEntryName.endsWith("/");
        if (Log.isDebugEnabled()) {
            Log.debug("Extracting entry = " + subEntryName + " from jar " + jarFileURL);
        }
        InputStream is = jarFileURL.openConnection().getInputStream();
        JarInputStream jin = new JarInputStream(is);
        String directoryCanonicalPath = directory.getCanonicalPath() + "/";
        while ((entry2 = jin.getNextJarEntry()) != null) {
            String entryName = entry2.getName();
            boolean shouldExtract = subEntryName != null && entryName.startsWith(subEntryName) ? (subEntryIsDir ? !(entryName = entryName.substring(subEntryName.length())).equals("") : true) : subEntryName == null || entryName.startsWith(subEntryName);
            if (!shouldExtract) {
                if (!Log.isDebugEnabled()) continue;
                Log.debug("Skipping entry: " + entryName);
                continue;
            }
            String dotCheck = entryName.replace('\\', '/');
            if ((dotCheck = URIUtil.canonicalPath(dotCheck)) == null) {
                if (!Log.isDebugEnabled()) continue;
                Log.debug("Invalid entry: " + entryName);
                continue;
            }
            File file = new File(directory, entryName);
            if (entry2.isDirectory()) {
                if (!file.exists()) {
                    file.mkdirs();
                }
            } else {
                Object var20_19;
                File dir = new File(file.getParent());
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                FileOutputStream fout = null;
                try {
                    fout = new FileOutputStream(file);
                    IO.copy(jin, fout);
                    var20_19 = null;
                }
                catch (Throwable throwable2) {
                    var20_19 = null;
                    IO.close(fout);
                    throw throwable2;
                }
                IO.close(fout);
                if (entry2.getTime() >= 0L) {
                    file.setLastModified(entry2.getTime());
                }
            }
            if (!deleteOnExit) continue;
            file.deleteOnExit();
        }
        if ((subEntryName == null || subEntryName != null && subEntryName.equalsIgnoreCase("META-INF/MANIFEST.MF")) && (manifest2 = jin.getManifest()) != null) {
            File metaInf = new File(directory, "META-INF");
            metaInf.mkdir();
            File f2 = new File(metaInf, "MANIFEST.MF");
            FileOutputStream fout = new FileOutputStream(f2);
            manifest2.write(fout);
            fout.close();
        }
        IO.close(jin);
    }

    public void extract(File directory, boolean deleteOnExit) throws IOException {
        JarResource.extract(this, directory, deleteOnExit);
    }
}

