/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.log.Log;
import org.mortbay.resource.Resource;
import org.mortbay.util.IO;
import org.mortbay.util.LazyList;
import org.mortbay.util.StringUtil;

public class WebAppClassLoader
extends URLClassLoader {
    private String _name;
    private WebAppContext _context;
    private ClassLoader _parent = this.getParent();
    private HashSet _extensions;

    public WebAppClassLoader(WebAppContext context) throws IOException {
        this(null, context);
    }

    public WebAppClassLoader(ClassLoader parent, WebAppContext context) throws IOException {
        super(new URL[]{}, parent != null ? parent : (Thread.currentThread().getContextClassLoader() != null ? Thread.currentThread().getContextClassLoader() : (WebAppClassLoader.class.getClassLoader() != null ? WebAppClassLoader.class.getClassLoader() : ClassLoader.getSystemClassLoader())));
        this._context = context;
        if (this._parent == null) {
            throw new IllegalArgumentException("no parent classloader!");
        }
        this._extensions = new HashSet();
        this._extensions.add(".jar");
        this._extensions.add(".zip");
        String extensions = System.getProperty(WebAppClassLoader.class.getName() + ".extensions");
        if (extensions != null) {
            StringTokenizer tokenizer = new StringTokenizer(extensions, ",;");
            while (tokenizer.hasMoreTokens()) {
                this._extensions.add(tokenizer.nextToken().trim());
            }
        }
        if (context.getExtraClasspath() != null) {
            this.addClassPath(context.getExtraClasspath());
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name2) {
        this._name = name2;
    }

    public ContextHandler getContext() {
        return this._context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClassPath(String classPath) throws IOException {
        if (classPath == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(classPath, ",;");
        while (tokenizer.hasMoreTokens()) {
            URL url;
            Resource resource;
            block9: {
                File lib;
                File file;
                resource = Resource.newResource(tokenizer.nextToken());
                if (Log.isDebugEnabled()) {
                    Log.debug("Path resource=" + resource);
                }
                if ((file = resource.getFile()) != null) {
                    url = resource.getURL();
                    this.addURL(url);
                    continue;
                }
                if (resource.isDirectory() || file != null) break block9;
                InputStream in = resource.getInputStream();
                File tmp_dir = this._context.getTempDirectory();
                if (tmp_dir == null) {
                    tmp_dir = File.createTempFile("jetty.cl.lib", null);
                    tmp_dir.mkdir();
                    tmp_dir.deleteOnExit();
                }
                if (!(lib = new File(tmp_dir, "lib")).exists()) {
                    lib.mkdir();
                    lib.deleteOnExit();
                }
                File jar = File.createTempFile("Jetty-", ".jar", lib);
                jar.deleteOnExit();
                if (Log.isDebugEnabled()) {
                    Log.debug("Extract " + resource + " to " + jar);
                }
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(jar);
                    IO.copy(in, out);
                }
                catch (Throwable throwable2) {
                    IO.close(out);
                    throw throwable2;
                }
                IO.close(out);
                URL url2 = jar.toURL();
                this.addURL(url2);
                continue;
            }
            url = resource.getURL();
            this.addURL(url);
        }
    }

    private boolean isFileSupported(String file) {
        int dot2 = file.lastIndexOf(46);
        return dot2 != -1 && this._extensions.contains(file.substring(dot2));
    }

    public void addJars(Resource lib) {
        if (lib.exists() && lib.isDirectory()) {
            String[] files2 = lib.list();
            for (int f2 = 0; files2 != null && f2 < files2.length; ++f2) {
                try {
                    Resource fn2 = lib.addPath(files2[f2]);
                    String fnlc = fn2.getName().toLowerCase();
                    if (!this.isFileSupported(fnlc)) continue;
                    String jar = fn2.toString();
                    jar = StringUtil.replace(jar, ",", "%2C");
                    jar = StringUtil.replace(jar, ";", "%3B");
                    this.addClassPath(jar);
                    continue;
                }
                catch (Exception ex) {
                    Log.warn("EXCEPTION ", ex);
                }
            }
        }
    }

    public void destroy() {
        this._parent = null;
    }

    public PermissionCollection getPermissions(CodeSource cs) {
        PermissionCollection permissions = this._context.getPermissions();
        PermissionCollection pc = permissions == null ? super.getPermissions(cs) : permissions;
        return pc;
    }

    public URL getResource(String name2) {
        URL url = null;
        boolean tried_parent = false;
        if (this._context.isParentLoaderPriority() || this.isSystemPath(name2)) {
            tried_parent = true;
            if (this._parent != null) {
                url = this._parent.getResource(name2);
            }
        }
        if (url == null && (url = this.findResource(name2)) == null && name2.startsWith("/")) {
            if (Log.isDebugEnabled()) {
                Log.debug("HACK leading / off " + name2);
            }
            url = this.findResource(name2.substring(1));
        }
        if (url == null && !tried_parent && this._parent != null) {
            url = this._parent.getResource(name2);
        }
        if (url != null && Log.isDebugEnabled()) {
            Log.debug("getResource(" + name2 + ")=" + url);
        }
        return url;
    }

    public boolean isServerPath(String name2) {
        name2 = name2.replace('/', '.');
        while (name2.startsWith(".")) {
            name2 = name2.substring(1);
        }
        String[] server_classes = this._context.getServerClasses();
        if (server_classes != null) {
            for (int i = 0; i < server_classes.length; ++i) {
                boolean result2 = true;
                String c = server_classes[i];
                if (c.startsWith("-")) {
                    c = c.substring(1);
                    result2 = false;
                }
                if (!(c.endsWith(".") ? name2.startsWith(c) : name2.equals(c))) continue;
                return result2;
            }
        }
        return false;
    }

    public boolean isSystemPath(String name2) {
        name2 = name2.replace('/', '.');
        while (name2.startsWith(".")) {
            name2 = name2.substring(1);
        }
        String[] system_classes = this._context.getSystemClasses();
        if (system_classes != null) {
            for (int i = 0; i < system_classes.length; ++i) {
                boolean result2 = true;
                String c = system_classes[i];
                if (c.startsWith("-")) {
                    c = c.substring(1);
                    result2 = false;
                }
                if (!(c.endsWith(".") ? name2.startsWith(c) : name2.equals(c))) continue;
                return result2;
            }
        }
        return false;
    }

    public Class loadClass(String name2) throws ClassNotFoundException {
        return this.loadClass(name2, false);
    }

    protected synchronized Class loadClass(String name2, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name2);
        ClassNotFoundException ex = null;
        boolean tried_parent = false;
        if (c == null && this._parent != null && (this._context.isParentLoaderPriority() || this.isSystemPath(name2))) {
            tried_parent = true;
            try {
                c = this._parent.loadClass(name2);
                if (Log.isDebugEnabled()) {
                    Log.debug("loaded " + c);
                }
            }
            catch (ClassNotFoundException e) {
                ex = e;
            }
        }
        if (c == null) {
            try {
                c = this.findClass(name2);
            }
            catch (ClassNotFoundException e) {
                ex = e;
            }
        }
        if (c == null && this._parent != null && !tried_parent && !this.isServerPath(name2)) {
            c = this._parent.loadClass(name2);
        }
        if (c == null) {
            throw ex;
        }
        if (resolve) {
            this.resolveClass(c);
        }
        if (Log.isDebugEnabled()) {
            Log.debug("loaded " + c + " from " + c.getClassLoader());
        }
        return c;
    }

    public String toString() {
        if (Log.isDebugEnabled()) {
            return "ContextLoader@" + this._name + "(" + LazyList.array2List(this.getURLs()) + ") / " + this._parent;
        }
        return "ContextLoader@" + this._name;
    }
}

