/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.util.Attributes;
import org.mortbay.util.LazyList;
import org.mortbay.util.MultiMap;
import org.mortbay.util.UrlEncoded;

public class Dispatcher
implements RequestDispatcher {
    public static final String __INCLUDE_JETTY = "org.mortbay.jetty.included";
    public static final String __INCLUDE_PREFIX = "javax.servlet.include.";
    public static final String __INCLUDE_REQUEST_URI = "javax.servlet.include.request_uri";
    public static final String __INCLUDE_CONTEXT_PATH = "javax.servlet.include.context_path";
    public static final String __INCLUDE_SERVLET_PATH = "javax.servlet.include.servlet_path";
    public static final String __INCLUDE_PATH_INFO = "javax.servlet.include.path_info";
    public static final String __INCLUDE_QUERY_STRING = "javax.servlet.include.query_string";
    public static final String __FORWARD_JETTY = "org.mortbay.jetty.forwarded";
    public static final String __FORWARD_PREFIX = "javax.servlet.forward.";
    public static final String __FORWARD_REQUEST_URI = "javax.servlet.forward.request_uri";
    public static final String __FORWARD_CONTEXT_PATH = "javax.servlet.forward.context_path";
    public static final String __FORWARD_SERVLET_PATH = "javax.servlet.forward.servlet_path";
    public static final String __FORWARD_PATH_INFO = "javax.servlet.forward.path_info";
    public static final String __FORWARD_QUERY_STRING = "javax.servlet.forward.query_string";
    public static final String __JSP_FILE = "org.apache.catalina.jsp_file";
    private ContextHandler _contextHandler;
    private String _uri;
    private String _path;
    private String _dQuery;
    private String _named;

    public static int type(String type) {
        if ("request".equalsIgnoreCase(type)) {
            return 1;
        }
        if ("forward".equalsIgnoreCase(type)) {
            return 2;
        }
        if ("include".equalsIgnoreCase(type)) {
            return 4;
        }
        if ("error".equalsIgnoreCase(type)) {
            return 8;
        }
        throw new IllegalArgumentException(type);
    }

    public Dispatcher(ContextHandler contextHandler, String uri, String pathInContext, String query) {
        this._contextHandler = contextHandler;
        this._uri = uri;
        this._path = pathInContext;
        this._dQuery = query;
    }

    public Dispatcher(ContextHandler contextHandler, String name2) throws IllegalStateException {
        this._contextHandler = contextHandler;
        this._named = name2;
    }

    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.forward(request, response, 2);
    }

    public void error(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.forward(request, response, 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        Request base_request = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
        request.removeAttribute(__JSP_FILE);
        Attributes old_attr = base_request.getAttributes();
        MultiMap old_params = base_request.getParameters();
        try {
            base_request.getConnection().include();
            if (this._named != null) {
                this._contextHandler.handle(this._named, (HttpServletRequest)request, (HttpServletResponse)response, 4);
            } else {
                String query = this._dQuery;
                if (query != null) {
                    MultiMap parameters = new MultiMap();
                    UrlEncoded.decodeTo(query, parameters, request.getCharacterEncoding());
                    if (old_params != null && old_params.size() > 0) {
                        Iterator iter2 = old_params.entrySet().iterator();
                        while (iter2.hasNext()) {
                            Map.Entry entry2 = iter2.next();
                            String name2 = (String)entry2.getKey();
                            Object values2 = entry2.getValue();
                            for (int i = 0; i < LazyList.size(values2); ++i) {
                                parameters.add(name2, LazyList.get(values2, i));
                            }
                        }
                    }
                    base_request.setParameters(parameters);
                }
                IncludeAttributes attr = new IncludeAttributes(old_attr);
                attr._requestURI = this._uri;
                attr._contextPath = this._contextHandler.getContextPath();
                attr._servletPath = null;
                attr._pathInfo = this._path;
                attr._query = query;
                base_request.setAttributes(attr);
                this._contextHandler.handle(this._named == null ? this._path : this._named, (HttpServletRequest)request, (HttpServletResponse)response, 4);
            }
        }
        finally {
            base_request.setAttributes(old_attr);
            base_request.getConnection().included();
            base_request.setParameters(old_params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forward(ServletRequest request, ServletResponse response, int dispatch2) throws ServletException, IOException {
        Request base_request = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
        response.resetBuffer();
        request.removeAttribute(__JSP_FILE);
        String old_uri = base_request.getRequestURI();
        String old_context_path = base_request.getContextPath();
        String old_servlet_path = base_request.getServletPath();
        String old_path_info = base_request.getPathInfo();
        String old_query = base_request.getQueryString();
        Attributes old_attr = base_request.getAttributes();
        MultiMap old_params = base_request.getParameters();
        try {
            if (this._named != null) {
                this._contextHandler.handle(this._named, (HttpServletRequest)request, (HttpServletResponse)response, dispatch2);
            } else {
                String query = this._dQuery;
                if (query != null) {
                    MultiMap parameters = new MultiMap();
                    UrlEncoded.decodeTo(query, parameters, request.getCharacterEncoding());
                    boolean rewrite_old_query = false;
                    if (old_params == null) {
                        base_request.getParameterNames();
                        old_params = base_request.getParameters();
                    }
                    if (old_params != null && old_params.size() > 0) {
                        Iterator iter2 = old_params.entrySet().iterator();
                        while (iter2.hasNext()) {
                            Map.Entry entry2 = iter2.next();
                            String name2 = (String)entry2.getKey();
                            if (parameters.containsKey(name2)) {
                                rewrite_old_query = true;
                            }
                            Object values2 = entry2.getValue();
                            for (int i = 0; i < LazyList.size(values2); ++i) {
                                parameters.add(name2, LazyList.get(values2, i));
                            }
                        }
                    }
                    if (old_query != null && old_query.length() > 0) {
                        if (rewrite_old_query) {
                            StringBuffer overridden_query_string = new StringBuffer();
                            MultiMap overridden_old_query = new MultiMap();
                            UrlEncoded.decodeTo(old_query, overridden_old_query, request.getCharacterEncoding());
                            MultiMap overridden_new_query = new MultiMap();
                            UrlEncoded.decodeTo(query, overridden_new_query, request.getCharacterEncoding());
                            Iterator iter3 = overridden_old_query.entrySet().iterator();
                            while (iter3.hasNext()) {
                                Map.Entry entry3 = iter3.next();
                                String name3 = (String)entry3.getKey();
                                if (overridden_new_query.containsKey(name3)) continue;
                                Object values3 = entry3.getValue();
                                for (int i = 0; i < LazyList.size(values3); ++i) {
                                    overridden_query_string.append("&" + name3 + "=" + LazyList.get(values3, i));
                                }
                            }
                            query = query + overridden_query_string;
                        } else {
                            query = query + "&" + old_query;
                        }
                    }
                    base_request.setParameters(parameters);
                    base_request.setQueryString(query);
                }
                ForwardAttributes attr = new ForwardAttributes(old_attr);
                if ((String)old_attr.getAttribute(__FORWARD_REQUEST_URI) != null) {
                    attr._pathInfo = (String)old_attr.getAttribute(__FORWARD_PATH_INFO);
                    attr._query = (String)old_attr.getAttribute(__FORWARD_QUERY_STRING);
                    attr._requestURI = (String)old_attr.getAttribute(__FORWARD_REQUEST_URI);
                    attr._contextPath = (String)old_attr.getAttribute(__FORWARD_CONTEXT_PATH);
                    attr._servletPath = (String)old_attr.getAttribute(__FORWARD_SERVLET_PATH);
                } else {
                    attr._pathInfo = old_path_info;
                    attr._query = old_query;
                    attr._requestURI = old_uri;
                    attr._contextPath = old_context_path;
                    attr._servletPath = old_servlet_path;
                }
                base_request.setRequestURI(this._uri);
                base_request.setContextPath(this._contextHandler.getContextPath());
                base_request.setAttributes(attr);
                base_request.setQueryString(query);
                this._contextHandler.handle(this._path, (HttpServletRequest)request, (HttpServletResponse)response, dispatch2);
                if (base_request.getConnection().getResponse().isWriting()) {
                    try {
                        response.getWriter().close();
                    }
                    catch (IllegalStateException e) {
                        response.getOutputStream().close();
                    }
                } else {
                    try {
                        response.getOutputStream().close();
                    }
                    catch (IllegalStateException e) {
                        response.getWriter().close();
                    }
                }
            }
        }
        finally {
            base_request.setRequestURI(old_uri);
            base_request.setContextPath(old_context_path);
            base_request.setServletPath(old_servlet_path);
            base_request.setPathInfo(old_path_info);
            base_request.setAttributes(old_attr);
            base_request.setParameters(old_params);
            base_request.setQueryString(old_query);
        }
    }

    private class IncludeAttributes
    implements Attributes {
        Attributes _attr;
        String _requestURI;
        String _contextPath;
        String _servletPath;
        String _pathInfo;
        String _query;

        IncludeAttributes(Attributes attributes) {
            this._attr = attributes;
        }

        public Object getAttribute(String key) {
            if (Dispatcher.this._named == null) {
                if (key.equals(Dispatcher.__INCLUDE_PATH_INFO)) {
                    return this._pathInfo;
                }
                if (key.equals(Dispatcher.__INCLUDE_SERVLET_PATH)) {
                    return this._servletPath;
                }
                if (key.equals(Dispatcher.__INCLUDE_CONTEXT_PATH)) {
                    return this._contextPath;
                }
                if (key.equals(Dispatcher.__INCLUDE_QUERY_STRING)) {
                    return this._query;
                }
                if (key.equals(Dispatcher.__INCLUDE_REQUEST_URI)) {
                    return this._requestURI;
                }
            } else if (key.startsWith(Dispatcher.__INCLUDE_PREFIX)) {
                return null;
            }
            if (key.equals(Dispatcher.__INCLUDE_JETTY)) {
                return Boolean.TRUE;
            }
            return this._attr.getAttribute(key);
        }

        public Enumeration getAttributeNames() {
            HashSet<String> set2 = new HashSet<String>();
            Enumeration e = this._attr.getAttributeNames();
            while (e.hasMoreElements()) {
                String name2 = (String)e.nextElement();
                if (name2.startsWith(Dispatcher.__INCLUDE_PREFIX)) continue;
                set2.add(name2);
            }
            if (Dispatcher.this._named == null) {
                if (this._pathInfo != null) {
                    set2.add(Dispatcher.__INCLUDE_PATH_INFO);
                } else {
                    set2.remove(Dispatcher.__INCLUDE_PATH_INFO);
                }
                set2.add(Dispatcher.__INCLUDE_REQUEST_URI);
                set2.add(Dispatcher.__INCLUDE_SERVLET_PATH);
                set2.add(Dispatcher.__INCLUDE_CONTEXT_PATH);
                if (this._query != null) {
                    set2.add(Dispatcher.__INCLUDE_QUERY_STRING);
                } else {
                    set2.remove(Dispatcher.__INCLUDE_QUERY_STRING);
                }
            }
            return Collections.enumeration(set2);
        }

        public void setAttribute(String key, Object value2) {
            if (Dispatcher.this._named == null && key.startsWith("javax.servlet.")) {
                if (key.equals(Dispatcher.__INCLUDE_PATH_INFO)) {
                    this._pathInfo = (String)value2;
                } else if (key.equals(Dispatcher.__INCLUDE_REQUEST_URI)) {
                    this._requestURI = (String)value2;
                } else if (key.equals(Dispatcher.__INCLUDE_SERVLET_PATH)) {
                    this._servletPath = (String)value2;
                } else if (key.equals(Dispatcher.__INCLUDE_CONTEXT_PATH)) {
                    this._contextPath = (String)value2;
                } else if (key.equals(Dispatcher.__INCLUDE_QUERY_STRING)) {
                    this._query = (String)value2;
                } else if (value2 == null) {
                    this._attr.removeAttribute(key);
                } else {
                    this._attr.setAttribute(key, value2);
                }
            } else if (value2 == null) {
                this._attr.removeAttribute(key);
            } else {
                this._attr.setAttribute(key, value2);
            }
        }

        public String toString() {
            return "INCLUDE+" + this._attr.toString();
        }

        public void clearAttributes() {
            throw new IllegalStateException();
        }

        public void removeAttribute(String name2) {
            this.setAttribute(name2, null);
        }
    }

    private class ForwardAttributes
    implements Attributes {
        Attributes _attr;
        String _requestURI;
        String _contextPath;
        String _servletPath;
        String _pathInfo;
        String _query;

        ForwardAttributes(Attributes attributes) {
            this._attr = attributes;
        }

        public Object getAttribute(String key) {
            if (Dispatcher.this._named == null) {
                if (key.equals(Dispatcher.__FORWARD_PATH_INFO)) {
                    return this._pathInfo;
                }
                if (key.equals(Dispatcher.__FORWARD_REQUEST_URI)) {
                    return this._requestURI;
                }
                if (key.equals(Dispatcher.__FORWARD_SERVLET_PATH)) {
                    return this._servletPath;
                }
                if (key.equals(Dispatcher.__FORWARD_CONTEXT_PATH)) {
                    return this._contextPath;
                }
                if (key.equals(Dispatcher.__FORWARD_QUERY_STRING)) {
                    return this._query;
                }
            }
            if (key.startsWith(Dispatcher.__INCLUDE_PREFIX) || key.equals(Dispatcher.__INCLUDE_JETTY)) {
                return null;
            }
            if (key.equals(Dispatcher.__FORWARD_JETTY)) {
                return Boolean.TRUE;
            }
            return this._attr.getAttribute(key);
        }

        public Enumeration getAttributeNames() {
            HashSet<String> set2 = new HashSet<String>();
            Enumeration e = this._attr.getAttributeNames();
            while (e.hasMoreElements()) {
                String name2 = (String)e.nextElement();
                if (name2.startsWith(Dispatcher.__INCLUDE_PREFIX) || name2.startsWith(Dispatcher.__FORWARD_PREFIX)) continue;
                set2.add(name2);
            }
            if (Dispatcher.this._named == null) {
                if (this._pathInfo != null) {
                    set2.add(Dispatcher.__FORWARD_PATH_INFO);
                } else {
                    set2.remove(Dispatcher.__FORWARD_PATH_INFO);
                }
                set2.add(Dispatcher.__FORWARD_REQUEST_URI);
                set2.add(Dispatcher.__FORWARD_SERVLET_PATH);
                set2.add(Dispatcher.__FORWARD_CONTEXT_PATH);
                if (this._query != null) {
                    set2.add(Dispatcher.__FORWARD_QUERY_STRING);
                } else {
                    set2.remove(Dispatcher.__FORWARD_QUERY_STRING);
                }
            }
            return Collections.enumeration(set2);
        }

        public void setAttribute(String key, Object value2) {
            if (Dispatcher.this._named == null && key.startsWith("javax.servlet.")) {
                if (key.equals(Dispatcher.__FORWARD_PATH_INFO)) {
                    this._pathInfo = (String)value2;
                } else if (key.equals(Dispatcher.__FORWARD_REQUEST_URI)) {
                    this._requestURI = (String)value2;
                } else if (key.equals(Dispatcher.__FORWARD_SERVLET_PATH)) {
                    this._servletPath = (String)value2;
                } else if (key.equals(Dispatcher.__FORWARD_CONTEXT_PATH)) {
                    this._contextPath = (String)value2;
                } else if (key.equals(Dispatcher.__FORWARD_QUERY_STRING)) {
                    this._query = (String)value2;
                } else if (value2 == null) {
                    this._attr.removeAttribute(key);
                } else {
                    this._attr.setAttribute(key, value2);
                }
            } else if (value2 == null) {
                this._attr.removeAttribute(key);
            } else {
                this._attr.setAttribute(key, value2);
            }
        }

        public String toString() {
            return "FORWARD+" + this._attr.toString();
        }

        public void clearAttributes() {
            throw new IllegalStateException();
        }

        public void removeAttribute(String name2) {
            this.setAttribute(name2, null);
        }
    }
}

