/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.handler;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.RetryRequest;
import org.mortbay.jetty.handler.HandlerWrapper;
import org.mortbay.util.DateCache;
import org.mortbay.util.RolloverFileOutputStream;

public class DebugHandler
extends HandlerWrapper {
    private DateCache _date = new DateCache("HH:mm:ss", Locale.US);
    private OutputStream _out;
    private PrintStream _print;

    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch2) throws IOException, ServletException {
        Request srequest = (Request)request;
        Response sresponse = (Response)response;
        Thread thread = Thread.currentThread();
        String old_name = thread.getName();
        boolean suspend = false;
        boolean retry = false;
        String name2 = (String)request.getAttribute("org.mortbay.jetty.thread.name");
        if (name2 == null) {
            name2 = old_name + "://" + srequest.getHeader("Host") + srequest.getUri();
        } else {
            retry = true;
        }
        String ex = null;
        try {
            try {
                String d = this._date.now();
                int ms = this._date.lastMs();
                if (retry) {
                    this._print.println(d + (ms > 99 ? "." : (ms > 9 ? ".0" : ".00")) + ms + ":" + name2 + " RETRY");
                } else {
                    this._print.println(d + (ms > 99 ? "." : (ms > 9 ? ".0" : ".00")) + ms + ":" + name2 + " " + srequest.getRemoteAddr() + " " + request.getMethod() + " " + srequest.getHeader("Cookie") + "; " + srequest.getHeader("User-Agent"));
                }
                thread.setName(name2);
                super.handle(target, request, response, dispatch2);
            }
            catch (RetryRequest r) {
                suspend = true;
                request.setAttribute("org.mortbay.jetty.thread.name", name2);
                throw r;
            }
            catch (IOException ioe) {
                ex = ioe.toString();
                throw ioe;
            }
            catch (ServletException se) {
                ex = se.toString() + ":" + se.getCause();
                throw se;
            }
            catch (RuntimeException rte) {
                ex = rte.toString();
                throw rte;
            }
            catch (Error e) {
                ex = e.toString();
                throw e;
            }
            Object var16_20 = null;
            thread.setName(old_name);
            String d = this._date.now();
            int ms = this._date.lastMs();
            if (suspend) {
                this._print.println(d + (ms > 99 ? "." : (ms > 9 ? ".0" : ".00")) + ms + ":" + name2 + " SUSPEND");
            } else {
                this._print.println(d + (ms > 99 ? "." : (ms > 9 ? ".0" : ".00")) + ms + ":" + name2 + " " + sresponse.getStatus() + " " + sresponse.getContentType() + " " + sresponse.getContentCount() + (ex == null ? "" : "/" + ex));
            }
        }
        catch (Throwable throwable2) {
            Object var16_21 = null;
            thread.setName(old_name);
            String d = this._date.now();
            int ms = this._date.lastMs();
            if (suspend) {
                this._print.println(d + (ms > 99 ? "." : (ms > 9 ? ".0" : ".00")) + ms + ":" + name2 + " SUSPEND");
            } else {
                this._print.println(d + (ms > 99 ? "." : (ms > 9 ? ".0" : ".00")) + ms + ":" + name2 + " " + sresponse.getStatus() + " " + sresponse.getContentType() + " " + sresponse.getContentCount() + (ex == null ? "" : "/" + ex));
            }
            throw throwable2;
        }
    }

    protected void doStart() throws Exception {
        if (this._out == null) {
            this._out = new RolloverFileOutputStream("./logs/yyyy_mm_dd.debug.log", true);
        }
        this._print = new PrintStream(this._out);
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this._print.close();
    }

    public OutputStream getOutputStream() {
        return this._out;
    }

    public void setOutputStream(OutputStream out) {
        this._out = out;
    }
}

