/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.handler;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.servlet.PathMap;
import org.mortbay.log.Log;
import org.mortbay.util.LazyList;

public class ContextHandlerCollection
extends HandlerCollection {
    private PathMap _contextMap;
    private Class _contextClass = ContextHandler.class;

    public void mapContexts() {
        PathMap contextMap = new PathMap();
        Handler[] branches = this.getHandlers();
        for (int b = 0; branches != null && b < branches.length; ++b) {
            Handler[] handlers2 = null;
            if (branches[b] instanceof ContextHandler) {
                handlers2 = new Handler[]{branches[b]};
            } else {
                if (!(branches[b] instanceof HandlerContainer)) continue;
                handlers2 = ((HandlerContainer)((Object)branches[b])).getChildHandlersByClass(class$org$mortbay$jetty$handler$ContextHandler == null ? ContextHandlerCollection.class$("org.mortbay.jetty.handler.ContextHandler") : class$org$mortbay$jetty$handler$ContextHandler);
            }
            for (int i = 0; i < handlers2.length; ++i) {
                HashMap hosts;
                ContextHandler handler = (ContextHandler)handlers2[i];
                String contextPath = handler.getContextPath();
                if (contextPath == null || contextPath.indexOf(44) >= 0 || contextPath.startsWith("*")) {
                    throw new IllegalArgumentException("Illegal context spec:" + contextPath);
                }
                if (!contextPath.startsWith("/")) {
                    contextPath = '/' + contextPath;
                }
                if (contextPath.length() > 1) {
                    if (contextPath.endsWith("/")) {
                        contextPath = contextPath + "*";
                    } else if (!contextPath.endsWith("/*")) {
                        contextPath = contextPath + "/*";
                    }
                }
                Object contexts = contextMap.get(contextPath);
                String[] vhosts = handler.getVirtualHosts();
                if (vhosts != null && vhosts.length > 0) {
                    if (contexts instanceof Map) {
                        hosts = (Map)contexts;
                    } else {
                        hosts = new HashMap();
                        hosts.put("*", contexts);
                        contextMap.put(contextPath, hosts);
                    }
                    for (int j = 0; j < vhosts.length; ++j) {
                        String vhost = vhosts[j];
                        contexts = hosts.get(vhost);
                        contexts = LazyList.add(contexts, branches[b]);
                        hosts.put(vhost, contexts);
                    }
                    continue;
                }
                if (contexts instanceof Map) {
                    hosts = (HashMap)contexts;
                    contexts = hosts.get("*");
                    contexts = LazyList.add(contexts, branches[b]);
                    hosts.put("*", contexts);
                    continue;
                }
                contexts = LazyList.add(contexts, branches[b]);
                contextMap.put(contextPath, contexts);
            }
        }
        this._contextMap = contextMap;
    }

    public void setHandlers(Handler[] handlers2) {
        this._contextMap = null;
        super.setHandlers(handlers2);
        if (this.isStarted()) {
            this.mapContexts();
        }
    }

    protected void doStart() throws Exception {
        this.mapContexts();
        super.doStart();
    }

    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch2) throws IOException, ServletException {
        Handler[] handlers2 = this.getHandlers();
        if (handlers2 == null || handlers2.length == 0) {
            return;
        }
        Request base_request = HttpConnection.getCurrentConnection().getRequest();
        PathMap map2 = this._contextMap;
        if (map2 != null && target != null && target.startsWith("/")) {
            Object contexts = map2.getLazyMatches(target);
            for (int i = 0; i < LazyList.size(contexts); ++i) {
                Map.Entry entry2 = (Map.Entry)LazyList.get(contexts, i);
                Object list2 = entry2.getValue();
                if (list2 instanceof Map) {
                    Handler handler;
                    int j;
                    Map hosts = (Map)list2;
                    String host = this.normalizeHostname(request.getServerName());
                    list2 = hosts.get(host);
                    for (j = 0; j < LazyList.size(list2); ++j) {
                        handler = (Handler)LazyList.get(list2, j);
                        handler.handle(target, request, response, dispatch2);
                        if (!base_request.isHandled()) continue;
                        return;
                    }
                    list2 = hosts.get("*." + host.substring(host.indexOf(".") + 1));
                    for (j = 0; j < LazyList.size(list2); ++j) {
                        handler = (Handler)LazyList.get(list2, j);
                        handler.handle(target, request, response, dispatch2);
                        if (!base_request.isHandled()) continue;
                        return;
                    }
                    list2 = hosts.get("*");
                    for (j = 0; j < LazyList.size(list2); ++j) {
                        handler = (Handler)LazyList.get(list2, j);
                        handler.handle(target, request, response, dispatch2);
                        if (!base_request.isHandled()) continue;
                        return;
                    }
                    continue;
                }
                for (int j = 0; j < LazyList.size(list2); ++j) {
                    Handler handler = (Handler)LazyList.get(list2, j);
                    handler.handle(target, request, response, dispatch2);
                    if (!base_request.isHandled()) continue;
                    return;
                }
            }
        } else {
            for (int i = 0; i < handlers2.length; ++i) {
                handlers2[i].handle(target, request, response, dispatch2);
                if (!base_request.isHandled()) continue;
                return;
            }
        }
    }

    public ContextHandler addContext(String contextPath, String resourceBase) {
        try {
            ContextHandler context = (ContextHandler)this._contextClass.newInstance();
            context.setContextPath(contextPath);
            context.setResourceBase(resourceBase);
            this.addHandler(context);
            return context;
        }
        catch (Exception e) {
            Log.debug(e);
            throw new Error(e);
        }
    }

    public Class getContextClass() {
        return this._contextClass;
    }

    public void setContextClass(Class contextClass) {
        if (contextClass == null || !ContextHandler.class.isAssignableFrom(contextClass)) {
            throw new IllegalArgumentException();
        }
        this._contextClass = contextClass;
    }

    private String normalizeHostname(String host) {
        if (host == null) {
            return null;
        }
        if (host.endsWith(".")) {
            return host.substring(0, host.length() - 1);
        }
        return host;
    }
}

