/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import org.mortbay.log.Log;
import org.mortbay.util.LazyList;

public class InclusiveByteRange {
    long first = 0L;
    long last = 0L;

    public InclusiveByteRange(long first2, long last2) {
        this.first = first2;
        this.last = last2;
    }

    public long getFirst() {
        return this.first;
    }

    public long getLast() {
        return this.last;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List satisfiableRanges(Enumeration headers, long size2) {
        Object satRanges = null;
        block2: while (headers.hasMoreElements()) {
            String header = (String)headers.nextElement();
            StringTokenizer tok = new StringTokenizer(header, "=,", false);
            String t = null;
            try {
                while (true) {
                    long last2;
                    long first2;
                    block11: {
                        if (!tok.hasMoreTokens()) continue block2;
                        t = tok.nextToken().trim();
                        first2 = -1L;
                        last2 = -1L;
                        int d = t.indexOf(45);
                        if (d < 0 || t.indexOf("-", d + 1) >= 0) {
                            if ("bytes".equals(t)) continue;
                            Log.warn("Bad range format: {}", t);
                            continue block2;
                        }
                        if (d == 0) {
                            if (d + 1 < t.length()) {
                                last2 = Long.parseLong(t.substring(d + 1).trim());
                                break block11;
                            } else {
                                Log.warn("Bad range format: {}", t);
                                continue block2;
                            }
                        }
                        if (d + 1 < t.length()) {
                            first2 = Long.parseLong(t.substring(0, d).trim());
                            last2 = Long.parseLong(t.substring(d + 1).trim());
                        } else {
                            first2 = Long.parseLong(t.substring(0, d).trim());
                        }
                    }
                    if (first2 == -1L && last2 == -1L || first2 != -1L && last2 != -1L && first2 > last2) continue block2;
                    if (first2 >= size2) continue;
                    InclusiveByteRange range2 = new InclusiveByteRange(first2, last2);
                    satRanges = LazyList.add(satRanges, range2);
                }
            }
            catch (Exception e) {
                Log.warn("Bad range format: " + t);
                Log.ignore(e);
                continue;
            }
            break;
        }
        return LazyList.getList(satRanges, true);
    }

    public long getFirst(long size2) {
        if (this.first < 0L) {
            long tf = size2 - this.last;
            if (tf < 0L) {
                tf = 0L;
            }
            return tf;
        }
        return this.first;
    }

    public long getLast(long size2) {
        if (this.first < 0L) {
            return size2 - 1L;
        }
        if (this.last < 0L || this.last >= size2) {
            return size2 - 1L;
        }
        return this.last;
    }

    public long getSize(long size2) {
        return this.getLast(size2) - this.getFirst(size2) + 1L;
    }

    public String toHeaderRangeString(long size2) {
        StringBuffer sb = new StringBuffer(40);
        sb.append("bytes ");
        sb.append(this.getFirst(size2));
        sb.append('-');
        sb.append(this.getLast(size2));
        sb.append("/");
        sb.append(size2);
        return sb.toString();
    }

    public static String to416HeaderRangeString(long size2) {
        StringBuffer sb = new StringBuffer(40);
        sb.append("bytes */");
        sb.append(size2);
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(60);
        sb.append(Long.toString(this.first));
        sb.append(":");
        sb.append(Long.toString(this.last));
        return sb.toString();
    }
}

