/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io.nio;

import java.nio.ByteBuffer;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.nio.NIOBuffer;

public class IndirectNIOBuffer
extends ByteArrayBuffer
implements NIOBuffer {
    protected ByteBuffer _buf;

    public IndirectNIOBuffer(int size2) {
        super(2, false);
        this._buf = ByteBuffer.allocate(size2);
        this._buf.position(0);
        this._buf.limit(this._buf.capacity());
        this._bytes = this._buf.array();
    }

    public IndirectNIOBuffer(ByteBuffer buffer2, boolean immutable) {
        super(immutable ? 0 : 2, false);
        if (buffer2.isDirect()) {
            throw new IllegalArgumentException();
        }
        this._buf = buffer2;
        this.setGetIndex(buffer2.position());
        this.setPutIndex(buffer2.limit());
        this._bytes = this._buf.array();
    }

    public ByteBuffer getByteBuffer() {
        return this._buf;
    }

    public boolean isDirect() {
        return false;
    }
}

