/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io.bio;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mortbay.io.Buffer;
import org.mortbay.io.EndPoint;

public class StreamEndPoint
implements EndPoint {
    InputStream _in;
    OutputStream _out;

    public StreamEndPoint(InputStream in, OutputStream out) {
        this._in = in;
        this._out = out;
    }

    public boolean isBlocking() {
        return true;
    }

    public boolean blockReadable(long millisecs) throws IOException {
        return true;
    }

    public boolean blockWritable(long millisecs) throws IOException {
        return true;
    }

    public boolean isOpen() {
        return this._in != null;
    }

    public final boolean isClosed() {
        return !this.isOpen();
    }

    public void shutdownOutput() throws IOException {
    }

    public void close() throws IOException {
        if (this._in != null) {
            this._in.close();
        }
        this._in = null;
        if (this._out != null) {
            this._out.close();
        }
        this._out = null;
    }

    public int fill(Buffer buffer2) throws IOException {
        if (this._in == null) {
            return 0;
        }
        int space = buffer2.space();
        if (space <= 0) {
            if (buffer2.hasContent()) {
                return 0;
            }
            throw new IOException("FULL");
        }
        int len = buffer2.readFrom(this._in, space);
        return len;
    }

    public int flush(Buffer buffer2) throws IOException {
        if (this._out == null) {
            return -1;
        }
        int length = buffer2.length();
        if (length > 0) {
            buffer2.writeTo(this._out);
        }
        buffer2.clear();
        return length;
    }

    public int flush(Buffer header, Buffer buffer2, Buffer trailer) throws IOException {
        int f2;
        int tw;
        int len = 0;
        if (header != null && (tw = header.length()) > 0) {
            len = f2 = this.flush(header);
            if (f2 < tw) {
                return len;
            }
        }
        if (buffer2 != null && (tw = buffer2.length()) > 0) {
            f2 = this.flush(buffer2);
            if (f2 < 0) {
                return len > 0 ? len : f2;
            }
            len += f2;
            if (f2 < tw) {
                return len;
            }
        }
        if (trailer != null && (tw = trailer.length()) > 0) {
            f2 = this.flush(trailer);
            if (f2 < 0) {
                return len > 0 ? len : f2;
            }
            len += f2;
        }
        return len;
    }

    public String getLocalAddr() {
        return null;
    }

    public String getLocalHost() {
        return null;
    }

    public int getLocalPort() {
        return 0;
    }

    public String getRemoteAddr() {
        return null;
    }

    public String getRemoteHost() {
        return null;
    }

    public int getRemotePort() {
        return 0;
    }

    public Object getTransport() {
        return null;
    }

    public InputStream getInputStream() {
        return this._in;
    }

    public void setInputStream(InputStream in) {
        this._in = in;
    }

    public OutputStream getOutputStream() {
        return this._out;
    }

    public void setOutputStream(OutputStream out) {
        this._out = out;
    }

    public void flush() throws IOException {
        this._out.flush();
    }

    public boolean isBufferingInput() {
        return false;
    }

    public boolean isBufferingOutput() {
        return false;
    }

    public boolean isBufferred() {
        return false;
    }
}

