/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io;

import java.io.UnsupportedEncodingException;
import org.mortbay.io.Buffer;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.util.StringUtil;

public class BufferUtil {
    static final byte SPACE = 32;
    static final byte MINUS = 45;
    static final byte[] DIGIT = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static int[] decDivisors = new int[]{1000000000, 100000000, 10000000, 1000000, 100000, 10000, 1000, 100, 10, 1};
    private static int[] hexDivisors = new int[]{0x10000000, 0x1000000, 0x100000, 65536, 4096, 256, 16, 1};
    private static final long[] decDivisorsL = new long[]{1000000000000000000L, 100000000000000000L, 10000000000000000L, 1000000000000000L, 100000000000000L, 10000000000000L, 1000000000000L, 100000000000L, 10000000000L, 1000000000L, 100000000L, 10000000L, 1000000L, 100000L, 10000L, 1000L, 100L, 10L, 1L};

    public static int toInt(Buffer buffer2) {
        int val = 0;
        boolean started = false;
        boolean minus2 = false;
        for (int i = buffer2.getIndex(); i < buffer2.putIndex(); ++i) {
            byte b = buffer2.peek(i);
            if (b <= 32) {
                if (!started) continue;
                break;
            }
            if (b >= 48 && b <= 57) {
                val = val * 10 + (b - 48);
                started = true;
                continue;
            }
            if (b != 45 || started) break;
            minus2 = true;
        }
        if (started) {
            return minus2 ? -val : val;
        }
        throw new NumberFormatException(buffer2.toString());
    }

    public static long toLong(Buffer buffer2) {
        long val = 0L;
        boolean started = false;
        boolean minus2 = false;
        for (int i = buffer2.getIndex(); i < buffer2.putIndex(); ++i) {
            byte b = buffer2.peek(i);
            if (b <= 32) {
                if (!started) continue;
                break;
            }
            if (b >= 48 && b <= 57) {
                val = val * 10L + (long)(b - 48);
                started = true;
                continue;
            }
            if (b != 45 || started) break;
            minus2 = true;
        }
        if (started) {
            return minus2 ? -val : val;
        }
        throw new NumberFormatException(buffer2.toString());
    }

    public static void putHexInt(Buffer buffer2, int n) {
        if (n < 0) {
            buffer2.put((byte)45);
            if (n == Integer.MIN_VALUE) {
                buffer2.put((byte)56);
                buffer2.put((byte)48);
                buffer2.put((byte)48);
                buffer2.put((byte)48);
                buffer2.put((byte)48);
                buffer2.put((byte)48);
                buffer2.put((byte)48);
                buffer2.put((byte)48);
                return;
            }
            n = -n;
        }
        if (n < 16) {
            buffer2.put(DIGIT[n]);
        } else {
            boolean started = false;
            for (int i = 0; i < hexDivisors.length; ++i) {
                if (n < hexDivisors[i]) {
                    if (!started) continue;
                    buffer2.put((byte)48);
                    continue;
                }
                started = true;
                int d = n / hexDivisors[i];
                buffer2.put(DIGIT[d]);
                n -= d * hexDivisors[i];
            }
        }
    }

    public static void prependHexInt(Buffer buffer2, int n) {
        if (n == 0) {
            int gi = buffer2.getIndex();
            buffer2.poke(--gi, (byte)48);
            buffer2.setGetIndex(gi);
        } else {
            boolean minus2 = false;
            if (n < 0) {
                minus2 = true;
                n = -n;
            }
            int gi = buffer2.getIndex();
            while (n > 0) {
                int d = 0xF & n;
                n >>= 4;
                buffer2.poke(--gi, DIGIT[d]);
            }
            if (minus2) {
                buffer2.poke(--gi, (byte)45);
            }
            buffer2.setGetIndex(gi);
        }
    }

    public static void putDecInt(Buffer buffer2, int n) {
        if (n < 0) {
            buffer2.put((byte)45);
            if (n == Integer.MIN_VALUE) {
                buffer2.put((byte)50);
                n = 147483648;
            } else {
                n = -n;
            }
        }
        if (n < 10) {
            buffer2.put(DIGIT[n]);
        } else {
            boolean started = false;
            for (int i = 0; i < decDivisors.length; ++i) {
                if (n < decDivisors[i]) {
                    if (!started) continue;
                    buffer2.put((byte)48);
                    continue;
                }
                started = true;
                int d = n / decDivisors[i];
                buffer2.put(DIGIT[d]);
                n -= d * decDivisors[i];
            }
        }
    }

    public static void putDecLong(Buffer buffer2, long n) {
        if (n < 0L) {
            buffer2.put((byte)45);
            if (n == Long.MIN_VALUE) {
                buffer2.put((byte)57);
                n = 223372036854775808L;
            } else {
                n = -n;
            }
        }
        if (n < 10L) {
            buffer2.put(DIGIT[(int)n]);
        } else {
            boolean started = false;
            for (int i = 0; i < decDivisorsL.length; ++i) {
                if (n < decDivisorsL[i]) {
                    if (!started) continue;
                    buffer2.put((byte)48);
                    continue;
                }
                started = true;
                long d = n / decDivisorsL[i];
                buffer2.put(DIGIT[(int)d]);
                n -= d * decDivisorsL[i];
            }
        }
    }

    public static Buffer toBuffer(long value2) {
        ByteArrayBuffer buf = new ByteArrayBuffer(16);
        BufferUtil.putDecLong(buf, value2);
        return buf;
    }

    public static void putCRLF(Buffer buffer2) {
        buffer2.put((byte)13);
        buffer2.put((byte)10);
    }

    public static boolean isPrefix(Buffer prefix, Buffer buffer2) {
        if (prefix.length() > buffer2.length()) {
            return false;
        }
        int bi = buffer2.getIndex();
        for (int i = prefix.getIndex(); i < prefix.putIndex(); ++i) {
            if (prefix.peek(i) == buffer2.peek(bi++)) continue;
            return false;
        }
        return true;
    }

    public static String to8859_1_String(Buffer buffer2) {
        if (buffer2.isImmutable()) {
            return buffer2.toString();
        }
        try {
            byte[] bytes2 = buffer2.array();
            if (bytes2 != null) {
                return new String(bytes2, buffer2.getIndex(), buffer2.length(), StringUtil.__ISO_8859_1);
            }
            StringBuffer b = new StringBuffer(buffer2.length());
            int i = buffer2.getIndex();
            for (int c = 0; c < buffer2.length(); ++c) {
                b.append((char)(0x7F & buffer2.peek(i)));
                ++i;
            }
            return b.toString();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return buffer2.toString();
        }
    }
}

