/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.generate;

import java.util.ArrayList;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.VertexFactory;
import org.jgrapht.generate.GraphGenerator;
import org.jgrapht.generate.RingGraphGenerator;

public class WheelGraphGenerator<V, E>
implements GraphGenerator<V, E, V> {
    public static final String HUB_VERTEX = "Hub Vertex";
    private boolean inwardSpokes;
    private int size;

    public WheelGraphGenerator(int n) {
        this(n, true);
    }

    public WheelGraphGenerator(int n, boolean bl) {
        if (n < 0) {
            throw new IllegalArgumentException("must be non-negative");
        }
        this.size = n;
        this.inwardSpokes = bl;
    }

    @Override
    public void generateGraph(Graph<V, E> graph, final VertexFactory<V> vertexFactory, Map<String, V> map2) {
        if (this.size < 1) {
            return;
        }
        final ArrayList arrayList = new ArrayList();
        VertexFactory vertexFactory2 = new VertexFactory<V>(){

            @Override
            public V createVertex() {
                Object v = vertexFactory.createVertex();
                arrayList.add(v);
                return v;
            }
        };
        RingGraphGenerator ringGraphGenerator = new RingGraphGenerator(this.size - 1);
        ringGraphGenerator.generateGraph(graph, vertexFactory2, map2);
        V v = vertexFactory.createVertex();
        graph.addVertex(v);
        if (map2 != null) {
            map2.put(HUB_VERTEX, v);
        }
        for (Object e : arrayList) {
            if (this.inwardSpokes) {
                graph.addEdge(e, v);
                continue;
            }
            graph.addEdge(v, e);
        }
    }
}

