/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.generate;

import java.util.LinkedList;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.VertexFactory;
import org.jgrapht.generate.GraphGenerator;

public class HyperCubeGraphGenerator<V, E>
implements GraphGenerator<V, E, V> {
    private int dim;

    public HyperCubeGraphGenerator(int n) {
        this.dim = n;
    }

    @Override
    public void generateGraph(Graph<V, E> graph, VertexFactory<V> vertexFactory, Map<String, V> map2) {
        int n;
        int n2 = (int)Math.pow(2.0, this.dim);
        LinkedList<V> linkedList = new LinkedList<V>();
        for (n = 0; n < n2; ++n) {
            V v = vertexFactory.createVertex();
            graph.addVertex(v);
            linkedList.add(v);
            if (map2 == null) continue;
            String string2 = Integer.toBinaryString(n);
            while (string2.length() < this.dim) {
                string2 = "0" + string2;
            }
            map2.put(string2, v);
        }
        for (n = 0; n < n2; ++n) {
            block3: for (int i = n + 1; i < n2; ++i) {
                for (int j = 0; j < this.dim; ++j) {
                    if ((i ^ n) != 1 << j) continue;
                    graph.addEdge(linkedList.get(n), linkedList.get(i));
                    continue block3;
                }
            }
        }
    }
}

