/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.ext;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import org.jgrapht.Graph;
import org.jgrapht.ext.StringNameProvider;
import org.jgrapht.ext.VertexNameProvider;

public class VisioExporter<V, E> {
    private VertexNameProvider<V> vertexNameProvider;

    public VisioExporter(VertexNameProvider<V> vertexNameProvider) {
        this.vertexNameProvider = vertexNameProvider;
    }

    public VisioExporter() {
        this(new StringNameProvider());
    }

    public void export(OutputStream outputStream, Graph<V, E> graph) {
        PrintStream printStream = new PrintStream(outputStream);
        Iterator<Object> iterator2 = graph.vertexSet().iterator();
        while (iterator2.hasNext()) {
            this.exportVertex(printStream, iterator2.next());
        }
        iterator2 = graph.edgeSet().iterator();
        while (iterator2.hasNext()) {
            this.exportEdge(printStream, iterator2.next(), graph);
        }
        printStream.flush();
    }

    private void exportEdge(PrintStream printStream, E e, Graph<V, E> graph) {
        String string2 = this.vertexNameProvider.getVertexName(graph.getEdgeSource(e));
        String string3 = this.vertexNameProvider.getVertexName(graph.getEdgeTarget(e));
        printStream.print("Link,");
        printStream.print(string2);
        printStream.print("-->");
        printStream.print(string3);
        printStream.print(",,,");
        printStream.print(string2);
        printStream.print(",");
        printStream.print(string3);
        printStream.print("\n");
    }

    private void exportVertex(PrintStream printStream, V v) {
        String string2 = this.vertexNameProvider.getVertexName(v);
        printStream.print("Shape,");
        printStream.print(string2);
        printStream.print(",,");
        printStream.print(string2);
        printStream.print("\n");
    }
}

