/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental;

import java.util.Arrays;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.VertexFactory;
import org.jgrapht.experimental.RandomGraphHelper;
import org.jgrapht.generate.GraphGenerator;

public class PartiteRandomGraphGenerator<V, E>
implements GraphGenerator<V, E, Object[]> {
    private final int[] numVertices;
    private final int numEdges;

    public PartiteRandomGraphGenerator(int n, int n2, int n3) {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("must be non-negative");
        }
        if (n3 < 0 || n3 > n * n2) {
            throw new IllegalArgumentException("illegal number of edges");
        }
        int[] nArray = new int[]{n, n2};
        this.numVertices = nArray;
        this.numEdges = n3;
    }

    public PartiteRandomGraphGenerator(int[] nArray, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("illegal number of edges");
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < 0) {
                throw new IllegalArgumentException("must be non-negative");
            }
            for (int j = 0; j < i; ++j) {
                if (n <= nArray[i] * nArray[j]) continue;
                throw new IllegalArgumentException("illegal number of edges");
            }
        }
        this.numVertices = nArray;
        this.numEdges = n;
    }

    @Override
    public void generateGraph(Graph<V, E> graph, VertexFactory<V> vertexFactory, Map<String, Object[]> map2) {
        Object[][] objectArrayArray = new Object[this.numVertices.length][];
        for (int i = 0; i < this.numVertices.length; ++i) {
            objectArrayArray[i] = RandomGraphHelper.addVertices(graph, vertexFactory, this.numVertices[i]);
            if (map2 != null) {
                map2.put(Integer.toString(i), objectArrayArray[i]);
            }
            for (int j = 0; j < i; ++j) {
                RandomGraphHelper.addEdges(graph, Arrays.asList(objectArrayArray[i]), Arrays.asList(objectArrayArray[j]), this.numEdges);
            }
        }
    }
}

