/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.jgrapht.Graph;
import org.jgrapht.VertexFactory;
import org.jgrapht.generate.GraphGenerator;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleGraph;

public class GraphReader<V, E>
implements GraphGenerator<V, E, V> {
    private final BufferedReader _in;

    public GraphReader(String string2) throws IOException {
        this._in = new BufferedReader(new FileReader(string2));
    }

    private List<String> split(String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    private List<String> skipComments() {
        try {
            if (this._in.ready()) {
                List<String> list2 = this.split(this._in.readLine());
                while (list2.isEmpty() || list2.get(0).equals("c") || list2.get(0).startsWith("%")) {
                    list2 = this.split(this._in.readLine());
                }
                return list2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private int readNodeCount() {
        List<String> list2 = this.skipComments();
        if (list2.get(0).equals("p")) {
            return Integer.parseInt(list2.get(1));
        }
        return -1;
    }

    @Override
    public void generateGraph(Graph<V, E> graph, VertexFactory<V> vertexFactory, Map<String, V> map2) {
        int n = this.readNodeCount();
        if (map2 == null) {
            map2 = new HashMap<String, V>();
        }
        for (int i = 0; i < n; ++i) {
            V v = vertexFactory.createVertex();
            graph.addVertex(v);
            map2.put(Integer.toString(i + 1), v);
        }
        List<String> list2 = this.skipComments();
        while (list2 != null) {
            if (list2.get(0).equals("e")) {
                graph.addEdge(map2.get(list2.get(1)), map2.get(list2.get(2)));
            }
            list2 = this.skipComments();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        GraphReader<Integer, DefaultEdge> graphReader = new GraphReader<Integer, DefaultEdge>(stringArray[0]);
        SimpleGraph simpleGraph = new SimpleGraph(DefaultEdge.class);
        IntVertexFactory intVertexFactory = new IntVertexFactory();
        graphReader.generateGraph((Graph<Integer, DefaultEdge>)simpleGraph, (VertexFactory<Integer>)intVertexFactory, (Map<String, Integer>)null);
        System.out.println(simpleGraph);
    }

    private static final class IntVertexFactory
    implements VertexFactory<Integer> {
        int last = 0;

        private IntVertexFactory() {
        }

        @Override
        public Integer createVertex() {
            return this.last++;
        }
    }
}

