/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.event.ConnectedComponentTraversalEvent;
import org.jgrapht.event.GraphEdgeChangeEvent;
import org.jgrapht.event.GraphListener;
import org.jgrapht.event.GraphVertexChangeEvent;
import org.jgrapht.event.TraversalListenerAdapter;
import org.jgrapht.event.VertexTraversalEvent;
import org.jgrapht.graph.AsUndirectedGraph;
import org.jgrapht.traverse.BreadthFirstIterator;

public class ConnectivityInspector<V, E>
implements GraphListener<V, E> {
    List<Set<V>> connectedSets;
    Map<V, Set<V>> vertexToConnectedSet;
    private Graph<V, E> graph;

    public ConnectivityInspector(UndirectedGraph<V, E> undirectedGraph) {
        this.init();
        this.graph = undirectedGraph;
    }

    public ConnectivityInspector(DirectedGraph<V, E> directedGraph) {
        this.init();
        this.graph = new AsUndirectedGraph<V, E>(directedGraph);
    }

    public boolean isGraphConnected() {
        return this.lazyFindConnectedSets().size() == 1;
    }

    public Set<V> connectedSetOf(V v) {
        Set<V> set2 = this.vertexToConnectedSet.get(v);
        if (set2 == null) {
            set2 = new HashSet<V>();
            BreadthFirstIterator<V, E> breadthFirstIterator = new BreadthFirstIterator<V, E>(this.graph, v);
            while (breadthFirstIterator.hasNext()) {
                set2.add(breadthFirstIterator.next());
            }
            this.vertexToConnectedSet.put((Set<V>)v, (Set<Set<V>>)set2);
        }
        return set2;
    }

    public List<Set<V>> connectedSets() {
        return this.lazyFindConnectedSets();
    }

    @Override
    public void edgeAdded(GraphEdgeChangeEvent<V, E> graphEdgeChangeEvent) {
        this.init();
    }

    @Override
    public void edgeRemoved(GraphEdgeChangeEvent<V, E> graphEdgeChangeEvent) {
        this.init();
    }

    public boolean pathExists(V v, V v2) {
        Set<V> set2 = this.connectedSetOf(v);
        return set2.contains(v2);
    }

    @Override
    public void vertexAdded(GraphVertexChangeEvent<V> graphVertexChangeEvent) {
        this.init();
    }

    @Override
    public void vertexRemoved(GraphVertexChangeEvent<V> graphVertexChangeEvent) {
        this.init();
    }

    private void init() {
        this.connectedSets = null;
        this.vertexToConnectedSet = new HashMap<V, Set<V>>();
    }

    private List<Set<V>> lazyFindConnectedSets() {
        if (this.connectedSets == null) {
            this.connectedSets = new ArrayList<Set<V>>();
            Set<V> set2 = this.graph.vertexSet();
            if (set2.size() > 0) {
                BreadthFirstIterator<Object, E> breadthFirstIterator = new BreadthFirstIterator<Object, E>(this.graph, null);
                breadthFirstIterator.addTraversalListener(new MyTraversalListener());
                while (breadthFirstIterator.hasNext()) {
                    breadthFirstIterator.next();
                }
            }
        }
        return this.connectedSets;
    }

    private class MyTraversalListener
    extends TraversalListenerAdapter<V, E> {
        private Set<V> currentConnectedSet;

        private MyTraversalListener() {
        }

        @Override
        public void connectedComponentFinished(ConnectedComponentTraversalEvent connectedComponentTraversalEvent) {
            ConnectivityInspector.this.connectedSets.add(this.currentConnectedSet);
        }

        @Override
        public void connectedComponentStarted(ConnectedComponentTraversalEvent connectedComponentTraversalEvent) {
            this.currentConnectedSet = new HashSet();
        }

        @Override
        public void vertexTraversed(VertexTraversalEvent<V> vertexTraversalEvent) {
            Object v = vertexTraversalEvent.getVertex();
            this.currentConnectedSet.add(v);
            ConnectivityInspector.this.vertexToConnectedSet.put((Set)v, (Set)this.currentConnectedSet);
        }
    }
}

