/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jgrapht.Graph;

public class BronKerboschCliqueFinder<V, E> {
    private final Graph<V, E> graph;
    private Collection<Set<V>> cliques;

    public BronKerboschCliqueFinder(Graph<V, E> graph) {
        this.graph = graph;
    }

    public Collection<Set<V>> getAllMaximalCliques() {
        this.cliques = new ArrayList<Set<V>>();
        ArrayList arrayList = new ArrayList();
        ArrayList<V> arrayList2 = new ArrayList<V>();
        ArrayList arrayList3 = new ArrayList();
        arrayList2.addAll(this.graph.vertexSet());
        this.findCliques(arrayList, arrayList2, arrayList3);
        return this.cliques;
    }

    public Collection<Set<V>> getBiggestMaximalCliques() {
        this.getAllMaximalCliques();
        int n = 0;
        ArrayList<Set<V>> arrayList = new ArrayList<Set<V>>();
        for (Set<V> set2 : this.cliques) {
            if (n >= set2.size()) continue;
            n = set2.size();
        }
        for (Set<V> set2 : this.cliques) {
            if (n != set2.size()) continue;
            arrayList.add(set2);
        }
        return arrayList;
    }

    private void findCliques(List<V> list2, List<V> list3, List<V> list4) {
        ArrayList<V> arrayList = new ArrayList<V>(list3);
        if (!this.end(list3, list4)) {
            for (Object e : arrayList) {
                ArrayList<V> arrayList2 = new ArrayList<V>();
                ArrayList<V> arrayList3 = new ArrayList<V>();
                list2.add(e);
                list3.remove(e);
                for (V v : list3) {
                    if (!this.graph.containsEdge(e, v)) continue;
                    arrayList2.add(v);
                }
                for (V v : list4) {
                    if (!this.graph.containsEdge(e, v)) continue;
                    arrayList3.add(v);
                }
                if (arrayList2.isEmpty() && arrayList3.isEmpty()) {
                    this.cliques.add(new HashSet<V>(list2));
                } else {
                    this.findCliques(list2, arrayList2, arrayList3);
                }
                list4.add(e);
                list2.remove(e);
            }
        }
    }

    private boolean end(List<V> list2, List<V> list3) {
        boolean bl = false;
        for (V v : list3) {
            int n = 0;
            for (V v2 : list2) {
                if (!this.graph.containsEdge(v, v2)) continue;
                ++n;
            }
            if (n != list2.size()) continue;
            bl = true;
        }
        return bl;
    }
}

