/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.alg.BellmanFordPathElement;

class BellmanFordIterator<V, E>
implements Iterator<List<V>> {
    protected static final String NEGATIVE_UNDIRECTED_EDGE = "Negativeedge-weights are not allowed in an unidrected graph!";
    protected Graph<V, E> graph;
    protected V startVertex;
    private List<V> prevImprovedVertices = new ArrayList<V>();
    private Map<V, BellmanFordPathElement<V, E>> prevVertexData;
    private boolean startVertexEncountered = false;
    private Map<V, BellmanFordPathElement<V, E>> vertexData;
    private double epsilon;

    protected BellmanFordIterator(Graph<V, E> graph, V v, double d) {
        this.assertBellmanFordIterator(graph, v);
        this.graph = graph;
        this.startVertex = v;
        this.epsilon = d;
    }

    public BellmanFordPathElement<V, E> getPathElement(V v) {
        return this.getSeenData(v);
    }

    @Override
    public boolean hasNext() {
        if (!this.startVertexEncountered) {
            this.encounterStartVertex();
        }
        return !this.prevImprovedVertices.isEmpty();
    }

    @Override
    public List<V> next() {
        if (!this.startVertexEncountered) {
            this.encounterStartVertex();
        }
        if (this.hasNext()) {
            ArrayList<V> arrayList = new ArrayList<V>();
            for (int i = this.prevImprovedVertices.size() - 1; i >= 0; --i) {
                V v = this.prevImprovedVertices.get(i);
                Iterator<E> iterator2 = this.edgesOfIterator(v);
                while (iterator2.hasNext()) {
                    E e = iterator2.next();
                    V v2 = Graphs.getOppositeVertex(this.graph, e, v);
                    if (this.getPathElement(v2) != null) {
                        boolean bl = this.relaxVertexAgain(v2, e);
                        if (!bl) continue;
                        arrayList.add(v2);
                        continue;
                    }
                    this.relaxVertex(v2, e);
                    arrayList.add(v2);
                }
            }
            this.savePassData(arrayList);
            return arrayList;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected void assertValidEdge(E e) {
        if (this.graph instanceof UndirectedGraph && this.graph.getEdgeWeight(e) < 0.0) {
            throw new IllegalArgumentException(NEGATIVE_UNDIRECTED_EDGE);
        }
    }

    protected double calculatePathCost(V v, E e) {
        V v2 = Graphs.getOppositeVertex(this.graph, e, v);
        BellmanFordPathElement<V, E> bellmanFordPathElement = this.getPrevSeenData(v2);
        double d = this.graph.getEdgeWeight(e);
        if (!bellmanFordPathElement.getVertex().equals(this.startVertex)) {
            d += bellmanFordPathElement.getCost();
        }
        return d;
    }

    protected Iterator<E> edgesOfIterator(V v) {
        if (this.graph instanceof DirectedGraph) {
            return ((DirectedGraph)this.graph).outgoingEdgesOf(v).iterator();
        }
        return this.graph.edgesOf(v).iterator();
    }

    protected BellmanFordPathElement<V, E> getPrevSeenData(V v) {
        return this.prevVertexData.get(v);
    }

    protected BellmanFordPathElement<V, E> getSeenData(V v) {
        return this.vertexData.get(v);
    }

    protected boolean isSeenVertex(V v) {
        return this.vertexData.containsKey(v);
    }

    protected BellmanFordPathElement<V, E> putPrevSeenData(V v, BellmanFordPathElement<V, E> bellmanFordPathElement) {
        if (this.prevVertexData == null) {
            this.prevVertexData = new HashMap<V, BellmanFordPathElement<V, E>>();
        }
        return this.prevVertexData.put((BellmanFordPathElement<V, E>)v, (BellmanFordPathElement<BellmanFordPathElement<V, E>, E>)bellmanFordPathElement);
    }

    protected BellmanFordPathElement<V, E> putSeenData(V v, BellmanFordPathElement<V, E> bellmanFordPathElement) {
        if (this.vertexData == null) {
            this.vertexData = new HashMap<V, BellmanFordPathElement<V, E>>();
        }
        return this.vertexData.put((BellmanFordPathElement<V, E>)v, (BellmanFordPathElement<BellmanFordPathElement<V, E>, E>)bellmanFordPathElement);
    }

    private void assertBellmanFordIterator(Graph<V, E> graph, V v) {
        if (!graph.containsVertex(v)) {
            throw new IllegalArgumentException("Graph must contain the start vertex!");
        }
    }

    private BellmanFordPathElement<V, E> createSeenData(V v, E e, double d) {
        BellmanFordPathElement<V, E> bellmanFordPathElement = this.getPrevSeenData(Graphs.getOppositeVertex(this.graph, e, v));
        BellmanFordPathElement<V, E> bellmanFordPathElement2 = new BellmanFordPathElement<V, E>(this.graph, bellmanFordPathElement, e, d, this.epsilon);
        return bellmanFordPathElement2;
    }

    private void encounterStartVertex() {
        BellmanFordPathElement bellmanFordPathElement = new BellmanFordPathElement(this.startVertex, this.epsilon);
        this.prevImprovedVertices.add(this.startVertex);
        this.putSeenData(this.startVertex, bellmanFordPathElement);
        this.putPrevSeenData(this.startVertex, bellmanFordPathElement);
        this.startVertexEncountered = true;
    }

    private void relaxVertex(V v, E e) {
        this.assertValidEdge(e);
        double d = this.calculatePathCost(v, e);
        BellmanFordPathElement<V, E> bellmanFordPathElement = this.createSeenData(v, e, d);
        this.putSeenData(v, bellmanFordPathElement);
    }

    private boolean relaxVertexAgain(V v, E e) {
        this.assertValidEdge(e);
        double d = this.calculatePathCost(v, e);
        BellmanFordPathElement<V, E> bellmanFordPathElement = this.getPrevSeenData(Graphs.getOppositeVertex(this.graph, e, v));
        BellmanFordPathElement<V, E> bellmanFordPathElement2 = this.getSeenData(v);
        return bellmanFordPathElement2.improve(bellmanFordPathElement, e, d);
    }

    private void savePassData(List<V> list2) {
        for (V v : list2) {
            BellmanFordPathElement<V, E> bellmanFordPathElement = this.getSeenData(v);
            BellmanFordPathElement<V, E> bellmanFordPathElement2 = new BellmanFordPathElement<V, E>(bellmanFordPathElement);
            this.putPrevSeenData(v, bellmanFordPathElement2);
        }
        this.prevImprovedVertices = list2;
    }
}

