/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.util.internal.jzlib;

import org.jboss.netty.util.internal.jzlib.Adler32;
import org.jboss.netty.util.internal.jzlib.CRC32;
import org.jboss.netty.util.internal.jzlib.InfBlocks;
import org.jboss.netty.util.internal.jzlib.JZlib;
import org.jboss.netty.util.internal.jzlib.ZStream;

final class Inflate {
    private static final int METHOD = 0;
    private static final int FLAG = 1;
    private static final int DICT4 = 2;
    private static final int DICT3 = 3;
    private static final int DICT2 = 4;
    private static final int DICT1 = 5;
    private static final int DICT0 = 6;
    private static final int BLOCKS = 7;
    private static final int CHECK4 = 8;
    private static final int CHECK3 = 9;
    private static final int CHECK2 = 10;
    private static final int CHECK1 = 11;
    private static final int DONE = 12;
    private static final int BAD = 13;
    private static final int GZIP_ID1 = 14;
    private static final int GZIP_ID2 = 15;
    private static final int GZIP_CM = 16;
    private static final int GZIP_FLG = 17;
    private static final int GZIP_MTIME_XFL_OS = 18;
    private static final int GZIP_XLEN = 19;
    private static final int GZIP_FEXTRA = 20;
    private static final int GZIP_FNAME = 21;
    private static final int GZIP_FCOMMENT = 22;
    private static final int GZIP_FHCRC = 23;
    private static final int GZIP_CRC32 = 24;
    private static final int GZIP_ISIZE = 25;
    private int mode;
    private int method;
    private final long[] was = new long[1];
    private long need;
    private int marker;
    private JZlib.WrapperType wrapperType;
    private int wbits;
    private InfBlocks blocks;
    private int gzipFlag;
    private int gzipBytesToRead;
    private int gzipXLen;
    private int gzipUncompressedBytes;
    private int gzipCRC32;
    private int gzipISize;
    private static final byte[] mark = new byte[]{0, 0, -1, -1};

    Inflate() {
    }

    private int inflateReset(ZStream z2) {
        if (z2 == null || z2.istate == null) {
            return -2;
        }
        z2.total_out = 0L;
        z2.total_in = 0L;
        z2.msg = null;
        switch (this.wrapperType) {
            case NONE: {
                z2.istate.mode = 7;
                break;
            }
            case ZLIB: 
            case ZLIB_OR_NONE: {
                z2.istate.mode = 0;
                break;
            }
            case GZIP: {
                z2.istate.mode = 14;
            }
        }
        z2.istate.blocks.reset(z2, null);
        this.gzipUncompressedBytes = 0;
        return 0;
    }

    int inflateEnd(ZStream z2) {
        if (this.blocks != null) {
            this.blocks.free(z2);
        }
        this.blocks = null;
        return 0;
    }

    int inflateInit(ZStream z2, int w, JZlib.WrapperType wrapperType) {
        z2.msg = null;
        this.blocks = null;
        this.wrapperType = wrapperType;
        if (w < 0) {
            throw new IllegalArgumentException("w: " + w);
        }
        if (w < 8 || w > 15) {
            this.inflateEnd(z2);
            return -2;
        }
        this.wbits = w;
        z2.istate.blocks = new InfBlocks(z2, z2.istate.wrapperType == JZlib.WrapperType.NONE ? null : this, 1 << w);
        this.inflateReset(z2);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int inflate(ZStream z2, int f2) {
        if (z2 == null || z2.istate == null || z2.next_in == null) {
            return -2;
        }
        f2 = f2 == 4 ? -5 : 0;
        int r = -5;
        block33: while (true) {
            switch (z2.istate.mode) {
                case 0: {
                    if (z2.avail_in == 0) {
                        return r;
                    }
                    if (z2.istate.wrapperType == JZlib.WrapperType.ZLIB_OR_NONE) {
                        if ((z2.next_in[z2.next_in_index] & 0xF) != 8 || (z2.next_in[z2.next_in_index] >> 4) + 8 > z2.istate.wbits) {
                            z2.istate.wrapperType = JZlib.WrapperType.NONE;
                            z2.istate.mode = 7;
                            continue block33;
                        }
                        z2.istate.wrapperType = JZlib.WrapperType.ZLIB;
                    }
                    r = f2;
                    --z2.avail_in;
                    ++z2.total_in;
                    if (((z2.istate.method = z2.next_in[z2.next_in_index++]) & 0xF) != 8) {
                        z2.istate.mode = 13;
                        z2.msg = "unknown compression method";
                        z2.istate.marker = 5;
                        continue block33;
                    }
                    if ((z2.istate.method >> 4) + 8 > z2.istate.wbits) {
                        z2.istate.mode = 13;
                        z2.msg = "invalid window size";
                        z2.istate.marker = 5;
                        continue block33;
                    }
                    z2.istate.mode = 1;
                }
                case 1: {
                    int b;
                    if (z2.avail_in == 0) {
                        return r;
                    }
                    r = f2;
                    --z2.avail_in;
                    ++z2.total_in;
                    if (((z2.istate.method << 8) + (b = z2.next_in[z2.next_in_index++] & 0xFF)) % 31 != 0) {
                        z2.istate.mode = 13;
                        z2.msg = "incorrect header check";
                        z2.istate.marker = 5;
                        continue block33;
                    }
                    if ((b & 0x20) == 0) {
                        z2.istate.mode = 7;
                        continue block33;
                    }
                    z2.istate.mode = 2;
                }
                case 2: {
                    if (z2.avail_in == 0) {
                        return r;
                    }
                    r = f2;
                    --z2.avail_in;
                    ++z2.total_in;
                    z2.istate.need = (long)((z2.next_in[z2.next_in_index++] & 0xFF) << 24) & 0xFF000000L;
                    z2.istate.mode = 3;
                }
                case 3: {
                    if (z2.avail_in == 0) {
                        return r;
                    }
                    r = f2;
                    --z2.avail_in;
                    ++z2.total_in;
                    z2.istate.need += (long)((z2.next_in[z2.next_in_index++] & 0xFF) << 16) & 0xFF0000L;
                    z2.istate.mode = 4;
                }
                case 4: {
                    if (z2.avail_in == 0) {
                        return r;
                    }
                    r = f2;
                    --z2.avail_in;
                    ++z2.total_in;
                    z2.istate.need += (long)((z2.next_in[z2.next_in_index++] & 0xFF) << 8) & 0xFF00L;
                    z2.istate.mode = 5;
                }
                case 5: {
                    if (z2.avail_in == 0) {
                        return r;
                    }
                    --z2.avail_in;
                    ++z2.total_in;
                    z2.istate.need += (long)z2.next_in[z2.next_in_index++] & 0xFFL;
                    z2.adler = z2.istate.need;
                    z2.istate.mode = 6;
                    return 2;
                }
                case 6: {
                    z2.istate.mode = 13;
                    z2.msg = "need dictionary";
                    z2.istate.marker = 0;
                    return -2;
                }
                case 7: {
                    int decompressedBytes;
                    int old_next_out_index = z2.next_out_index;
                    try {
                        r = z2.istate.blocks.proc(z2, r);
                        if (r == -3) {
                            z2.istate.mode = 13;
                            z2.istate.marker = 0;
                            continue block33;
                        }
                        if (r == 0) {
                            r = f2;
                        }
                        if (r != 1) {
                            decompressedBytes = r;
                            return decompressedBytes;
                        }
                        r = f2;
                        z2.istate.blocks.reset(z2, z2.istate.was);
                    }
                    finally {
                        decompressedBytes = z2.next_out_index - old_next_out_index;
                        this.gzipUncompressedBytes += decompressedBytes;
                        z2.crc32 = CRC32.crc32(z2.crc32, z2.next_out, old_next_out_index, decompressedBytes);
                        continue block33;
                    }
                    if (z2.istate.wrapperType == JZlib.WrapperType.NONE) {
                        z2.istate.mode = 12;
                        continue block33;
                    }
                    if (z2.istate.wrapperType == JZlib.WrapperType.ZLIB) {
                        z2.istate.mode = 8;
                    } else {
                        if (z2.istate.wrapperType == JZlib.WrapperType.GZIP) {
                            this.gzipCRC32 = 0;
                            this.gzipISize = 0;
                            this.gzipBytesToRead = 4;
                            z2.istate.mode = 24;
                            continue block33;
                        }
                        z2.istate.mode = 13;
                        z2.msg = "unexpected state";
                        z2.istate.marker = 0;
                        continue block33;
                    }
                }
                case 8: {
                    if (z2.avail_in == 0) {
                        return r;
                    }
                    r = f2;
                    --z2.avail_in;
                    ++z2.total_in;
                    z2.istate.need = (long)((z2.next_in[z2.next_in_index++] & 0xFF) << 24) & 0xFF000000L;
                    z2.istate.mode = 9;
                }
                case 9: {
                    if (z2.avail_in == 0) {
                        return r;
                    }
                    r = f2;
                    --z2.avail_in;
                    ++z2.total_in;
                    z2.istate.need += (long)((z2.next_in[z2.next_in_index++] & 0xFF) << 16) & 0xFF0000L;
                    z2.istate.mode = 10;
                }
                case 10: {
                    if (z2.avail_in == 0) {
                        return r;
                    }
                    r = f2;
                    --z2.avail_in;
                    ++z2.total_in;
                    z2.istate.need += (long)((z2.next_in[z2.next_in_index++] & 0xFF) << 8) & 0xFF00L;
                    z2.istate.mode = 11;
                }
                case 11: {
                    if (z2.avail_in == 0) {
                        return r;
                    }
                    r = f2;
                    --z2.avail_in;
                    ++z2.total_in;
                    z2.istate.need += (long)z2.next_in[z2.next_in_index++] & 0xFFL;
                    if ((int)z2.istate.was[0] != (int)z2.istate.need) {
                        z2.istate.mode = 13;
                        z2.msg = "incorrect data check";
                        z2.istate.marker = 5;
                        continue block33;
                    }
                    z2.istate.mode = 12;
                }
                case 12: {
                    return 1;
                }
                case 13: {
                    return -3;
                }
                case 14: {
                    if (z2.avail_in == 0) {
                        return r;
                    }
                    r = f2;
                    --z2.avail_in;
                    ++z2.total_in;
                    if ((z2.next_in[z2.next_in_index++] & 0xFF) != 31) {
                        z2.istate.mode = 13;
                        z2.msg = "not a gzip stream";
                        z2.istate.marker = 5;
                        continue block33;
                    }
                    z2.istate.mode = 15;
                }
                case 15: {
                    if (z2.avail_in == 0) {
                        return r;
                    }
                    r = f2;
                    --z2.avail_in;
                    ++z2.total_in;
                    if ((z2.next_in[z2.next_in_index++] & 0xFF) != 139) {
                        z2.istate.mode = 13;
                        z2.msg = "not a gzip stream";
                        z2.istate.marker = 5;
                        continue block33;
                    }
                    z2.istate.mode = 16;
                }
                case 16: {
                    if (z2.avail_in == 0) {
                        return r;
                    }
                    r = f2;
                    --z2.avail_in;
                    ++z2.total_in;
                    if ((z2.next_in[z2.next_in_index++] & 0xFF) != 8) {
                        z2.istate.mode = 13;
                        z2.msg = "unknown compression method";
                        z2.istate.marker = 5;
                        continue block33;
                    }
                    z2.istate.mode = 17;
                }
                case 17: {
                    if (z2.avail_in == 0) {
                        return r;
                    }
                    r = f2;
                    --z2.avail_in;
                    ++z2.total_in;
                    this.gzipFlag = z2.next_in[z2.next_in_index++] & 0xFF;
                    if ((this.gzipFlag & 0xE2) != 0) {
                        z2.istate.mode = 13;
                        z2.msg = "unsupported flag";
                        z2.istate.marker = 5;
                        continue block33;
                    }
                    this.gzipBytesToRead = 6;
                    z2.istate.mode = 18;
                }
                case 18: {
                    while (this.gzipBytesToRead > 0) {
                        if (z2.avail_in == 0) {
                            return r;
                        }
                        r = f2;
                        --z2.avail_in;
                        ++z2.total_in;
                        ++z2.next_in_index;
                        --this.gzipBytesToRead;
                    }
                    z2.istate.mode = 19;
                    this.gzipXLen = 0;
                    this.gzipBytesToRead = 2;
                }
                case 19: {
                    if ((this.gzipFlag & 4) != 0) {
                        while (this.gzipBytesToRead > 0) {
                            if (z2.avail_in == 0) {
                                return r;
                            }
                            r = f2;
                            --z2.avail_in;
                            ++z2.total_in;
                            this.gzipXLen |= (z2.next_in[z2.next_in_index++] & 0xFF) << (1 - this.gzipBytesToRead) * 8;
                            --this.gzipBytesToRead;
                        }
                        this.gzipBytesToRead = this.gzipXLen;
                        z2.istate.mode = 20;
                    } else {
                        z2.istate.mode = 21;
                        continue block33;
                    }
                }
                case 20: {
                    while (this.gzipBytesToRead > 0) {
                        if (z2.avail_in == 0) {
                            return r;
                        }
                        r = f2;
                        --z2.avail_in;
                        ++z2.total_in;
                        ++z2.next_in_index;
                        --this.gzipBytesToRead;
                    }
                    z2.istate.mode = 21;
                }
                case 21: {
                    if ((this.gzipFlag & 8) != 0) {
                        do {
                            if (z2.avail_in == 0) {
                                return r;
                            }
                            r = f2;
                            --z2.avail_in;
                            ++z2.total_in;
                        } while (z2.next_in[z2.next_in_index++] != 0);
                    }
                    z2.istate.mode = 22;
                }
                case 22: {
                    if ((this.gzipFlag & 0x10) != 0) {
                        do {
                            if (z2.avail_in == 0) {
                                return r;
                            }
                            r = f2;
                            --z2.avail_in;
                            ++z2.total_in;
                        } while (z2.next_in[z2.next_in_index++] != 0);
                    }
                    this.gzipBytesToRead = 2;
                    z2.istate.mode = 23;
                }
                case 23: {
                    if ((this.gzipFlag & 2) != 0) {
                        while (this.gzipBytesToRead > 0) {
                            if (z2.avail_in == 0) {
                                return r;
                            }
                            r = f2;
                            --z2.avail_in;
                            ++z2.total_in;
                            ++z2.next_in_index;
                            --this.gzipBytesToRead;
                        }
                    }
                    z2.istate.mode = 7;
                    continue block33;
                }
                case 24: {
                    while (this.gzipBytesToRead > 0) {
                        if (z2.avail_in == 0) {
                            return r;
                        }
                        r = f2;
                        --z2.avail_in;
                        ++z2.total_in;
                        --this.gzipBytesToRead;
                        z2.istate.gzipCRC32 |= (z2.next_in[z2.next_in_index++] & 0xFF) << (3 - this.gzipBytesToRead) * 8;
                    }
                    if (z2.crc32 != z2.istate.gzipCRC32) {
                        z2.istate.mode = 13;
                        z2.msg = "incorrect CRC32 checksum";
                        z2.istate.marker = 5;
                        continue block33;
                    }
                    this.gzipBytesToRead = 4;
                    z2.istate.mode = 25;
                }
                case 25: {
                    while (this.gzipBytesToRead > 0) {
                        if (z2.avail_in == 0) {
                            return r;
                        }
                        r = f2;
                        --z2.avail_in;
                        ++z2.total_in;
                        --this.gzipBytesToRead;
                        z2.istate.gzipISize |= (z2.next_in[z2.next_in_index++] & 0xFF) << (3 - this.gzipBytesToRead) * 8;
                    }
                    if (this.gzipUncompressedBytes != z2.istate.gzipISize) {
                        z2.istate.mode = 13;
                        z2.msg = "incorrect ISIZE checksum";
                        z2.istate.marker = 5;
                        continue block33;
                    }
                    z2.istate.mode = 12;
                    continue block33;
                }
            }
            break;
        }
        return -2;
    }

    int inflateSetDictionary(ZStream z2, byte[] dictionary, int dictLength) {
        int index2 = 0;
        int length = dictLength;
        if (z2 == null || z2.istate == null || z2.istate.mode != 6) {
            return -2;
        }
        if (Adler32.adler32(1L, dictionary, 0, dictLength) != z2.adler) {
            return -3;
        }
        z2.adler = Adler32.adler32(0L, null, 0, 0);
        if (length >= 1 << z2.istate.wbits) {
            length = (1 << z2.istate.wbits) - 1;
            index2 = dictLength - length;
        }
        z2.istate.blocks.set_dictionary(dictionary, index2, length);
        z2.istate.mode = 7;
        return 0;
    }

    int inflateSync(ZStream z2) {
        int n;
        if (z2 == null || z2.istate == null) {
            return -2;
        }
        if (z2.istate.mode != 13) {
            z2.istate.mode = 13;
            z2.istate.marker = 0;
        }
        if ((n = z2.avail_in) == 0) {
            return -5;
        }
        int p = z2.next_in_index;
        int m = z2.istate.marker;
        while (n != 0 && m < 4) {
            m = z2.next_in[p] == mark[m] ? ++m : (z2.next_in[p] != 0 ? 0 : 4 - m);
            ++p;
            --n;
        }
        z2.total_in += (long)(p - z2.next_in_index);
        z2.next_in_index = p;
        z2.avail_in = n;
        z2.istate.marker = m;
        if (m != 4) {
            return -3;
        }
        long r = z2.total_in;
        long w = z2.total_out;
        this.inflateReset(z2);
        z2.total_in = r;
        z2.total_out = w;
        z2.istate.mode = 7;
        return 0;
    }
}

