/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.util.internal;

import java.util.regex.Pattern;

public final class SystemPropertyUtil {
    public static String get(String key) {
        try {
            return System.getProperty(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String get(String key, String def) {
        String value2 = SystemPropertyUtil.get(key);
        if (value2 == null) {
            value2 = def;
        }
        return value2;
    }

    public static int get(String key, int def) {
        String value2 = SystemPropertyUtil.get(key);
        if (value2 == null) {
            return def;
        }
        if (Pattern.matches("-?[0-9]+", value2)) {
            return Integer.parseInt(value2);
        }
        return def;
    }

    private SystemPropertyUtil() {
    }
}

