/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.util.internal;

import java.util.ArrayList;

public final class ConversionUtil {
    private static final String[] INTEGERS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"};

    public static int toInt(Object value2) {
        if (value2 instanceof Number) {
            return ((Number)value2).intValue();
        }
        return Integer.parseInt(String.valueOf(value2));
    }

    public static boolean toBoolean(Object value2) {
        if (value2 instanceof Boolean) {
            return (Boolean)value2;
        }
        if (value2 instanceof Number) {
            return ((Number)value2).intValue() != 0;
        }
        String s2 = String.valueOf(value2);
        if (s2.length() == 0) {
            return false;
        }
        try {
            return Integer.parseInt(s2) != 0;
        }
        catch (NumberFormatException numberFormatException) {
            switch (Character.toUpperCase(s2.charAt(0))) {
                case 'T': 
                case 'Y': {
                    return true;
                }
            }
            return false;
        }
    }

    public static String[] toStringArray(Object value2) {
        if (value2 instanceof String[]) {
            return (String[])value2;
        }
        if (value2 instanceof Iterable) {
            ArrayList<String> answer = new ArrayList<String>();
            for (Object v : (Iterable)value2) {
                if (v == null) {
                    answer.add(null);
                    continue;
                }
                answer.add(String.valueOf(v));
            }
            return answer.toArray(new String[answer.size()]);
        }
        return String.valueOf(value2).split("[, \\t\\n\\r\\f\\e\\a]");
    }

    public static String toString(int value2) {
        if (value2 >= 0 && value2 < INTEGERS.length) {
            return INTEGERS[value2];
        }
        return Integer.toString(value2);
    }

    private ConversionUtil() {
    }
}

