/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.logging;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.logging.InternalLogLevel;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ChannelHandler.Sharable
public class LoggingHandler
implements ChannelUpstreamHandler,
ChannelDownstreamHandler {
    private static final InternalLogLevel DEFAULT_LEVEL = InternalLogLevel.DEBUG;
    private final InternalLogger logger;
    private final InternalLogLevel level;
    private final boolean hexDump;

    public LoggingHandler() {
        this(true);
    }

    public LoggingHandler(InternalLogLevel level) {
        this(level, true);
    }

    public LoggingHandler(boolean hexDump) {
        this(DEFAULT_LEVEL, hexDump);
    }

    public LoggingHandler(InternalLogLevel level, boolean hexDump) {
        if (level == null) {
            throw new NullPointerException("level");
        }
        this.logger = InternalLoggerFactory.getInstance(this.getClass());
        this.level = level;
        this.hexDump = hexDump;
    }

    public LoggingHandler(Class<?> clazz2) {
        this(clazz2, true);
    }

    public LoggingHandler(Class<?> clazz2, boolean hexDump) {
        this(clazz2, DEFAULT_LEVEL, hexDump);
    }

    public LoggingHandler(Class<?> clazz2, InternalLogLevel level) {
        this(clazz2, level, true);
    }

    public LoggingHandler(Class<?> clazz2, InternalLogLevel level, boolean hexDump) {
        if (clazz2 == null) {
            throw new NullPointerException("clazz");
        }
        if (level == null) {
            throw new NullPointerException("level");
        }
        this.logger = InternalLoggerFactory.getInstance(clazz2);
        this.level = level;
        this.hexDump = hexDump;
    }

    public LoggingHandler(String name2) {
        this(name2, true);
    }

    public LoggingHandler(String name2, boolean hexDump) {
        this(name2, DEFAULT_LEVEL, hexDump);
    }

    public LoggingHandler(String name2, InternalLogLevel level, boolean hexDump) {
        if (name2 == null) {
            throw new NullPointerException("name");
        }
        if (level == null) {
            throw new NullPointerException("level");
        }
        this.logger = InternalLoggerFactory.getInstance(name2);
        this.level = level;
        this.hexDump = hexDump;
    }

    public InternalLogger getLogger() {
        return this.logger;
    }

    public InternalLogLevel getLevel() {
        return this.level;
    }

    public void log(ChannelEvent e) {
        if (this.getLogger().isEnabled(this.level)) {
            MessageEvent me;
            String msg = e.toString();
            if (this.hexDump && e instanceof MessageEvent && (me = (MessageEvent)e).getMessage() instanceof ChannelBuffer) {
                ChannelBuffer buf = (ChannelBuffer)me.getMessage();
                msg = msg + " - (HEXDUMP: " + ChannelBuffers.hexDump(buf) + ')';
            }
            if (e instanceof ExceptionEvent) {
                this.getLogger().log(this.level, msg, ((ExceptionEvent)e).getCause());
            } else {
                this.getLogger().log(this.level, msg);
            }
        }
    }

    @Override
    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        this.log(e);
        ctx.sendUpstream(e);
    }

    @Override
    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        this.log(e);
        ctx.sendDownstream(e);
    }
}

