/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.execution;

import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelState;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.WriteCompletionEvent;
import org.jboss.netty.handler.execution.ChannelDownstreamEventRunnable;
import org.jboss.netty.handler.execution.ChannelEventRunnable;
import org.jboss.netty.handler.execution.ChannelUpstreamEventRunnable;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.DefaultObjectSizeEstimator;
import org.jboss.netty.util.ObjectSizeEstimator;
import org.jboss.netty.util.internal.ConcurrentIdentityHashMap;
import org.jboss.netty.util.internal.QueueFactory;
import org.jboss.netty.util.internal.SharedResourceMisuseDetector;

public class MemoryAwareThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(MemoryAwareThreadPoolExecutor.class);
    private static final SharedResourceMisuseDetector misuseDetector = new SharedResourceMisuseDetector(MemoryAwareThreadPoolExecutor.class);
    private volatile Settings settings;
    private final ConcurrentMap<Channel, AtomicLong> channelCounters = new ConcurrentIdentityHashMap<Channel, AtomicLong>();
    private final Limiter totalLimiter;

    public MemoryAwareThreadPoolExecutor(int corePoolSize, long maxChannelMemorySize, long maxTotalMemorySize) {
        this(corePoolSize, maxChannelMemorySize, maxTotalMemorySize, 30L, TimeUnit.SECONDS);
    }

    public MemoryAwareThreadPoolExecutor(int corePoolSize, long maxChannelMemorySize, long maxTotalMemorySize, long keepAliveTime, TimeUnit unit2) {
        this(corePoolSize, maxChannelMemorySize, maxTotalMemorySize, keepAliveTime, unit2, Executors.defaultThreadFactory());
    }

    public MemoryAwareThreadPoolExecutor(int corePoolSize, long maxChannelMemorySize, long maxTotalMemorySize, long keepAliveTime, TimeUnit unit2, ThreadFactory threadFactory) {
        this(corePoolSize, maxChannelMemorySize, maxTotalMemorySize, keepAliveTime, unit2, new DefaultObjectSizeEstimator(), threadFactory);
    }

    public MemoryAwareThreadPoolExecutor(int corePoolSize, long maxChannelMemorySize, long maxTotalMemorySize, long keepAliveTime, TimeUnit unit2, ObjectSizeEstimator objectSizeEstimator, ThreadFactory threadFactory) {
        super(corePoolSize, corePoolSize, keepAliveTime, unit2, QueueFactory.createQueue(Runnable.class), threadFactory, new NewThreadRunsPolicy());
        if (objectSizeEstimator == null) {
            throw new NullPointerException("objectSizeEstimator");
        }
        if (maxChannelMemorySize < 0L) {
            throw new IllegalArgumentException("maxChannelMemorySize: " + maxChannelMemorySize);
        }
        if (maxTotalMemorySize < 0L) {
            throw new IllegalArgumentException("maxTotalMemorySize: " + maxTotalMemorySize);
        }
        try {
            Method m = this.getClass().getMethod("allowCoreThreadTimeOut", Boolean.TYPE);
            m.invoke((Object)this, Boolean.TRUE);
        }
        catch (Throwable t) {
            logger.debug("ThreadPoolExecutor.allowCoreThreadTimeOut() is not supported in this platform.");
        }
        this.settings = new Settings(objectSizeEstimator, maxChannelMemorySize);
        this.totalLimiter = maxTotalMemorySize == 0L ? null : new Limiter(maxTotalMemorySize);
        misuseDetector.increase();
    }

    protected void terminated() {
        super.terminated();
        misuseDetector.decrease();
    }

    public ObjectSizeEstimator getObjectSizeEstimator() {
        return this.settings.objectSizeEstimator;
    }

    public void setObjectSizeEstimator(ObjectSizeEstimator objectSizeEstimator) {
        if (objectSizeEstimator == null) {
            throw new NullPointerException("objectSizeEstimator");
        }
        this.settings = new Settings(objectSizeEstimator, this.settings.maxChannelMemorySize);
    }

    public long getMaxChannelMemorySize() {
        return this.settings.maxChannelMemorySize;
    }

    public void setMaxChannelMemorySize(long maxChannelMemorySize) {
        if (maxChannelMemorySize < 0L) {
            throw new IllegalArgumentException("maxChannelMemorySize: " + maxChannelMemorySize);
        }
        if (this.getTaskCount() > 0L) {
            throw new IllegalStateException("can't be changed after a task is executed");
        }
        this.settings = new Settings(this.settings.objectSizeEstimator, maxChannelMemorySize);
    }

    public long getMaxTotalMemorySize() {
        return this.totalLimiter.limit;
    }

    @Deprecated
    public void setMaxTotalMemorySize(long maxTotalMemorySize) {
        if (maxTotalMemorySize < 0L) {
            throw new IllegalArgumentException("maxTotalMemorySize: " + maxTotalMemorySize);
        }
        if (this.getTaskCount() > 0L) {
            throw new IllegalStateException("can't be changed after a task is executed");
        }
    }

    public void execute(Runnable command2) {
        if (command2 instanceof ChannelDownstreamEventRunnable) {
            throw new RejectedExecutionException("command must be enclosed with an upstream event.");
        }
        if (!(command2 instanceof ChannelEventRunnable)) {
            command2 = new MemoryAwareRunnable(command2);
        }
        this.increaseCounter(command2);
        this.doExecute(command2);
    }

    protected void doExecute(Runnable task) {
        this.doUnorderedExecute(task);
    }

    protected final void doUnorderedExecute(Runnable task) {
        super.execute(task);
    }

    public boolean remove(Runnable task) {
        boolean removed = super.remove(task);
        if (removed) {
            this.decreaseCounter(task);
        }
        return removed;
    }

    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        this.decreaseCounter(r);
    }

    protected void increaseCounter(Runnable task) {
        if (!this.shouldCount(task)) {
            return;
        }
        Settings settings2 = this.settings;
        long maxChannelMemorySize = settings2.maxChannelMemorySize;
        int increment = settings2.objectSizeEstimator.estimateSize(task);
        if (task instanceof ChannelEventRunnable) {
            ChannelEventRunnable eventTask = (ChannelEventRunnable)task;
            eventTask.estimatedSize = increment;
            Channel channel = eventTask.getEvent().getChannel();
            long channelCounter = this.getChannelCounter(channel).addAndGet(increment);
            if (maxChannelMemorySize != 0L && channelCounter >= maxChannelMemorySize && channel.isOpen() && channel.isReadable()) {
                ChannelHandlerContext ctx = eventTask.getContext();
                if (ctx.getHandler() instanceof ExecutionHandler) {
                    ctx.setAttachment(Boolean.TRUE);
                }
                channel.setReadable(false);
            }
        } else {
            ((MemoryAwareRunnable)task).estimatedSize = increment;
        }
        if (this.totalLimiter != null) {
            this.totalLimiter.increase(increment);
        }
    }

    protected void decreaseCounter(Runnable task) {
        if (!this.shouldCount(task)) {
            return;
        }
        Settings settings2 = this.settings;
        long maxChannelMemorySize = settings2.maxChannelMemorySize;
        int increment = task instanceof ChannelEventRunnable ? ((ChannelEventRunnable)task).estimatedSize : ((MemoryAwareRunnable)task).estimatedSize;
        if (this.totalLimiter != null) {
            this.totalLimiter.decrease(increment);
        }
        if (task instanceof ChannelEventRunnable) {
            ChannelEventRunnable eventTask = (ChannelEventRunnable)task;
            Channel channel = eventTask.getEvent().getChannel();
            long channelCounter = this.getChannelCounter(channel).addAndGet(-increment);
            if (maxChannelMemorySize != 0L && channelCounter < maxChannelMemorySize && channel.isOpen() && !channel.isReadable()) {
                ChannelHandlerContext ctx = eventTask.getContext();
                if (ctx.getHandler() instanceof ExecutionHandler) {
                    if (ctx.getAttachment() != null) {
                        ctx.setAttachment(null);
                        channel.setReadable(true);
                    }
                } else {
                    channel.setReadable(true);
                }
            }
        }
    }

    private AtomicLong getChannelCounter(Channel channel) {
        AtomicLong oldCounter;
        AtomicLong counter2 = (AtomicLong)this.channelCounters.get(channel);
        if (counter2 == null && (oldCounter = this.channelCounters.putIfAbsent(channel, counter2 = new AtomicLong())) != null) {
            counter2 = oldCounter;
        }
        if (!channel.isOpen()) {
            this.channelCounters.remove(channel);
        }
        return counter2;
    }

    protected boolean shouldCount(Runnable task) {
        if (task instanceof ChannelUpstreamEventRunnable) {
            ChannelUpstreamEventRunnable r = (ChannelUpstreamEventRunnable)task;
            ChannelEvent e = r.getEvent();
            if (e instanceof WriteCompletionEvent) {
                return false;
            }
            if (e instanceof ChannelStateEvent && ((ChannelStateEvent)e).getState() == ChannelState.INTEREST_OPS) {
                return false;
            }
        }
        return true;
    }

    private static class Limiter {
        final long limit;
        private long counter;
        private int waiters;

        Limiter(long limit) {
            this.limit = limit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void increase(long amount) {
            while (this.counter >= this.limit) {
                Object var5_3;
                ++this.waiters;
                try {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        var5_3 = null;
                        --this.waiters;
                        continue;
                    }
                    var5_3 = null;
                    --this.waiters;
                }
                catch (Throwable throwable2) {
                    var5_3 = null;
                    --this.waiters;
                    throw throwable2;
                }
            }
            this.counter += amount;
        }

        synchronized void decrease(long amount) {
            this.counter -= amount;
            if (this.counter < this.limit && this.waiters > 0) {
                this.notifyAll();
            }
        }
    }

    private static final class MemoryAwareRunnable
    implements Runnable {
        final Runnable task;
        int estimatedSize;

        MemoryAwareRunnable(Runnable task) {
            this.task = task;
        }

        public void run() {
            this.task.run();
        }
    }

    private static final class NewThreadRunsPolicy
    implements RejectedExecutionHandler {
        private NewThreadRunsPolicy() {
        }

        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            try {
                Thread t = new Thread(r, "Temporary task executor");
                t.start();
            }
            catch (Throwable e) {
                throw new RejectedExecutionException("Failed to start a new thread", e);
            }
        }
    }

    private static final class Settings {
        final ObjectSizeEstimator objectSizeEstimator;
        final long maxChannelMemorySize;

        Settings(ObjectSizeEstimator objectSizeEstimator, long maxChannelMemorySize) {
            this.objectSizeEstimator = objectSizeEstimator;
            this.maxChannelMemorySize = maxChannelMemorySize;
        }
    }
}

