/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.spdy;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.spdy.SpdyCodecUtil;
import org.jboss.netty.handler.codec.spdy.SpdyHeaderBlock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpdyHeaders {
    private static final int BUCKET_SIZE = 17;
    private final Entry[] entries = new Entry[17];
    private final Entry head;

    public static String getHeader(SpdyHeaderBlock block, String name2) {
        return block.getHeader(name2);
    }

    public static String getHeader(SpdyHeaderBlock block, String name2, String defaultValue2) {
        String value2 = block.getHeader(name2);
        if (value2 == null) {
            return defaultValue2;
        }
        return value2;
    }

    public static void setHeader(SpdyHeaderBlock block, String name2, Object value2) {
        block.setHeader(name2, value2);
    }

    public static void setHeader(SpdyHeaderBlock block, String name2, Iterable<?> values2) {
        block.setHeader(name2, values2);
    }

    public static void addHeader(SpdyHeaderBlock block, String name2, Object value2) {
        block.addHeader(name2, value2);
    }

    public static void removeMethod(SpdyHeaderBlock block) {
        block.removeHeader("method");
    }

    public static HttpMethod getMethod(SpdyHeaderBlock block) {
        try {
            return HttpMethod.valueOf(block.getHeader("method"));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setMethod(SpdyHeaderBlock block, HttpMethod method) {
        block.setHeader("method", method.getName());
    }

    public static void removeScheme(SpdyHeaderBlock block) {
        block.removeHeader("scheme");
    }

    public static String getScheme(SpdyHeaderBlock block) {
        return block.getHeader("scheme");
    }

    public static void setScheme(SpdyHeaderBlock block, String value2) {
        block.setHeader("scheme", value2);
    }

    public static void removeStatus(SpdyHeaderBlock block) {
        block.removeHeader("status");
    }

    public static HttpResponseStatus getStatus(SpdyHeaderBlock block) {
        try {
            String status = block.getHeader("status");
            int space = status.indexOf(32);
            if (space == -1) {
                return HttpResponseStatus.valueOf(Integer.parseInt(status));
            }
            int code = Integer.parseInt(status.substring(0, space));
            String reasonPhrase = status.substring(space + 1);
            HttpResponseStatus responseStatus = HttpResponseStatus.valueOf(code);
            if (responseStatus.getReasonPhrase().equals(responseStatus)) {
                return responseStatus;
            }
            return new HttpResponseStatus(code, reasonPhrase);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setStatus(SpdyHeaderBlock block, HttpResponseStatus status) {
        block.setHeader("status", status.toString());
    }

    public static void removeUrl(SpdyHeaderBlock block) {
        block.removeHeader("url");
    }

    public static String getUrl(SpdyHeaderBlock block) {
        return block.getHeader("url");
    }

    public static void setUrl(SpdyHeaderBlock block, String value2) {
        block.setHeader("url", value2);
    }

    public static void removeVersion(SpdyHeaderBlock block) {
        block.removeHeader("version");
    }

    public static HttpVersion getVersion(SpdyHeaderBlock block) {
        try {
            return HttpVersion.valueOf(block.getHeader("version"));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setVersion(SpdyHeaderBlock block, HttpVersion version) {
        block.setHeader("version", version.getText());
    }

    private static int hash(String name2) {
        int h = 0;
        for (int i = name2.length() - 1; i >= 0; --i) {
            char c = name2.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            h = 31 * h + c;
        }
        if (h > 0) {
            return h;
        }
        if (h == Integer.MIN_VALUE) {
            return Integer.MAX_VALUE;
        }
        return -h;
    }

    private static boolean eq(String name1, String name2) {
        int nameLen = name1.length();
        if (nameLen != name2.length()) {
            return false;
        }
        for (int i = nameLen - 1; i >= 0; --i) {
            char c2;
            char c1 = name1.charAt(i);
            if (c1 == (c2 = name2.charAt(i))) continue;
            if (c1 >= 'A' && c1 <= 'Z') {
                c1 = (char)(c1 + 32);
            }
            if (c2 >= 'A' && c2 <= 'Z') {
                c2 = (char)(c2 + 32);
            }
            if (c1 == c2) continue;
            return false;
        }
        return true;
    }

    private static int index(int hash2) {
        return hash2 % 17;
    }

    SpdyHeaders() {
        this.head.before = this.head.after = (this.head = new Entry(-1, null, null));
    }

    void addHeader(String name2, Object value2) {
        String lowerCaseName = name2.toLowerCase();
        SpdyCodecUtil.validateHeaderName(lowerCaseName);
        String strVal = SpdyHeaders.toString(value2);
        SpdyCodecUtil.validateHeaderValue(strVal);
        int h = SpdyHeaders.hash(lowerCaseName);
        int i = SpdyHeaders.index(h);
        this.addHeader0(h, i, lowerCaseName, strVal);
    }

    private void addHeader0(int h, int i, String name2, String value2) {
        Entry newEntry;
        Entry e = this.entries[i];
        this.entries[i] = newEntry = new Entry(h, name2, value2);
        newEntry.next = e;
        newEntry.addBefore(this.head);
    }

    void removeHeader(String name2) {
        if (name2 == null) {
            throw new NullPointerException("name");
        }
        String lowerCaseName = name2.toLowerCase();
        int h = SpdyHeaders.hash(lowerCaseName);
        int i = SpdyHeaders.index(h);
        this.removeHeader0(h, i, lowerCaseName);
    }

    private void removeHeader0(int h, int i, String name2) {
        Entry next2;
        Entry e = this.entries[i];
        if (e == null) {
            return;
        }
        while (e.hash == h && SpdyHeaders.eq(name2, e.key)) {
            e.remove();
            next2 = e.next;
            if (next2 != null) {
                this.entries[i] = next2;
                e = next2;
                continue;
            }
            this.entries[i] = null;
            return;
        }
        while ((next2 = e.next) != null) {
            if (next2.hash == h && SpdyHeaders.eq(name2, next2.key)) {
                e.next = next2.next;
                next2.remove();
                continue;
            }
            e = next2;
        }
    }

    void setHeader(String name2, Object value2) {
        String lowerCaseName = name2.toLowerCase();
        SpdyCodecUtil.validateHeaderName(lowerCaseName);
        String strVal = SpdyHeaders.toString(value2);
        SpdyCodecUtil.validateHeaderValue(strVal);
        int h = SpdyHeaders.hash(lowerCaseName);
        int i = SpdyHeaders.index(h);
        this.removeHeader0(h, i, lowerCaseName);
        this.addHeader0(h, i, lowerCaseName, strVal);
    }

    void setHeader(String name2, Iterable<?> values2) {
        if (values2 == null) {
            throw new NullPointerException("values");
        }
        String lowerCaseName = name2.toLowerCase();
        SpdyCodecUtil.validateHeaderName(lowerCaseName);
        int h = SpdyHeaders.hash(lowerCaseName);
        int i = SpdyHeaders.index(h);
        this.removeHeader0(h, i, lowerCaseName);
        for (Object v : values2) {
            if (v == null) break;
            String strVal = SpdyHeaders.toString(v);
            SpdyCodecUtil.validateHeaderValue(strVal);
            this.addHeader0(h, i, lowerCaseName, strVal);
        }
    }

    void clearHeaders() {
        for (int i = 0; i < this.entries.length; ++i) {
            this.entries[i] = null;
        }
        this.head.before = this.head.after = this.head;
    }

    String getHeader(String name2) {
        if (name2 == null) {
            throw new NullPointerException("name");
        }
        int h = SpdyHeaders.hash(name2);
        int i = SpdyHeaders.index(h);
        Entry e = this.entries[i];
        while (e != null) {
            if (e.hash == h && SpdyHeaders.eq(name2, e.key)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    List<String> getHeaders(String name2) {
        if (name2 == null) {
            throw new NullPointerException("name");
        }
        LinkedList<String> values2 = new LinkedList<String>();
        int h = SpdyHeaders.hash(name2);
        int i = SpdyHeaders.index(h);
        Entry e = this.entries[i];
        while (e != null) {
            if (e.hash == h && SpdyHeaders.eq(name2, e.key)) {
                values2.addFirst(e.value);
            }
            e = e.next;
        }
        return values2;
    }

    List<Map.Entry<String, String>> getHeaders() {
        LinkedList<Map.Entry<String, String>> all = new LinkedList<Map.Entry<String, String>>();
        Entry e = this.head.after;
        while (e != this.head) {
            all.add(e);
            e = e.after;
        }
        return all;
    }

    boolean containsHeader(String name2) {
        return this.getHeader(name2) != null;
    }

    Set<String> getHeaderNames() {
        TreeSet<String> names2 = new TreeSet<String>();
        Entry e = this.head.after;
        while (e != this.head) {
            names2.add(e.key);
            e = e.after;
        }
        return names2;
    }

    private static String toString(Object value2) {
        if (value2 == null) {
            return null;
        }
        return value2.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Entry
    implements Map.Entry<String, String> {
        final int hash;
        final String key;
        String value;
        Entry next;
        Entry before;
        Entry after;

        Entry(int hash2, String key, String value2) {
            this.hash = hash2;
            this.key = key;
            this.value = value2;
        }

        void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
        }

        void addBefore(Entry e) {
            this.after = e;
            this.before = e.before;
            this.before.after = this;
            this.after.before = this;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String setValue(String value2) {
            if (value2 == null) {
                throw new NullPointerException("value");
            }
            SpdyCodecUtil.validateHeaderValue(value2);
            String oldValue = this.value;
            this.value = value2;
            return oldValue;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    public static final class HttpNames {
        public static final String METHOD = "method";
        public static final String SCHEME = "scheme";
        public static final String STATUS = "status";
        public static final String URL = "url";
        public static final String VERSION = "version";

        private HttpNames() {
        }
    }
}

